/*
 * Decompiled with CFR 0.152.
 */
package net.pwall.util;

import java.util.Objects;
import java.util.Set;
import net.pwall.util.ImmutableCollection;

public class ImmutableSet<T>
extends ImmutableCollection<T>
implements Set<T> {
    public ImmutableSet(T[] array, int length) {
        super(array, ImmutableSet.checkLength(array, length));
    }

    public ImmutableSet(T[] array) {
        super(array, array.length);
    }

    public ImmutableSet(Set<T> set) {
        super((T[])set.toArray(new Object[0]), set.size());
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Set)) {
            return false;
        }
        Set otherSet = (Set)other;
        if (this.length != otherSet.size()) {
            return false;
        }
        for (int i = 0; i < this.length; ++i) {
            if (otherSet.contains(this.array[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        int result = 0;
        for (int i = 0; i < this.length; ++i) {
            result += Objects.hashCode(this.array[i]);
        }
        return result;
    }

    public static <TT> ImmutableSet<TT> emptySet() {
        return new ImmutableSet<Object>(emptyArray);
    }

    public static <TT> ImmutableSet<TT> setOf(TT[] array) {
        return array.length == 0 ? ImmutableSet.emptySet() : new ImmutableSet<TT>((T[])array, array.length);
    }

    public static <TT> ImmutableSet<TT> setOf(TT[] array, int length) {
        return length == 0 ? ImmutableSet.emptySet() : new ImmutableSet<TT>((T[])array, length);
    }
}

