/*
 * Decompiled with CFR 0.152.
 */
package net.pwall.util;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Objects;
import java.util.RandomAccess;
import net.pwall.util.ImmutableCollection;
import net.pwall.util.ImmutableListIterator;

public class ImmutableList<T>
extends ImmutableCollection<T>
implements List<T>,
RandomAccess {
    public ImmutableList(T[] array, int length) {
        super(array, ImmutableList.checkLength(array, length));
    }

    public ImmutableList(T[] array) {
        super(array, array.length);
    }

    public ImmutableList(List<T> list) {
        super((T[])list.toArray(new Object[0]), list.size());
    }

    @Override
    public int indexOf(Object o) {
        if (o == null) {
            for (int i = 0; i < this.length; ++i) {
                if (this.array[i] != null) continue;
                return i;
            }
        } else {
            for (int i = 0; i < this.length; ++i) {
                if (!o.equals(this.array[i])) continue;
                return i;
            }
        }
        return -1;
    }

    @Override
    public int lastIndexOf(Object o) {
        if (o == null) {
            for (int i = this.length - 1; i >= 0; --i) {
                if (this.array[i] != null) continue;
                return i;
            }
        } else {
            for (int i = this.length - 1; i >= 0; --i) {
                if (!o.equals(this.array[i])) continue;
                return i;
            }
        }
        return -1;
    }

    @Override
    public ListIterator<T> listIterator() {
        return new ImmutableListIterator<Object>(this.array, this.length, 0);
    }

    @Override
    public ListIterator<T> listIterator(int index) {
        return new ImmutableListIterator<Object>(this.array, this.length, index);
    }

    @Override
    public ImmutableList<T> subList(int fromIndex, int toIndex) {
        if (fromIndex == 0 && toIndex == this.length) {
            return this;
        }
        if (fromIndex < 0 || toIndex > this.length || toIndex < fromIndex) {
            throw new IndexOutOfBoundsException();
        }
        int newLength = toIndex - fromIndex;
        if (newLength == 0) {
            return ImmutableList.emptyList();
        }
        Object[] newArray = (Object[])Array.newInstance(this.array.getClass().getComponentType(), newLength);
        System.arraycopy(this.array, fromIndex, newArray, 0, newLength);
        return new ImmutableList<Object>(newArray);
    }

    @Override
    public void add(int index, T element) {
        throw new UnsupportedOperationException();
    }

    @Override
    public T set(int index, T element) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(int index, Collection<? extends T> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public T remove(int index) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof List)) {
            return false;
        }
        List otherList = (List)other;
        if (this.length != otherList.size()) {
            return false;
        }
        if (otherList instanceof RandomAccess) {
            for (int i = 0; i < this.length; ++i) {
                if (Objects.equals(this.array[i], otherList.get(i))) continue;
                return false;
            }
        } else {
            Iterator iterator = otherList.iterator();
            for (int i = 0; i < this.length; ++i) {
                if (Objects.equals(this.array[i], iterator.next())) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public int hashCode() {
        int result = 1;
        for (int i = 0; i < this.length; ++i) {
            result = 31 * result + Objects.hashCode(this.array[i]);
        }
        return result;
    }

    public static <TT> ImmutableList<TT> emptyList() {
        return new ImmutableList<Object>(emptyArray);
    }

    public static <TT> ImmutableList<TT> listOf(TT[] array) {
        return array.length == 0 ? ImmutableList.emptyList() : new ImmutableList<TT>(array);
    }

    public static <TT> ImmutableList<TT> listOf(TT[] array, int length) {
        return length == 0 ? ImmutableList.emptyList() : new ImmutableList<TT>((T[])array, length);
    }
}

