/*
 * Decompiled with CFR 0.152.
 */
package net.pwall.util;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import net.pwall.util.ImmutableBase;
import net.pwall.util.ImmutableCollectionBase;
import net.pwall.util.ImmutableIteratorBase;
import net.pwall.util.ImmutableMapEntry;
import net.pwall.util.ImmutableSet;

public class ImmutableMap<K, V>
extends ImmutableBase<ImmutableMapEntry<K, V>>
implements Map<K, V> {
    public static ImmutableMapEntry<?, ?>[] emptyEntryArray = new ImmutableMapEntry[0];

    public ImmutableMap(ImmutableMapEntry<K, V>[] array, int length) {
        super(array, ImmutableMap.checkLength(array, length));
    }

    public ImmutableMap(ImmutableMapEntry<K, V>[] array) {
        super(array, array.length);
    }

    @Override
    public boolean containsKey(Object key) {
        return ImmutableMap.findKey((ImmutableMapEntry[])this.array, this.length, key) >= 0;
    }

    @Override
    public boolean containsValue(Object value) {
        if (value == null) {
            for (int i = 0; i < this.length; ++i) {
                if (((ImmutableMapEntry[])this.array)[i].getValue() != null) continue;
                return true;
            }
        } else {
            for (int i = 0; i < this.length; ++i) {
                if (!value.equals(((ImmutableMapEntry[])this.array)[i].getValue())) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public V get(Object key) {
        int i = ImmutableMap.findKey((ImmutableMapEntry[])this.array, this.length, key);
        return i >= 0 ? (V)((ImmutableMapEntry[])this.array)[i].getValue() : null;
    }

    @Override
    public Set<K> keySet() {
        return new KeySet((ImmutableMapEntry[])this.array, this.length);
    }

    @Override
    public Collection<V> values() {
        return new ValueCollection((ImmutableMapEntry[])this.array, this.length);
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return new ImmutableSet<Object>((T[])this.array, this.length);
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Map)) {
            return false;
        }
        Map otherMap = (Map)other;
        if (this.length != otherMap.size()) {
            return false;
        }
        for (int i = 0; i < this.length; ++i) {
            ImmutableMapEntry entry = ((ImmutableMapEntry[])this.array)[i];
            if (Objects.equals(otherMap.get(entry.getKey()), entry.getValue())) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        int result = 0;
        for (int i = 0; i < this.length; ++i) {
            result += ((ImmutableMapEntry[])this.array)[i].hashCode();
        }
        return result;
    }

    public String toString() {
        if (this.length == 0) {
            return "{}";
        }
        StringBuilder sb = new StringBuilder(this.length * 16);
        sb.append('{');
        int i = 0;
        while (true) {
            ImmutableMapEntry entry = ((ImmutableMapEntry[])this.array)[i];
            sb.append(this.stringOf(entry.getKey()));
            sb.append('=');
            sb.append(this.stringOf(entry.getValue()));
            if (++i >= this.length) break;
            sb.append(',').append(' ');
        }
        sb.append('}');
        return sb.toString();
    }

    private String stringOf(Object obj) {
        return obj == this ? "(this Map)" : String.valueOf(obj);
    }

    @Override
    public V put(K key, V value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public V remove(Object key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        throw new UnsupportedOperationException();
    }

    public static <KK, VV> ImmutableMap<KK, VV> from(List<ImmutableMapEntry<KK, VV>> list) {
        return list.isEmpty() ? ImmutableMap.emptyMap() : new ImmutableMap(list.toArray(new ImmutableMapEntry[0]));
    }

    public static <KK, VV> ImmutableMap<KK, VV> emptyMap() {
        return new ImmutableMap(emptyEntryArray);
    }

    public static <KK, VV> ImmutableMap<KK, VV> mapOf(ImmutableMapEntry<KK, VV>[] array) {
        return array.length == 0 ? ImmutableMap.emptyMap() : new ImmutableMap<KK, VV>(array, array.length);
    }

    public static <KK, VV> ImmutableMap<KK, VV> mapOf(ImmutableMapEntry<KK, VV>[] array, int length) {
        return length == 0 ? ImmutableMap.emptyMap() : new ImmutableMap<KK, VV>(array, length);
    }

    public static <KK, VV> ImmutableMapEntry<KK, VV> entry(KK key, VV value) {
        return new ImmutableMapEntry<KK, VV>(key, value);
    }

    public static <KK, VV> ImmutableMapEntry<KK, VV>[] createArray(int length) {
        return new ImmutableMapEntry[length];
    }

    public static <KK, VV> boolean containsKey(ImmutableMapEntry<KK, VV>[] array, int length, KK key) {
        return ImmutableMap.findKey(array, length, key) >= 0;
    }

    public static <KK, VV> boolean containsKey(List<ImmutableMapEntry<KK, VV>> list, KK key) {
        for (ImmutableMapEntry<KK, VV> entry : list) {
            if (!Objects.equals(entry.getKey(), key)) continue;
            return true;
        }
        return false;
    }

    public static <KK, VV> int findKey(ImmutableMapEntry<KK, VV>[] array, int length, Object key) {
        if (key == null) {
            for (int i = 0; i < length; ++i) {
                if (array[i].getKey() != null) continue;
                return i;
            }
        } else {
            for (int i = 0; i < length; ++i) {
                if (!key.equals(array[i].getKey())) continue;
                return i;
            }
        }
        return -1;
    }

    public static class ValueIterator<K, V>
    extends ImmutableIteratorBase<ImmutableMapEntry<K, V>>
    implements Iterator<V> {
        ValueIterator(ImmutableMapEntry<K, V>[] array, int length) {
            super(array, length, 0);
        }

        @Override
        public V next() {
            return ((ImmutableMapEntry)this.checkNext()).getValue();
        }
    }

    public static class ValueCollection<K, V>
    extends ImmutableCollectionBase<ImmutableMapEntry<K, V>, V>
    implements Collection<V> {
        ValueCollection(ImmutableMapEntry<K, V>[] array, int length) {
            super(array, length);
        }

        @Override
        public boolean contains(Object o) {
            if (o == null) {
                for (int i = 0; i < this.length; ++i) {
                    if (((ImmutableMapEntry[])this.array)[i].getValue() != null) continue;
                    return true;
                }
            } else {
                for (int i = 0; i < this.length; ++i) {
                    if (!o.equals(((ImmutableMapEntry[])this.array)[i].getValue())) continue;
                    return true;
                }
            }
            return false;
        }

        @Override
        public Iterator<V> iterator() {
            return new ValueIterator((ImmutableMapEntry[])this.array, this.length);
        }

        @Override
        public Object[] toArray() {
            Object[] newArray = new Object[this.length];
            for (int i = 0; i < this.length; ++i) {
                newArray[i] = ((ImmutableMapEntry[])this.array)[i].getValue();
            }
            return newArray;
        }

        @Override
        public <T> T[] toArray(T[] a) {
            if (a.length < this.length) {
                Object[] newArray = (Object[])Array.newInstance(a.getClass().getComponentType(), this.length);
                this.copyValues(newArray);
                return newArray;
            }
            this.copyValues(a);
            if (a.length > this.length) {
                a[this.length] = null;
            }
            return a;
        }

        private <T> void copyValues(T[] target) {
            for (int i = 0; i < this.length; ++i) {
                target[i] = ((ImmutableMapEntry[])this.array)[i].getValue();
            }
        }
    }

    public static class KeyIterator<K, V>
    extends ImmutableIteratorBase<ImmutableMapEntry<K, V>>
    implements Iterator<K> {
        KeyIterator(ImmutableMapEntry<K, V>[] array, int length) {
            super(array, length, 0);
        }

        @Override
        public K next() {
            return ((ImmutableMapEntry)this.checkNext()).getKey();
        }
    }

    public static class KeySet<K, V>
    extends ImmutableCollectionBase<ImmutableMapEntry<K, V>, K>
    implements Set<K> {
        KeySet(ImmutableMapEntry<K, V>[] array, int length) {
            super(array, length);
        }

        @Override
        public boolean contains(Object o) {
            if (o == null) {
                for (int i = 0; i < this.length; ++i) {
                    if (((ImmutableMapEntry[])this.array)[i].getKey() != null) continue;
                    return true;
                }
            } else {
                for (int i = 0; i < this.length; ++i) {
                    if (!o.equals(((ImmutableMapEntry[])this.array)[i].getKey())) continue;
                    return true;
                }
            }
            return false;
        }

        @Override
        public Iterator<K> iterator() {
            return new KeyIterator((ImmutableMapEntry[])this.array, this.length);
        }

        @Override
        public Object[] toArray() {
            Object[] newArray = new Object[this.length];
            for (int i = 0; i < this.length; ++i) {
                newArray[i] = ((ImmutableMapEntry[])this.array)[i].getKey();
            }
            return newArray;
        }

        @Override
        public <T> T[] toArray(T[] a) {
            if (a.length < this.length) {
                Object[] newArray = (Object[])Array.newInstance(a.getClass().getComponentType(), this.length);
                this.copyKeys(newArray);
                return newArray;
            }
            this.copyKeys(a);
            if (a.length > this.length) {
                a[this.length] = null;
            }
            return a;
        }

        private <T> void copyKeys(T[] target) {
            for (int i = 0; i < this.length; ++i) {
                target[i] = ((ImmutableMapEntry[])this.array)[i].getKey();
            }
        }

        @Override
        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Set)) {
                return false;
            }
            Set otherSet = (Set)other;
            if (this.length != otherSet.size()) {
                return false;
            }
            for (int i = 0; i < this.length; ++i) {
                if (otherSet.contains(((ImmutableMapEntry[])this.array)[i].getKey())) continue;
                return false;
            }
            return true;
        }

        @Override
        public int hashCode() {
            int result = 0;
            for (int i = 0; i < this.length; ++i) {
                result += Objects.hashCode(((ImmutableMapEntry[])this.array)[i].getKey());
            }
            return result;
        }
    }
}

