/*
 * Decompiled with CFR 0.152.
 */
package net.pwall.util;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import net.pwall.util.ImmutableBase;
import net.pwall.util.ImmutableCollectionBase;
import net.pwall.util.ImmutableIteratorBase;
import net.pwall.util.ImmutableSet;

public class ImmutableMap<K, V>
extends ImmutableBase<MapEntry<K, V>>
implements Map<K, V> {
    public static MapEntry<?, ?>[] emptyEntryArray = new MapEntry[0];

    public ImmutableMap(MapEntry<K, V>[] array, int length) {
        super(array, ImmutableMap.checkLength(array, length));
    }

    public ImmutableMap(MapEntry<K, V>[] array) {
        super(array, array.length);
    }

    @Override
    public boolean containsKey(Object key) {
        return ImmutableMap.findKey((MapEntry[])this.array, this.length, key) >= 0;
    }

    @Override
    public boolean containsValue(Object value) {
        if (value == null) {
            for (int i = 0; i < this.length; ++i) {
                if (((MapEntry[])this.array)[i].getValue() != null) continue;
                return true;
            }
        } else {
            for (int i = 0; i < this.length; ++i) {
                if (!value.equals(((MapEntry[])this.array)[i].getValue())) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public V get(Object key) {
        int i = ImmutableMap.findKey((MapEntry[])this.array, this.length, key);
        return i >= 0 ? (V)((MapEntry[])this.array)[i].getValue() : null;
    }

    @Override
    public Set<K> keySet() {
        return new KeySet((MapEntry[])this.array, this.length);
    }

    @Override
    public Collection<V> values() {
        return new ValueCollection((MapEntry[])this.array, this.length);
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return new ImmutableSet<Object>((T[])this.array, this.length);
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Map)) {
            return false;
        }
        Map otherMap = (Map)other;
        if (this.length != otherMap.size()) {
            return false;
        }
        for (int i = 0; i < this.length; ++i) {
            MapEntry entry = ((MapEntry[])this.array)[i];
            if (Objects.equals(otherMap.get(entry.getKey()), entry.getValue())) continue;
            return true;
        }
        return true;
    }

    @Override
    public int hashCode() {
        int result = 0;
        for (int i = 0; i < this.length; ++i) {
            result += ((MapEntry[])this.array)[i].hashCode();
        }
        return result;
    }

    public String toString() {
        if (this.length == 0) {
            return "{}";
        }
        StringBuilder sb = new StringBuilder(this.length * 16);
        sb.append('{');
        int i = 0;
        while (true) {
            MapEntry entry = ((MapEntry[])this.array)[i];
            Object key = entry.getKey();
            Object value = entry.getValue();
            sb.append((Object)(key == this ? "(this Map)" : key));
            sb.append('=');
            sb.append((Object)(value == this ? "(this Map)" : value));
            if (++i >= this.length) break;
            sb.append(',').append(' ');
        }
        sb.append('}');
        return sb.toString();
    }

    @Override
    public V put(K key, V value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public V remove(Object key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        throw new UnsupportedOperationException();
    }

    public static <KK, VV> ImmutableMap<KK, VV> from(List<MapEntry<KK, VV>> list) {
        return list.isEmpty() ? ImmutableMap.emptyMap() : new ImmutableMap(list.toArray(new MapEntry[0]));
    }

    public static <KK, VV> ImmutableMap<KK, VV> emptyMap() {
        return new ImmutableMap(emptyEntryArray);
    }

    public static <KK, VV> ImmutableMap<KK, VV> mapOf(MapEntry<KK, VV>[] array) {
        return array.length == 0 ? ImmutableMap.emptyMap() : new ImmutableMap<KK, VV>(array, array.length);
    }

    public static <KK, VV> ImmutableMap<KK, VV> mapOf(MapEntry<KK, VV>[] array, int length) {
        return length == 0 ? ImmutableMap.emptyMap() : new ImmutableMap<KK, VV>(array, length);
    }

    public static <KK, VV> MapEntry<KK, VV> entry(KK key, VV value) {
        return new MapEntry<KK, VV>(key, value);
    }

    public static <KK, VV> MapEntry<KK, VV>[] createArray(int length) {
        return new MapEntry[length];
    }

    public static <KK, VV> boolean containsKey(MapEntry<KK, VV>[] array, int length, KK key) {
        return ImmutableMap.findKey(array, length, key) >= 0;
    }

    public static <KK, VV> boolean containsKey(List<MapEntry<KK, VV>> list, KK key) {
        for (MapEntry<KK, VV> entry : list) {
            if (!Objects.equals(entry.getKey(), key)) continue;
            return true;
        }
        return false;
    }

    public static <KK, VV> int findKey(MapEntry<KK, VV>[] array, int length, Object key) {
        if (key == null) {
            for (int i = 0; i < length; ++i) {
                if (array[i].getKey() != null) continue;
                return i;
            }
        } else {
            for (int i = 0; i < length; ++i) {
                if (!key.equals(array[i].getKey())) continue;
                return i;
            }
        }
        return -1;
    }

    public static class ValueIterator<K, V>
    extends ImmutableIteratorBase<MapEntry<K, V>>
    implements Iterator<V> {
        ValueIterator(MapEntry<K, V>[] array, int length) {
            super(array, length, 0);
        }

        @Override
        public V next() {
            return ((MapEntry)this.checkNext()).getValue();
        }
    }

    public static class ValueCollection<K, V>
    extends ImmutableCollectionBase<MapEntry<K, V>, V>
    implements Collection<V> {
        ValueCollection(MapEntry<K, V>[] array, int length) {
            super(array, length);
        }

        @Override
        public boolean contains(Object o) {
            if (o == null) {
                for (int i = 0; i < this.length; ++i) {
                    if (((MapEntry[])this.array)[i].getValue() != null) continue;
                    return true;
                }
            } else {
                for (int i = 0; i < this.length; ++i) {
                    if (!o.equals(((MapEntry[])this.array)[i].getValue())) continue;
                    return true;
                }
            }
            return false;
        }

        @Override
        public Iterator<V> iterator() {
            return new ValueIterator((MapEntry[])this.array, this.length);
        }

        @Override
        public Object[] toArray() {
            Object[] newArray = new Object[this.length];
            for (int i = 0; i < this.length; ++i) {
                newArray[i] = ((MapEntry[])this.array)[i].getValue();
            }
            return newArray;
        }

        @Override
        public <T> T[] toArray(T[] a) {
            if (a.length < this.length) {
                Object[] newArray = (Object[])Array.newInstance(a.getClass().getComponentType(), this.length);
                this.copyValues(newArray);
                return newArray;
            }
            this.copyValues(a);
            if (a.length > this.length) {
                a[this.length] = null;
            }
            return a;
        }

        private <T> void copyValues(T[] target) {
            for (int i = 0; i < this.length; ++i) {
                target[i] = ((MapEntry[])this.array)[i].getValue();
            }
        }
    }

    public static class KeyIterator<K, V>
    extends ImmutableIteratorBase<MapEntry<K, V>>
    implements Iterator<K> {
        KeyIterator(MapEntry<K, V>[] array, int length) {
            super(array, length, 0);
        }

        @Override
        public K next() {
            return ((MapEntry)this.checkNext()).getKey();
        }
    }

    public static class KeySet<K, V>
    extends ImmutableCollectionBase<MapEntry<K, V>, K>
    implements Set<K> {
        KeySet(MapEntry<K, V>[] array, int length) {
            super(array, length);
        }

        @Override
        public boolean contains(Object o) {
            if (o == null) {
                for (int i = 0; i < this.length; ++i) {
                    if (((MapEntry[])this.array)[i].getKey() != null) continue;
                    return true;
                }
            } else {
                for (int i = 0; i < this.length; ++i) {
                    if (!o.equals(((MapEntry[])this.array)[i].getKey())) continue;
                    return true;
                }
            }
            return false;
        }

        @Override
        public Iterator<K> iterator() {
            return new KeyIterator((MapEntry[])this.array, this.length);
        }

        @Override
        public Object[] toArray() {
            Object[] newArray = new Object[this.length];
            for (int i = 0; i < this.length; ++i) {
                newArray[i] = ((MapEntry[])this.array)[i].getKey();
            }
            return newArray;
        }

        @Override
        public <T> T[] toArray(T[] a) {
            if (a.length < this.length) {
                Object[] newArray = (Object[])Array.newInstance(a.getClass().getComponentType(), this.length);
                this.copyKeys(newArray);
                return newArray;
            }
            this.copyKeys(a);
            if (a.length > this.length) {
                a[this.length] = null;
            }
            return a;
        }

        private <T> void copyKeys(T[] target) {
            for (int i = 0; i < this.length; ++i) {
                target[i] = ((MapEntry[])this.array)[i].getKey();
            }
        }

        @Override
        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Set)) {
                return false;
            }
            Set otherSet = (Set)other;
            if (this.length != otherSet.size()) {
                return false;
            }
            for (int i = 0; i < this.length; ++i) {
                if (otherSet.contains(((MapEntry[])this.array)[i].getKey())) continue;
                return false;
            }
            return true;
        }

        @Override
        public int hashCode() {
            int result = 0;
            for (int i = 0; i < this.length; ++i) {
                result += Objects.hashCode(((MapEntry[])this.array)[i].getKey());
            }
            return result;
        }
    }

    public static class MapEntry<K, V>
    implements Map.Entry<K, V> {
        private final K key;
        private final V value;

        public MapEntry(K key, V value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public V setValue(V value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Map.Entry)) {
                return false;
            }
            Map.Entry otherMapEntry = (Map.Entry)other;
            return Objects.equals(this.key, otherMapEntry.getKey()) && Objects.equals(this.value, otherMapEntry.getValue());
        }

        @Override
        public int hashCode() {
            return Objects.hashCode(this.key) ^ Objects.hashCode(this.value);
        }

        public String toString() {
            return String.valueOf(this.key) + '=' + this.value;
        }
    }
}

