/*
 * Decompiled with CFR 0.152.
 */
package net.pwall.pipeline;

import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.SourceDebugExtension;
import net.pwall.pipeline.AbstractIntCoAcceptor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0019\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0007\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0011\u0012\b\b\u0002\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0016\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0004H\u0096@\u00a2\u0006\u0002\u0010\u0010J\u0006\u0010\u0014\u001a\u00020\u000eR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\n\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\u0011\u001a\u00020\u00028VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0015"}, d2={"Lnet/pwall/pipeline/StringCoAcceptor;", "Lnet/pwall/pipeline/AbstractIntCoAcceptor;", "", "initialSize", "", "<init>", "(I)V", "charArray", "", "index", "size", "getSize", "()I", "acceptInt", "", "value", "(ILkotlin/coroutines/Continuation;)Ljava/lang/Object;", "result", "getResult", "()Ljava/lang/String;", "reset", "co-pipelines"})
@SourceDebugExtension(value={"SMAP\nCoStrings.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CoStrings.kt\nnet/pwall/pipeline/StringCoAcceptor\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,173:1\n1#2:174\n*E\n"})
public final class StringCoAcceptor
extends AbstractIntCoAcceptor<String> {
    private final int initialSize;
    @NotNull
    private char[] charArray;
    private int index;

    public StringCoAcceptor(int initialSize) {
        this.initialSize = initialSize;
        int n = this.initialSize;
        if (!(8 <= n ? n < 65537 : false)) {
            boolean bl = false;
            String string = "Size out of range (8..65536) - " + this.initialSize;
            throw new IllegalArgumentException(string.toString());
        }
        this.charArray = new char[this.initialSize];
    }

    public /* synthetic */ StringCoAcceptor(int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            n = 2048;
        }
        this(n);
    }

    public final int getSize() {
        return this.index;
    }

    @Override
    @Nullable
    public Object acceptInt(int value, @NotNull Continuation<? super Unit> $completion) {
        if (this.index == this.charArray.length) {
            int n = 0;
            int it = this.index;
            boolean bl = false;
            int n2 = it < 65536 ? it * 2 : it + 65536;
            char[] cArray = new char[n2];
            while (n < n2) {
                int n3 = n;
                cArray[n3] = n3 < this.index ? this.charArray[n3] : (char)'\u0000';
                ++n;
            }
            char[] newArray = cArray;
            this.charArray = newArray;
        }
        int n = this.index;
        this.index = n + 1;
        this.charArray[n] = (char)value;
        return Unit.INSTANCE;
    }

    @Override
    @NotNull
    public String getResult() {
        return new String(this.charArray, 0, this.index);
    }

    public final void reset() {
        this.charArray = new char[this.initialSize];
        this.index = 0;
    }

    public StringCoAcceptor() {
        this(0, 1, null);
    }
}

