/*
 * Decompiled with CFR 0.152.
 */
package net.pwall.pipeline.codec;

import java.nio.charset.Charset;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import net.pwall.pipeline.IntCoAcceptor;
import net.pwall.pipeline.IntCoPipeline;
import net.pwall.pipeline.codec.CoASCII_UTF16;
import net.pwall.pipeline.codec.CoISO8859_15_UTF16;
import net.pwall.pipeline.codec.CoISO8859_1_UTF16;
import net.pwall.pipeline.codec.CoUTF8_UTF16;
import net.pwall.pipeline.codec.CoWindows1252_UTF16;
import net.pwall.pipeline.codec.ErrorStrategy;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J2\u0010\u0003\u001a\b\u0012\u0004\u0012\u0002H\u00050\u0004\"\u0004\b\u0000\u0010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u0002H\u00050\t2\b\b\u0002\u0010\n\u001a\u00020\u000bJ2\u0010\u0003\u001a\b\u0012\u0004\u0012\u0002H\u00050\u0004\"\u0004\b\u0000\u0010\u00052\u0006\u0010\f\u001a\u00020\r2\f\u0010\b\u001a\b\u0012\u0004\u0012\u0002H\u00050\t2\b\b\u0002\u0010\n\u001a\u00020\u000b\u00a8\u0006\u000e"}, d2={"Lnet/pwall/pipeline/codec/CoDecoderFactory;", "", "()V", "getDecoder", "Lnet/pwall/pipeline/IntCoPipeline;", "R", "charset", "Ljava/nio/charset/Charset;", "downstream", "Lnet/pwall/pipeline/IntCoAcceptor;", "errorStrategy", "Lnet/pwall/pipeline/codec/ErrorStrategy;", "charsetName", "", "co-pipelines"})
public final class CoDecoderFactory {
    @NotNull
    public static final CoDecoderFactory INSTANCE = new CoDecoderFactory();

    private CoDecoderFactory() {
    }

    @NotNull
    public final <R> IntCoPipeline<R> getDecoder(@NotNull String charsetName, @NotNull IntCoAcceptor<? extends R> downstream, @NotNull ErrorStrategy errorStrategy) {
        Intrinsics.checkNotNullParameter((Object)charsetName, (String)"charsetName");
        Intrinsics.checkNotNullParameter(downstream, (String)"downstream");
        Intrinsics.checkNotNullParameter((Object)errorStrategy, (String)"errorStrategy");
        return StringsKt.equals((String)charsetName, (String)"windows-1252", (boolean)true) ? (IntCoPipeline)new CoWindows1252_UTF16<R>(downstream, errorStrategy) : (StringsKt.equals((String)charsetName, (String)"ISO-8859-1", (boolean)true) ? (IntCoPipeline)new CoISO8859_1_UTF16<R>(downstream, errorStrategy) : (StringsKt.equals((String)charsetName, (String)"ISO-8859-15", (boolean)true) ? (IntCoPipeline)new CoISO8859_15_UTF16<R>(downstream, errorStrategy) : (StringsKt.equals((String)charsetName, (String)"US-ASCII", (boolean)true) ? (IntCoPipeline)new CoASCII_UTF16<R>(downstream, errorStrategy) : (IntCoPipeline)new CoUTF8_UTF16<R>(downstream, errorStrategy))));
    }

    public static /* synthetic */ IntCoPipeline getDecoder$default(CoDecoderFactory coDecoderFactory, String string, IntCoAcceptor intCoAcceptor, ErrorStrategy errorStrategy, int n, Object object) {
        if ((n & 4) != 0) {
            ErrorStrategy errorStrategy2 = ErrorStrategy.THROW_EXCEPTION;
            Intrinsics.checkNotNullExpressionValue((Object)errorStrategy2, (String)"THROW_EXCEPTION");
            errorStrategy = errorStrategy2;
        }
        return coDecoderFactory.getDecoder(string, intCoAcceptor, errorStrategy);
    }

    @NotNull
    public final <R> IntCoPipeline<R> getDecoder(@NotNull Charset charset, @NotNull IntCoAcceptor<? extends R> downstream, @NotNull ErrorStrategy errorStrategy) {
        Intrinsics.checkNotNullParameter((Object)charset, (String)"charset");
        Intrinsics.checkNotNullParameter(downstream, (String)"downstream");
        Intrinsics.checkNotNullParameter((Object)errorStrategy, (String)"errorStrategy");
        String string = charset.name();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"charset.name()");
        return this.getDecoder(string, downstream, errorStrategy);
    }

    public static /* synthetic */ IntCoPipeline getDecoder$default(CoDecoderFactory coDecoderFactory, Charset charset, IntCoAcceptor intCoAcceptor, ErrorStrategy errorStrategy, int n, Object object) {
        if ((n & 4) != 0) {
            ErrorStrategy errorStrategy2 = ErrorStrategy.THROW_EXCEPTION;
            Intrinsics.checkNotNullExpressionValue((Object)errorStrategy2, (String)"THROW_EXCEPTION");
            errorStrategy = errorStrategy2;
        }
        return coDecoderFactory.getDecoder(charset, intCoAcceptor, errorStrategy);
    }
}

