/*
 * Decompiled with CFR 0.152.
 */
package net.pwall.pipeline.codec;

import java.nio.charset.Charset;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.pwall.pipeline.IntCoAcceptor;
import net.pwall.pipeline.IntCoPipeline;
import net.pwall.pipeline.codec.CoCodePoint_ASCII;
import net.pwall.pipeline.codec.CoCodePoint_UTF16;
import net.pwall.pipeline.codec.CoCodePoint_UTF8;
import net.pwall.pipeline.codec.CoCodepoint_ISO8859_1;
import net.pwall.pipeline.codec.CoCodepoint_ISO8859_15;
import net.pwall.pipeline.codec.CoCodepoint_Windows1252;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J(\u0010\u0003\u001a\b\u0012\u0004\u0012\u0002H\u00050\u0004\"\u0004\b\u0000\u0010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u0002H\u00050\tJ(\u0010\u0003\u001a\b\u0012\u0004\u0012\u0002H\u00050\u0004\"\u0004\b\u0000\u0010\u00052\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\b\u001a\b\u0012\u0004\u0012\u0002H\u00050\t\u00a8\u0006\f"}, d2={"Lnet/pwall/pipeline/codec/CoEncoderFactory;", "", "()V", "getEncoder", "Lnet/pwall/pipeline/IntCoPipeline;", "R", "charset", "Ljava/nio/charset/Charset;", "downstream", "Lnet/pwall/pipeline/IntCoAcceptor;", "charsetName", "", "co-pipelines"})
public final class CoEncoderFactory {
    @NotNull
    public static final CoEncoderFactory INSTANCE = new CoEncoderFactory();

    private CoEncoderFactory() {
    }

    @NotNull
    public final <R> IntCoPipeline<R> getEncoder(@NotNull String charsetName, @NotNull IntCoAcceptor<? extends R> downstream) {
        IntCoPipeline intCoPipeline;
        Intrinsics.checkNotNullParameter((Object)charsetName, (String)"charsetName");
        Intrinsics.checkNotNullParameter(downstream, (String)"downstream");
        switch (charsetName) {
            case "windows-1252": {
                intCoPipeline = new CoCodepoint_Windows1252<R>(downstream);
                break;
            }
            case "ISO-8859-1": {
                intCoPipeline = new CoCodepoint_ISO8859_1<R>(downstream);
                break;
            }
            case "ISO-8859-15": {
                intCoPipeline = new CoCodepoint_ISO8859_15<R>(downstream);
                break;
            }
            case "US-ASCII": {
                intCoPipeline = new CoCodePoint_ASCII<R>(downstream);
                break;
            }
            case "UTF-16": {
                intCoPipeline = new CoCodePoint_UTF16<R>(downstream);
                break;
            }
            default: {
                intCoPipeline = new CoCodePoint_UTF8<R>(downstream);
            }
        }
        return intCoPipeline;
    }

    @NotNull
    public final <R> IntCoPipeline<R> getEncoder(@NotNull Charset charset, @NotNull IntCoAcceptor<? extends R> downstream) {
        Intrinsics.checkNotNullParameter((Object)charset, (String)"charset");
        Intrinsics.checkNotNullParameter(downstream, (String)"downstream");
        String string = charset.name();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"charset.name()");
        return this.getEncoder(string, downstream);
    }
}

