/*
 * Decompiled with CFR 0.152.
 */
package net.pwall.pipeline;

import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.DefaultConstructorMarker;
import net.pwall.pipeline.AbstractIntCoAcceptor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0019\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\u0012\b\b\u0002\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0019\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0004H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0012J\u0006\u0010\u0013\u001a\u00020\u0010R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\u00028VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u0014"}, d2={"Lnet/pwall/pipeline/StringCoAcceptor;", "Lnet/pwall/pipeline/AbstractIntCoAcceptor;", "", "initialSize", "", "(I)V", "charArray", "", "index", "result", "getResult", "()Ljava/lang/String;", "size", "getSize", "()I", "acceptInt", "", "value", "(ILkotlin/coroutines/Continuation;)Ljava/lang/Object;", "reset", "co-pipelines"})
public final class StringCoAcceptor
extends AbstractIntCoAcceptor<String> {
    private final int initialSize;
    @NotNull
    private char[] charArray;
    private int index;

    public StringCoAcceptor(int initialSize) {
        this.initialSize = initialSize;
        int n = this.initialSize;
        if (!(8 <= n ? n < 65537 : false)) {
            boolean bl = false;
            String string = "Size out of range (8..65536) - " + this.initialSize;
            throw new IllegalArgumentException(string.toString());
        }
        this.charArray = new char[this.initialSize];
    }

    public /* synthetic */ StringCoAcceptor(int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            n = 2048;
        }
        this(n);
    }

    public final int getSize() {
        return this.index;
    }

    @Override
    @Nullable
    public Object acceptInt(int value, @NotNull Continuation<? super Unit> $completion) {
        if (this.index == this.charArray.length) {
            int n = 0;
            int it = this.index;
            boolean bl = false;
            int n2 = it < 65536 ? it * 2 : it + 65536;
            char[] cArray = new char[n2];
            while (n < n2) {
                int n3 = n;
                cArray[n3] = n3 < this.index ? this.charArray[n3] : (char)'\u0000';
                ++n;
            }
            char[] newArray = cArray;
            this.charArray = newArray;
        }
        int n = this.index;
        this.index = n + 1;
        this.charArray[n] = (char)value;
        return Unit.INSTANCE;
    }

    @Override
    @NotNull
    public String getResult() {
        return new String(this.charArray, 0, this.index);
    }

    public final void reset() {
        this.charArray = new char[this.initialSize];
        this.index = 0;
    }

    public StringCoAcceptor() {
        this(0, 1, null);
    }
}

