/*
 * Decompiled with CFR 0.152.
 */
package net.pwall.json;

import java.lang.annotation.Annotation;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Year;
import java.time.YearMonth;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.ranges.RangesKt;
import kotlin.reflect.KCallable;
import kotlin.reflect.KClass;
import kotlin.reflect.KClassifier;
import kotlin.reflect.KFunction;
import kotlin.reflect.KParameter;
import kotlin.reflect.KProperty;
import kotlin.reflect.KType;
import kotlin.reflect.full.KClasses;
import kotlin.reflect.jvm.internal.KotlinReflectionInternalError;
import kotlin.sequences.Sequence;
import net.pwall.json.JSONArray;
import net.pwall.json.JSONBoolean;
import net.pwall.json.JSONDouble;
import net.pwall.json.JSONException;
import net.pwall.json.JSONFloat;
import net.pwall.json.JSONInteger;
import net.pwall.json.JSONLong;
import net.pwall.json.JSONObject;
import net.pwall.json.JSONString;
import net.pwall.json.JSONValue;
import net.pwall.json.annotation.JSONIgnore;
import net.pwall.json.annotation.JSONName;
import net.pwall.util.Strings;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0088\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001b\n\u0000\n\u0002\u0010 \n\u0002\b\t\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0010\u0004\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J*\u0010\t\u001a\u0004\u0018\u0001H\n\"\n\b\u0000\u0010\n\u0018\u0001*\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\rH\u0082\b\u00a2\u0006\u0002\u0010\u000eJ5\u0010\t\u001a\u0004\u0018\u0001H\n\"\b\b\u0000\u0010\n*\u00020\u000b2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u0002H\n0\u00052\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\rH\u0002\u00a2\u0006\u0002\u0010\u0010J\u001c\u0010\u0011\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u00062\n\u0010\u0012\u001a\u0006\u0012\u0002\b\u00030\u0005H\u0002J\u0012\u0010\u0013\u001a\u0004\u0018\u00010\u00072\b\u0010\u0014\u001a\u0004\u0018\u00010\u0001J\u0019\u0010\u0015\u001a\u00020\u00072\n\u0010\u0016\u001a\u0006\u0012\u0002\b\u00030\u0017H\u0002\u00a2\u0006\u0002\u0010\u0018J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0002J\u0010\u0010!\u001a\u00020\u001e2\u0006\u0010\"\u001a\u00020#H\u0002J\u0018\u0010$\u001a\u00020%2\u000e\u0010&\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030'H\u0002J\u0010\u0010(\u001a\u00020\u00072\u0006\u0010)\u001a\u00020*H\u0002J,\u0010+\u001a\u00020,\"\u0004\b\u0000\u0010\n*\b\u0012\u0004\u0012\u0002H\n0-2\u0012\u0010.\u001a\u000e\u0012\u0004\u0012\u0002H\n\u0012\u0004\u0012\u00020,0/H\u0002J\f\u00100\u001a\u000201*\u000202H\u0002R>\u0010\u0003\u001a2\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u0004j\u0018\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u0006`\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00063"}, d2={"Lnet/pwall/json/JSONSerializer;", "", "()V", "toJsonCache", "Ljava/util/HashMap;", "Lkotlin/reflect/KClass;", "Lkotlin/reflect/KFunction;", "Lnet/pwall/json/JSONValue;", "Lkotlin/collections/HashMap;", "findAnnotation", "T", "", "annotations", "", "(Ljava/util/List;)Ljava/lang/annotation/Annotation;", "cls", "(Lkotlin/reflect/KClass;Ljava/util/List;)Ljava/lang/annotation/Annotation;", "findToJSON", "objClass", "serialize", "obj", "serializeArray", "array", "", "([Ljava/lang/Object;)Lnet/pwall/json/JSONValue;", "serializeBitSet", "Lnet/pwall/json/JSONArray;", "bitSet", "Ljava/util/BitSet;", "serializeCalendar", "Lnet/pwall/json/JSONString;", "cal", "Ljava/util/Calendar;", "serializeDate", "date", "Ljava/util/Date;", "serializeMap", "Lnet/pwall/json/JSONObject;", "map", "", "serializeNumber", "number", "", "forEach", "", "Ljava/util/Enumeration;", "action", "Lkotlin/Function1;", "isJSONValue", "", "Lkotlin/reflect/KType;", "json-kotlin"})
public final class JSONSerializer {
    private static final HashMap<KClass<?>, KFunction<JSONValue>> toJsonCache;
    public static final JSONSerializer INSTANCE;

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final JSONValue serialize(@Nullable Object obj) {
        if (obj == null) {
            return null;
        }
        KFunction<JSONValue> kFunction = obj;
        if (kFunction instanceof JSONValue) {
            return (JSONValue)obj;
        }
        if (kFunction instanceof CharSequence) {
            return (JSONValue)new JSONString((CharSequence)obj);
        }
        if (kFunction instanceof Character) {
            return (JSONValue)new JSONString((CharSequence)new StringBuilder().append(((Character)obj).charValue()));
        }
        if (kFunction instanceof Number) {
            return this.serializeNumber((Number)obj);
        }
        if (kFunction instanceof Boolean) {
            return (Boolean)obj != false ? (JSONValue)JSONBoolean.TRUE : (JSONValue)JSONBoolean.FALSE;
        }
        if (kFunction instanceof char[]) {
            return (JSONValue)new JSONString((CharSequence)new StringBuilder().append((char[])obj));
        }
        if (kFunction instanceof Object[]) {
            return this.serializeArray((Object[])obj);
        }
        try {
            KFunction<JSONValue> kFunction2 = this.findToJSON(Reflection.getOrCreateKotlinClass(obj.getClass()));
            if (kFunction2 != null) {
                kFunction = kFunction2;
                boolean bl = false;
                boolean bl2 = false;
                KFunction<JSONValue> it = kFunction;
                boolean bl3 = false;
                return (JSONValue)it.call(new Object[]{obj});
            }
        }
        catch (Exception e) {
            throw (Throwable)new JSONException("Error in custom toJSON - " + Reflection.getOrCreateKotlinClass(obj.getClass()).getSimpleName(), e);
        }
        KFunction<JSONValue> e = obj;
        if (e instanceof Iterable) {
            Collection<JSONValue> collection;
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = (Iterable)obj;
            boolean $i$f$map = false;
            Iterable it = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            Iterator iterator = $this$mapTo$iv$iv.iterator();
            while (iterator.hasNext()) {
                void it2;
                Object item$iv$iv;
                Object t = item$iv$iv = iterator.next();
                collection = destination$iv$iv;
                boolean bl5 = false;
                JSONValue jSONValue = INSTANCE.serialize(it2);
                collection.add(jSONValue);
            }
            collection = (List)destination$iv$iv;
            Collection collection2 = collection;
            return (JSONValue)new JSONArray(collection2);
        }
        if (e instanceof Iterator) {
            JSONArray $this$map$iv = new JSONArray();
            boolean $i$f$map = false;
            boolean bl = false;
            JSONArray $this$apply = $this$map$iv;
            boolean bl4 = false;
            Iterator $this$forEach$iv = (Iterator)obj;
            boolean $i$f$forEach = false;
            Iterator it2 = $this$forEach$iv;
            boolean bl5 = false;
            Iterator iterator = it2;
            while (iterator.hasNext()) {
                Object element$iv;
                Object it = element$iv = iterator.next();
                boolean bl6 = false;
                $this$apply.add((Object)INSTANCE.serialize(it));
            }
            return (JSONValue)$this$map$iv;
        }
        if (e instanceof Sequence) {
            JSONArray $this$map$iv = new JSONArray();
            boolean $i$f$map = false;
            boolean bl = false;
            JSONArray $this$apply = $this$map$iv;
            boolean bl7 = false;
            Sequence $this$forEach$iv = (Sequence)obj;
            boolean $i$f$forEach = false;
            Iterator it2 = $this$forEach$iv.iterator();
            while (it2.hasNext()) {
                Object element$iv2;
                Object it = element$iv2 = it2.next();
                boolean bl8 = false;
                $this$apply.add((Object)INSTANCE.serialize(it));
            }
            return (JSONValue)$this$map$iv;
        }
        if (e instanceof Enumeration) {
            JSONArray $this$map$iv = new JSONArray();
            boolean $i$f$map = false;
            boolean bl = false;
            JSONArray $this$apply = $this$map$iv;
            boolean bl9 = false;
            INSTANCE.forEach((Enumeration)obj, (Function1)new Function1<Object, Unit>($this$apply){
                final /* synthetic */ JSONArray $this_apply;

                public final void invoke(Object it) {
                    this.$this_apply.add((Object)JSONSerializer.INSTANCE.serialize(it));
                }
                {
                    this.$this_apply = jSONArray;
                    super(1);
                }
            });
            return (JSONValue)$this$map$iv;
        }
        if (e instanceof Map) {
            return (JSONValue)this.serializeMap((Map)obj);
        }
        if (e instanceof Enum) {
            return (JSONValue)new JSONString((CharSequence)obj.toString());
        }
        if (e instanceof Calendar) {
            return (JSONValue)this.serializeCalendar((Calendar)obj);
        }
        if (e instanceof Date) {
            return (JSONValue)this.serializeDate((Date)obj);
        }
        if (e instanceof Instant || e instanceof LocalDate || e instanceof LocalDateTime || e instanceof OffsetTime || e instanceof OffsetDateTime || e instanceof ZonedDateTime || e instanceof Year || e instanceof YearMonth || e instanceof UUID) {
            return (JSONValue)new JSONString((CharSequence)obj.toString());
        }
        if (e instanceof BitSet) {
            return (JSONValue)this.serializeBitSet((BitSet)obj);
        }
        JSONObject result = new JSONObject();
        Iterable $this$forEach$iv = Reflection.getOrCreateKotlinClass(obj.getClass()).getMembers();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Object value;
            Object name;
            KCallable member = (KCallable)element$iv;
            boolean bl = false;
            if (!(member instanceof KProperty)) continue;
            ArrayList combinedAnnotations = new ArrayList(member.getAnnotations());
            Object object = (KFunction)CollectionsKt.firstOrNull((Iterable)Reflection.getOrCreateKotlinClass(obj.getClass()).getConstructors());
            if (object != null && (object = object.getParameters()) != null) {
                Object v2;
                boolean element$iv2;
                Iterable it2;
                block29: {
                    it2 = (Iterable)object;
                    element$iv2 = false;
                    Iterable it = it2;
                    boolean bl8 = false;
                    for (Object t : it) {
                        KParameter it3 = (KParameter)t;
                        boolean bl10 = false;
                        if (!Intrinsics.areEqual((Object)it3.getName(), (Object)member.getName())) continue;
                        v2 = t;
                        break block29;
                    }
                    v2 = null;
                }
                if ((object = (KParameter)v2) != null) {
                    it2 = object;
                    element$iv2 = false;
                    boolean it = false;
                    Iterable it4 = it2;
                    boolean bl11 = false;
                    combinedAnnotations.addAll(it4.getAnnotations());
                }
            }
            JSONSerializer this_$iv = INSTANCE;
            boolean $i$f$findAnnotation = false;
            if (this_$iv.findAnnotation(Reflection.getOrCreateKotlinClass(JSONIgnore.class), combinedAnnotations) != null) continue;
            JSONSerializer this_$iv2 = INSTANCE;
            boolean $i$f$findAnnotation2 = false;
            Object object2 = (JSONName)this_$iv2.findAnnotation(Reflection.getOrCreateKotlinClass(JSONName.class), combinedAnnotations);
            if (object2 == null || (object2 = object2.name()) == null) {
                object2 = name = member.getName();
            }
            if ((value = ((KProperty)member).getGetter().call(new Object[]{obj})) == null) continue;
            ((Map)result).put(name, INSTANCE.serialize(value));
        }
        return (JSONValue)result;
    }

    private final <T extends Annotation> T findAnnotation(KClass<T> cls, List<? extends Annotation> annotations) {
        for (Annotation annotation : annotations) {
            if (!KClasses.isSubclassOf((KClass)Reflection.getOrCreateKotlinClass(annotation.getClass()), cls)) continue;
            return (T)annotation;
        }
        return null;
    }

    private final <T extends Annotation> T findAnnotation(List<? extends Annotation> annotations) {
        int $i$f$findAnnotation = 0;
        Intrinsics.reifiedOperationMarker((int)4, (String)"T");
        return (T)this.findAnnotation(Reflection.getOrCreateKotlinClass(Annotation.class), annotations);
    }

    private final JSONValue serializeNumber(Number number) {
        Number number2 = number;
        return number2 instanceof Integer ? (JSONValue)new JSONInteger(number.intValue()) : (number2 instanceof Long ? (JSONValue)new JSONLong(number.longValue()) : (number2 instanceof Short ? (JSONValue)new JSONInteger(number.intValue()) : (number2 instanceof Byte ? (JSONValue)new JSONInteger(number.intValue()) : (number2 instanceof Float ? (JSONValue)new JSONFloat(number.floatValue()) : (JSONValue)new JSONDouble(number.doubleValue())))));
    }

    /*
     * WARNING - void declaration
     */
    private final JSONValue serializeArray(Object[] array) {
        Collection<JSONValue> collection;
        void $this$mapTo$iv$iv;
        if (array instanceof Character[]) {
            StringBuilder stringBuilder = new StringBuilder();
            boolean bl = false;
            boolean bl2 = false;
            StringBuilder $this$apply = stringBuilder;
            boolean bl3 = false;
            Object[] $this$forEach$iv = array;
            boolean $i$f$forEach = false;
            Object[] objectArray = $this$forEach$iv;
            int n = objectArray.length;
            for (int i = 0; i < n; ++i) {
                Object element$iv;
                Object it = element$iv = objectArray[i];
                boolean bl4 = false;
                $this$apply.append(it);
            }
            StringBuilder stringBuilder2 = stringBuilder;
            CharSequence charSequence = stringBuilder2;
            return (JSONValue)new JSONString(charSequence);
        }
        Object[] $this$map$iv = array;
        boolean $i$f$map = false;
        Object[] objectArray = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        void var7_13 = $this$mapTo$iv$iv;
        int n = ((void)var7_13).length;
        for (int i = 0; i < n; ++i) {
            void it;
            void item$iv$iv;
            void var11_21 = item$iv$iv = var7_13[i];
            collection = destination$iv$iv;
            boolean bl = false;
            JSONValue jSONValue = INSTANCE.serialize(it);
            collection.add(jSONValue);
        }
        collection = (List)destination$iv$iv;
        Collection collection2 = collection;
        return (JSONValue)new JSONArray(collection2);
    }

    private final JSONObject serializeMap(Map<?, ?> map) {
        JSONObject jSONObject = new JSONObject();
        boolean bl = false;
        boolean bl2 = false;
        JSONObject $this$apply = jSONObject;
        boolean bl3 = false;
        Iterable $this$forEach$iv = map.entrySet();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Map.Entry entry = (Map.Entry)element$iv;
            boolean bl4 = false;
            ((Map)$this$apply).put(String.valueOf(entry.getKey()), INSTANCE.serialize(entry.getValue()));
        }
        return jSONObject;
    }

    private final JSONString serializeCalendar(Calendar cal) {
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = false;
        boolean bl2 = false;
        StringBuilder $this$apply = stringBuilder;
        boolean bl3 = false;
        Strings.appendPositiveInt((Appendable)$this$apply, (int)cal.get(1));
        $this$apply.append('-');
        Strings.append2Digits((Appendable)$this$apply, (int)(cal.get(2) + 1));
        $this$apply.append('-');
        Strings.append2Digits((Appendable)$this$apply, (int)cal.get(5));
        $this$apply.append('T');
        Strings.append2Digits((Appendable)$this$apply, (int)cal.get(11));
        $this$apply.append(':');
        Strings.append2Digits((Appendable)$this$apply, (int)cal.get(12));
        $this$apply.append(':');
        Strings.append2Digits((Appendable)$this$apply, (int)cal.get(13));
        $this$apply.append('.');
        Strings.append3Digits((Appendable)$this$apply, (int)cal.get(14));
        int offset = (cal.get(15) + (cal.getTimeZone().inDaylightTime(cal.getTime()) ? cal.get(16) : 0)) / 60000;
        if (offset == 0) {
            $this$apply.append('Z');
        } else {
            $this$apply.append(offset < 0 ? (char)'-' : '+');
            int absOffset = Math.abs(offset);
            Strings.append2Digits((Appendable)$this$apply, (int)(absOffset / 60));
            $this$apply.append(':');
            Strings.append2Digits((Appendable)$this$apply, (int)(absOffset % 60));
        }
        StringBuilder stringBuilder2 = stringBuilder;
        CharSequence charSequence = stringBuilder2;
        return new JSONString(charSequence);
    }

    private final JSONString serializeDate(Date date) {
        Calendar cal;
        Calendar calendar = cal = Calendar.getInstance();
        Intrinsics.checkExpressionValueIsNotNull((Object)calendar, (String)"cal");
        calendar.setTime(date);
        return this.serializeCalendar(cal);
    }

    private final JSONArray serializeBitSet(BitSet bitSet) {
        ArrayList<JSONInteger> arrayList = new ArrayList<JSONInteger>();
        boolean bl = false;
        boolean bl2 = false;
        ArrayList<JSONInteger> $this$apply = arrayList;
        boolean bl3 = false;
        Iterable $this$forEach$iv = (Iterable)RangesKt.until((int)0, (int)bitSet.length());
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            int element$iv;
            int i = element$iv = ((IntIterator)iterator).nextInt();
            boolean bl4 = false;
            if (!bitSet.get(i)) continue;
            $this$apply.add(new JSONInteger(i));
        }
        ArrayList<JSONInteger> arrayList2 = arrayList;
        Collection collection = arrayList2;
        return new JSONArray(collection);
    }

    private final KFunction<JSONValue> findToJSON(KClass<?> objClass) {
        KFunction<JSONValue> kFunction = toJsonCache.get(objClass);
        if (kFunction != null) {
            KFunction<JSONValue> kFunction2 = kFunction;
            boolean bl = false;
            boolean bl2 = false;
            KFunction<JSONValue> it = kFunction2;
            boolean bl3 = false;
            return it;
        }
        try {
            Iterable $this$forEach$iv = objClass.getMembers();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                KCallable function = (KCallable)element$iv;
                boolean bl = false;
                if (!(function instanceof KFunction) || !Intrinsics.areEqual((Object)function.getName(), (Object)"toJSON") || function.getParameters().size() != 1 || ((KParameter)function.getParameters().get(0)).getKind() != KParameter.Kind.INSTANCE || !INSTANCE.isJSONValue(function.getReturnType())) continue;
                KFunction kFunction3 = (KFunction)function;
                boolean bl4 = false;
                boolean bl5 = false;
                KFunction $this$apply = kFunction3;
                boolean bl6 = false;
                ((Map)toJsonCache).put(objClass, $this$apply);
                return kFunction3;
            }
        }
        catch (KotlinReflectionInternalError kotlinReflectionInternalError) {
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private final boolean isJSONValue(@NotNull KType $this$isJSONValue) {
        KClassifier kClassifier = $this$isJSONValue.getClassifier();
        if (kClassifier != null) {
            KClassifier kClassifier2 = kClassifier;
            boolean bl = false;
            boolean bl2 = false;
            KClassifier it = kClassifier2;
            boolean bl3 = false;
            if (it instanceof KClass) {
                return KClasses.isSubclassOf((KClass)((KClass)it), (KClass)Reflection.getOrCreateKotlinClass(JSONValue.class));
            }
        }
        return false;
    }

    private final <T> void forEach(@NotNull Enumeration<T> $this$forEach, Function1<? super T, Unit> action) {
        while ($this$forEach.hasMoreElements()) {
            action.invoke($this$forEach.nextElement());
        }
    }

    private JSONSerializer() {
    }

    static {
        JSONSerializer jSONSerializer;
        INSTANCE = jSONSerializer = new JSONSerializer();
        toJsonCache = new HashMap();
    }
}

