/*
 * Decompiled with CFR 0.152.
 */
package net.pwall.json;

import java.lang.annotation.Annotation;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Year;
import java.time.YearMonth;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.TypeIntrinsics;
import kotlin.jvm.internal.markers.KMappedMarker;
import kotlin.reflect.KAnnotatedElement;
import kotlin.reflect.KCallable;
import kotlin.reflect.KClass;
import kotlin.reflect.KClassifier;
import kotlin.reflect.KFunction;
import kotlin.reflect.KMutableProperty;
import kotlin.reflect.KParameter;
import kotlin.reflect.KType;
import kotlin.reflect.KTypeProjection;
import kotlin.reflect.full.KClasses;
import net.pwall.json.JSONArray;
import net.pwall.json.JSONBoolean;
import net.pwall.json.JSONException;
import net.pwall.json.JSONInteger;
import net.pwall.json.JSONLong;
import net.pwall.json.JSONObject;
import net.pwall.json.JSONString;
import net.pwall.json.JSONValue;
import net.pwall.json.JSONZero;
import net.pwall.json.annotation.JSONName;
import net.pwall.util.ISO8601Date;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J=\u0010\b\u001a\u0004\u0018\u0001H\t\"\b\b\u0000\u0010\t*\u00020\u00012\f\u0010\n\u001a\b\u0012\u0004\u0012\u0002H\t0\u00052\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f\u00a2\u0006\u0002\u0010\u0010J/\u0010\b\u001a\u0004\u0018\u0001H\t\"\b\b\u0000\u0010\t*\u00020\u00012\f\u0010\n\u001a\b\u0012\u0004\u0012\u0002H\t0\u00052\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f\u00a2\u0006\u0002\u0010\u0011J\u001a\u0010\b\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fJ$\u0010\b\u001a\u0004\u0018\u0001H\t\"\n\b\u0000\u0010\t\u0018\u0001*\u00020\u00012\u0006\u0010\u000e\u001a\u00020\u000fH\u0086\b\u00a2\u0006\u0002\u0010\u0014J9\u0010\u0015\u001a\u0002H\t\"\b\b\u0000\u0010\t*\u00020\u00012\f\u0010\n\u001a\b\u0012\u0004\u0012\u0002H\t0\u00052\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\u0016\u00a2\u0006\u0002\u0010\u0017J9\u0010\u0018\u001a\u0002H\t\"\b\b\u0000\u0010\t*\u00020\u00012\f\u0010\n\u001a\b\u0012\u0004\u0012\u0002H\t0\u00052\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\u0019\u00a2\u0006\u0002\u0010\u001aJ+\u0010\u001b\u001a\u0002H\t\"\b\b\u0000\u0010\t*\u00020\u00012\f\u0010\n\u001a\b\u0012\u0004\u0012\u0002H\t0\u00052\u0006\u0010\u001c\u001a\u00020\u001d\u00a2\u0006\u0002\u0010\u001eJ6\u0010\u001f\u001a\n\u0012\u0004\u0012\u0002H\t\u0018\u00010\u0006\"\b\b\u0000\u0010\t*\u00020\u00012\u0012\u0010 \u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\t0\u00060!2\u0006\u0010\u000e\u001a\u00020\u0019H\u0002J(\u0010\"\u001a\b\u0012\u0002\b\u0003\u0018\u00010#2\u0010\u0010$\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030%0!2\u0006\u0010&\u001a\u00020\u001dH\u0002J\u001a\u0010'\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00062\n\u0010\n\u001a\u0006\u0012\u0002\b\u00030\u0005H\u0002J\u001e\u0010(\u001a\u00020)2\f\u0010*\u001a\b\u0012\u0004\u0012\u00020+0\f2\u0006\u0010\u000e\u001a\u00020\u0019H\u0002J\u0014\u0010,\u001a\u00020-2\n\u0010\n\u001a\u0006\u0012\u0002\b\u00030\u0005H\u0002J\u0012\u0010.\u001a\u0004\u0018\u00010\u001d*\u0006\u0012\u0002\b\u00030#H\u0002J\u000e\u0010.\u001a\u0004\u0018\u00010\u001d*\u00020+H\u0002R:\u0010\u0003\u001a.\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0005\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00060\u0004j\u0016\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0005\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0006`\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"Lnet/pwall/json/JSONDeserializer;", "", "()V", "fromJsonCache", "Ljava/util/HashMap;", "Lkotlin/reflect/KClass;", "Lkotlin/reflect/KFunction;", "Lkotlin/collections/HashMap;", "deserialize", "T", "resultClass", "types", "", "Lkotlin/reflect/KTypeProjection;", "json", "Lnet/pwall/json/JSONValue;", "(Lkotlin/reflect/KClass;Ljava/util/List;Lnet/pwall/json/JSONValue;)Ljava/lang/Object;", "(Lkotlin/reflect/KClass;Lnet/pwall/json/JSONValue;)Ljava/lang/Object;", "resultType", "Lkotlin/reflect/KType;", "(Lnet/pwall/json/JSONValue;)Ljava/lang/Object;", "deserializeArray", "Lnet/pwall/json/JSONArray;", "(Lkotlin/reflect/KClass;Ljava/util/List;Lnet/pwall/json/JSONArray;)Ljava/lang/Object;", "deserializeObject", "Lnet/pwall/json/JSONObject;", "(Lkotlin/reflect/KClass;Ljava/util/List;Lnet/pwall/json/JSONObject;)Ljava/lang/Object;", "deserializeString", "str", "", "(Lkotlin/reflect/KClass;Ljava/lang/String;)Ljava/lang/Object;", "findBestConstructor", "constructors", "", "findFieldToSet", "Lkotlin/reflect/KMutableProperty;", "members", "Lkotlin/reflect/KCallable;", "name", "findFromJSON", "findMatchingParameters", "", "parameters", "Lkotlin/reflect/KParameter;", "isMutable", "", "aName", "json-kotlin"})
public final class JSONDeserializer {
    private static final HashMap<KClass<?>, KFunction<?>> fromJsonCache;
    public static final JSONDeserializer INSTANCE;

    @Nullable
    public final Object deserialize(@NotNull KType resultType, @Nullable JSONValue json) {
        Intrinsics.checkParameterIsNotNull((Object)resultType, (String)"resultType");
        KClassifier kClassifier = resultType.getClassifier();
        if (!(kClassifier instanceof KClass)) {
            kClassifier = null;
        }
        KClass kClass = (KClass)kClassifier;
        if (kClass == null) {
            throw (Throwable)new JSONException("Can't deserialize " + resultType);
        }
        KClass classifier = kClass;
        return this.deserialize(classifier, resultType.getArguments(), json);
    }

    @Nullable
    public final <T> T deserialize(@NotNull KClass<T> resultClass, @Nullable JSONValue json) {
        Intrinsics.checkParameterIsNotNull(resultClass, (String)"resultClass");
        return this.deserialize(resultClass, CollectionsKt.emptyList(), json);
    }

    @Nullable
    public final <T> T deserialize(@NotNull KClass<T> resultClass, @NotNull List<KTypeProjection> types, @Nullable JSONValue json) {
        Intrinsics.checkParameterIsNotNull(resultClass, (String)"resultClass");
        Intrinsics.checkParameterIsNotNull(types, (String)"types");
        if (json == null) {
            return null;
        }
        if (KClasses.isSubclassOf(resultClass, (KClass)Reflection.getOrCreateKotlinClass(JSONValue.class)) && KClasses.isSuperclassOf(resultClass, (KClass)Reflection.getOrCreateKotlinClass(json.getClass()))) {
            return (T)json;
        }
        try {
            KFunction<?> kFunction = this.findFromJSON(resultClass);
            if (kFunction != null) {
                KFunction<?> kFunction2 = kFunction;
                boolean bl = false;
                boolean bl2 = false;
                KFunction<?> it = kFunction2;
                boolean bl3 = false;
                Object object = it.call(new Object[]{KClasses.getCompanionObjectInstance(resultClass), json});
                if (object == null) {
                    throw new TypeCastException("null cannot be cast to non-null type T");
                }
                return (T)object;
            }
        }
        catch (Exception e) {
            throw (Throwable)new JSONException("Error in custom fromJSON - " + resultClass.getSimpleName(), e);
        }
        JSONValue jSONValue = json;
        if (jSONValue instanceof JSONBoolean) {
            if (Intrinsics.areEqual(resultClass, (Object)Reflection.getOrCreateKotlinClass(Boolean.TYPE))) {
                return (T)((Object)((JSONBoolean)json).booleanValue());
            }
        } else {
            if (jSONValue instanceof JSONString) {
                return this.deserializeString(resultClass, json.toString());
            }
            if (jSONValue instanceof Number) {
                KClass<T> kClass = resultClass;
                if (Intrinsics.areEqual(kClass, (Object)Reflection.getOrCreateKotlinClass(Integer.TYPE))) {
                    if (json instanceof JSONInteger || json instanceof JSONZero) {
                        return (T)((Object)((Number)json).intValue());
                    }
                } else if (Intrinsics.areEqual(kClass, (Object)Reflection.getOrCreateKotlinClass(Long.TYPE))) {
                    if (json instanceof JSONLong || json instanceof JSONInteger || json instanceof JSONZero) {
                        return (T)((Object)((Number)json).longValue());
                    }
                } else {
                    if (Intrinsics.areEqual(kClass, (Object)Reflection.getOrCreateKotlinClass(Double.TYPE))) {
                        return (T)((Object)((Number)json).doubleValue());
                    }
                    if (Intrinsics.areEqual(kClass, (Object)Reflection.getOrCreateKotlinClass(Float.TYPE))) {
                        return (T)Float.valueOf(((Number)json).floatValue());
                    }
                    if (Intrinsics.areEqual(kClass, (Object)Reflection.getOrCreateKotlinClass(Short.TYPE))) {
                        if (json instanceof JSONInteger || json instanceof JSONZero) {
                            return (T)((Object)((Number)json).shortValue());
                        }
                    } else if (Intrinsics.areEqual(kClass, (Object)Reflection.getOrCreateKotlinClass(Byte.TYPE)) && (json instanceof JSONInteger || json instanceof JSONZero)) {
                        return (T)((Object)((Number)json).byteValue());
                    }
                }
                throw (Throwable)new JSONException("Can't deserialize " + json + " as " + resultClass);
            }
            if (jSONValue instanceof JSONArray) {
                return this.deserializeArray(resultClass, types, (JSONArray)json);
            }
            if (jSONValue instanceof JSONObject) {
                return this.deserializeObject(resultClass, types, (JSONObject)json);
            }
        }
        throw (Throwable)new JSONException("Can't deserialize " + resultClass);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final <T> T deserializeString(@NotNull KClass<T> resultClass, @NotNull String str) {
        Object v14;
        boolean bl;
        Object object;
        block35: {
            Intrinsics.checkParameterIsNotNull(resultClass, (String)"resultClass");
            Intrinsics.checkParameterIsNotNull((Object)str, (String)"str");
            try {
                object = resultClass;
                if (Intrinsics.areEqual(object, (Object)Reflection.getOrCreateKotlinClass(String.class))) {
                    return (T)str;
                }
                if (Intrinsics.areEqual(object, (Object)Reflection.getOrCreateKotlinClass(Character.TYPE))) {
                    if (str.length() != 1) {
                        throw (Throwable)new JSONException("Character must be string of length 1");
                    }
                    return (T)Character.valueOf(str.charAt(0));
                }
                if (Intrinsics.areEqual(object, (Object)Reflection.getOrCreateKotlinClass(char[].class))) {
                    String string = str;
                    boolean bl2 = false;
                    char[] cArray = string.toCharArray();
                    Intrinsics.checkExpressionValueIsNotNull((Object)cArray, (String)"(this as java.lang.String).toCharArray()");
                    if (cArray == null) {
                        throw new TypeCastException("null cannot be cast to non-null type T");
                    }
                    return (T)cArray;
                }
                if (Intrinsics.areEqual(object, (Object)Reflection.getOrCreateKotlinClass(Character[].class))) {
                    int size$iv = str.length();
                    boolean $i$f$Array = false;
                    Character[] result$iv = new Character[size$iv];
                    int n = 0;
                    int n2 = result$iv.length;
                    while (n < n2) {
                        void i;
                        Character c;
                        void i$iv;
                        void var9_20 = i$iv;
                        void var12_25 = i$iv++;
                        Character[] characterArray = result$iv;
                        boolean bl3 = false;
                        characterArray[var12_25] = c = Character.valueOf(str.charAt((int)i));
                    }
                    return (T)result$iv;
                }
                if (Intrinsics.areEqual(object, (Object)Reflection.getOrCreateKotlinClass(Calendar.class))) {
                    Calendar calendar = ISO8601Date.decode((CharSequence)str);
                    if (calendar == null) {
                        throw new TypeCastException("null cannot be cast to non-null type T");
                    }
                    return (T)calendar;
                }
                if (Intrinsics.areEqual(object, (Object)Reflection.getOrCreateKotlinClass(Date.class))) {
                    Calendar calendar = ISO8601Date.decode((CharSequence)str);
                    Intrinsics.checkExpressionValueIsNotNull((Object)calendar, (String)"ISO8601Date.decode(str)");
                    Date date = calendar.getTime();
                    if (date == null) {
                        throw new TypeCastException("null cannot be cast to non-null type T");
                    }
                    return (T)date;
                }
                if (Intrinsics.areEqual(object, (Object)Reflection.getOrCreateKotlinClass(Instant.class))) {
                    Instant instant = Instant.parse(str);
                    if (instant == null) {
                        throw new TypeCastException("null cannot be cast to non-null type T");
                    }
                    return (T)instant;
                }
                if (Intrinsics.areEqual(object, (Object)Reflection.getOrCreateKotlinClass(LocalDate.class))) {
                    LocalDate localDate = LocalDate.parse(str);
                    if (localDate == null) {
                        throw new TypeCastException("null cannot be cast to non-null type T");
                    }
                    return (T)localDate;
                }
                if (Intrinsics.areEqual(object, (Object)Reflection.getOrCreateKotlinClass(LocalDateTime.class))) {
                    LocalDateTime localDateTime = LocalDateTime.parse(str);
                    if (localDateTime == null) {
                        throw new TypeCastException("null cannot be cast to non-null type T");
                    }
                    return (T)localDateTime;
                }
                if (Intrinsics.areEqual(object, (Object)Reflection.getOrCreateKotlinClass(OffsetTime.class))) {
                    OffsetTime offsetTime = OffsetTime.parse(str);
                    if (offsetTime == null) {
                        throw new TypeCastException("null cannot be cast to non-null type T");
                    }
                    return (T)offsetTime;
                }
                if (Intrinsics.areEqual(object, (Object)Reflection.getOrCreateKotlinClass(OffsetDateTime.class))) {
                    OffsetDateTime offsetDateTime = OffsetDateTime.parse(str);
                    if (offsetDateTime == null) {
                        throw new TypeCastException("null cannot be cast to non-null type T");
                    }
                    return (T)offsetDateTime;
                }
                if (Intrinsics.areEqual(object, (Object)Reflection.getOrCreateKotlinClass(ZonedDateTime.class))) {
                    ZonedDateTime zonedDateTime = ZonedDateTime.parse(str);
                    if (zonedDateTime == null) {
                        throw new TypeCastException("null cannot be cast to non-null type T");
                    }
                    return (T)zonedDateTime;
                }
                if (Intrinsics.areEqual(object, (Object)Reflection.getOrCreateKotlinClass(Year.class))) {
                    Year year = Year.parse(str);
                    if (year == null) {
                        throw new TypeCastException("null cannot be cast to non-null type T");
                    }
                    return (T)year;
                }
                if (Intrinsics.areEqual(object, (Object)Reflection.getOrCreateKotlinClass(YearMonth.class))) {
                    YearMonth yearMonth = YearMonth.parse(str);
                    if (yearMonth == null) {
                        throw new TypeCastException("null cannot be cast to non-null type T");
                    }
                    return (T)yearMonth;
                }
                if (Intrinsics.areEqual(object, (Object)Reflection.getOrCreateKotlinClass(UUID.class))) {
                    UUID uUID = UUID.fromString(str);
                    if (uUID == null) {
                        throw new TypeCastException("null cannot be cast to non-null type T");
                    }
                    return (T)uUID;
                }
            }
            catch (Exception e) {
                throw (Throwable)new JSONException("Can't deserialize \"" + str + "\" as " + resultClass, e);
            }
            if (KClasses.isSubclassOf(resultClass, (KClass)Reflection.getOrCreateKotlinClass(Enum.class))) {
                Object object2 = JvmClassMappingKt.getJavaClass(resultClass).getMethod("valueOf", Class.class, String.class).invoke(null, JvmClassMappingKt.getJavaClass(resultClass), str);
                if (object2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type T");
                }
                return (T)object2;
            }
            object = resultClass.getConstructors();
            bl = false;
            Object object3 = object;
            boolean result$iv = false;
            Iterator i$iv = object3.iterator();
            while (i$iv.hasNext()) {
                Object t = i$iv.next();
                KFunction it = (KFunction)t;
                boolean bl4 = false;
                if (!(it.getParameters().size() == 1 && Intrinsics.areEqual((Object)((KParameter)it.getParameters().get(0)).getType().getClassifier(), (Object)Reflection.getOrCreateKotlinClass(String.class)))) continue;
                v14 = t;
                break block35;
            }
            v14 = null;
        }
        KFunction kFunction = v14;
        if (kFunction != null) {
            object = kFunction;
            bl = false;
            boolean bl5 = false;
            Object $this$apply = object;
            boolean bl6 = false;
            return (T)$this$apply.call(new Object[]{str});
        }
        throw (Throwable)new JSONException("Can't deserialize \"" + str + "\" as " + resultClass);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final <T> T deserializeArray(@NotNull KClass<T> resultClass, @NotNull List<KTypeProjection> types, @NotNull JSONArray json) {
        Intrinsics.checkParameterIsNotNull(resultClass, (String)"resultClass");
        Intrinsics.checkParameterIsNotNull(types, (String)"types");
        Intrinsics.checkParameterIsNotNull((Object)json, (String)"json");
        try {
            Object object;
            KClass<T> kClass = resultClass;
            if (Intrinsics.areEqual(kClass, (Object)Reflection.getOrCreateKotlinClass(boolean[].class))) {
                int size$iv = json.size();
                boolean $i$f$BooleanArray = false;
                boolean[] result$iv = new boolean[size$iv];
                int n = 0;
                int n2 = result$iv.length;
                while (n < n2) {
                    boolean bl;
                    void i;
                    void i$iv;
                    void var10_76 = i$iv;
                    void var18_113 = i$iv++;
                    boolean[] blArray = result$iv;
                    boolean bl2 = false;
                    Boolean bl3 = (Boolean)INSTANCE.deserialize(Reflection.getOrCreateKotlinClass(Boolean.TYPE), (JSONValue)json.get((int)i));
                    if (bl3 == null) {
                        throw (Throwable)new JSONException("Can't deserialize null as Boolean");
                    }
                    blArray[var18_113] = bl = bl3.booleanValue();
                }
                object = result$iv;
            } else if (Intrinsics.areEqual(kClass, (Object)Reflection.getOrCreateKotlinClass(byte[].class))) {
                int size$iv = json.size();
                boolean $i$f$ByteArray = false;
                byte[] result$iv = new byte[size$iv];
                int i$iv = 0;
                int n = result$iv.length;
                while (i$iv < n) {
                    byte by;
                    int i = i$iv;
                    int n3 = i$iv++;
                    byte[] byArray = result$iv;
                    boolean bl = false;
                    Byte by2 = (Byte)INSTANCE.deserialize(Reflection.getOrCreateKotlinClass(Byte.TYPE), (JSONValue)json.get(i));
                    if (by2 == null) {
                        throw (Throwable)new JSONException("Can't deserialize null as Byte");
                    }
                    byArray[n3] = by = by2.byteValue();
                }
                object = result$iv;
            } else if (Intrinsics.areEqual(kClass, (Object)Reflection.getOrCreateKotlinClass(char[].class))) {
                int size$iv = json.size();
                boolean $i$f$CharArray = false;
                char[] result$iv = new char[size$iv];
                int i$iv = 0;
                int n = result$iv.length;
                while (i$iv < n) {
                    char c;
                    int i = i$iv;
                    int n4 = i$iv++;
                    char[] cArray = result$iv;
                    boolean bl = false;
                    Character c2 = (Character)INSTANCE.deserialize(Reflection.getOrCreateKotlinClass(Character.TYPE), (JSONValue)json.get(i));
                    if (c2 == null) {
                        throw (Throwable)new JSONException("Can't deserialize null as Char");
                    }
                    cArray[n4] = c = c2.charValue();
                }
                object = result$iv;
            } else if (Intrinsics.areEqual(kClass, (Object)Reflection.getOrCreateKotlinClass(double[].class))) {
                int size$iv = json.size();
                boolean $i$f$DoubleArray = false;
                double[] result$iv = new double[size$iv];
                int i$iv = 0;
                int n = result$iv.length;
                while (i$iv < n) {
                    double d;
                    int i = i$iv;
                    int n5 = i$iv++;
                    double[] dArray = result$iv;
                    boolean bl = false;
                    Double d2 = (Double)INSTANCE.deserialize(Reflection.getOrCreateKotlinClass(Double.TYPE), (JSONValue)json.get(i));
                    if (d2 == null) {
                        throw (Throwable)new JSONException("Can't deserialize null as Double");
                    }
                    dArray[n5] = d = d2.doubleValue();
                }
                object = result$iv;
            } else if (Intrinsics.areEqual(kClass, (Object)Reflection.getOrCreateKotlinClass(float[].class))) {
                int size$iv = json.size();
                boolean $i$f$FloatArray = false;
                float[] result$iv = new float[size$iv];
                int i$iv = 0;
                int n = result$iv.length;
                while (i$iv < n) {
                    float f;
                    int i = i$iv;
                    int n6 = i$iv++;
                    float[] fArray = result$iv;
                    boolean bl = false;
                    Float f2 = (Float)INSTANCE.deserialize(Reflection.getOrCreateKotlinClass(Float.TYPE), (JSONValue)json.get(i));
                    if (f2 == null) {
                        throw (Throwable)new JSONException("Can't deserialize null as Float");
                    }
                    fArray[n6] = f = f2.floatValue();
                }
                object = result$iv;
            } else if (Intrinsics.areEqual(kClass, (Object)Reflection.getOrCreateKotlinClass(int[].class))) {
                int size$iv = json.size();
                boolean $i$f$IntArray = false;
                int[] result$iv = new int[size$iv];
                int i$iv = 0;
                int n = result$iv.length;
                while (i$iv < n) {
                    int n7;
                    int i = i$iv;
                    int n8 = i$iv++;
                    int[] nArray = result$iv;
                    boolean bl = false;
                    Integer n9 = (Integer)INSTANCE.deserialize(Reflection.getOrCreateKotlinClass(Integer.TYPE), (JSONValue)json.get(i));
                    if (n9 == null) {
                        throw (Throwable)new JSONException("Can't deserialize null as Int");
                    }
                    nArray[n8] = n7 = n9.intValue();
                }
                object = result$iv;
            } else if (Intrinsics.areEqual(kClass, (Object)Reflection.getOrCreateKotlinClass(long[].class))) {
                int size$iv = json.size();
                boolean $i$f$LongArray = false;
                long[] result$iv = new long[size$iv];
                int i$iv = 0;
                int n = result$iv.length;
                while (i$iv < n) {
                    long l;
                    int i = i$iv;
                    int n10 = i$iv++;
                    long[] lArray = result$iv;
                    boolean bl = false;
                    Long l2 = (Long)INSTANCE.deserialize(Reflection.getOrCreateKotlinClass(Long.TYPE), (JSONValue)json.get(i));
                    if (l2 == null) {
                        throw (Throwable)new JSONException("Can't deserialize null as Long");
                    }
                    lArray[n10] = l = l2.longValue();
                }
                object = result$iv;
            } else if (Intrinsics.areEqual(kClass, (Object)Reflection.getOrCreateKotlinClass(short[].class))) {
                int size$iv = json.size();
                boolean $i$f$ShortArray = false;
                short[] result$iv = new short[size$iv];
                int i$iv = 0;
                int n = result$iv.length;
                while (i$iv < n) {
                    short s;
                    int i = i$iv;
                    int n11 = i$iv++;
                    short[] sArray = result$iv;
                    boolean bl = false;
                    Short s2 = (Short)INSTANCE.deserialize(Reflection.getOrCreateKotlinClass(Short.TYPE), (JSONValue)json.get(i));
                    if (s2 == null) {
                        throw (Throwable)new JSONException("Can't deserialize null as Short");
                    }
                    sArray[n11] = s = s2.shortValue();
                }
                object = result$iv;
            } else if (Intrinsics.areEqual(kClass, (Object)Reflection.getOrCreateKotlinClass(ArrayList.class))) {
                KTypeProjection kTypeProjection = (KTypeProjection)CollectionsKt.firstOrNull(types);
                if (kTypeProjection == null || (kTypeProjection = kTypeProjection.getType()) == null) {
                    throw (Throwable)new JSONException("Type not specified");
                }
                KTypeProjection type = kTypeProjection;
                ArrayList<Object> $i$f$ShortArray = new ArrayList<Object>(json.size());
                boolean result$iv = false;
                boolean i$iv = false;
                ArrayList<Object> $this$apply = $i$f$ShortArray;
                boolean bl = false;
                Iterable $this$forEach$iv = (Iterable)json;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    JSONValue it = (JSONValue)element$iv;
                    boolean bl4 = false;
                    $this$apply.add(INSTANCE.deserialize((KType)type, it));
                }
                object = $i$f$ShortArray;
            } else if (Intrinsics.areEqual(kClass, (Object)Reflection.getOrCreateKotlinClass(LinkedList.class))) {
                KTypeProjection kTypeProjection = (KTypeProjection)CollectionsKt.firstOrNull(types);
                if (kTypeProjection == null || (kTypeProjection = kTypeProjection.getType()) == null) {
                    throw (Throwable)new JSONException("Type not specified");
                }
                KTypeProjection type = kTypeProjection;
                LinkedList<Object> $i$f$ShortArray = new LinkedList<Object>();
                boolean result$iv = false;
                boolean i$iv = false;
                LinkedList<Object> $this$apply = $i$f$ShortArray;
                boolean bl = false;
                Iterable $this$forEach$iv = (Iterable)json;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    JSONValue it = (JSONValue)element$iv;
                    boolean bl5 = false;
                    $this$apply.add(INSTANCE.deserialize((KType)type, it));
                }
                object = $i$f$ShortArray;
            } else if (Intrinsics.areEqual(kClass, (Object)Reflection.getOrCreateKotlinClass(List.class))) {
                void $this$mapTo$iv$iv;
                KTypeProjection kTypeProjection = (KTypeProjection)CollectionsKt.firstOrNull(types);
                if (kTypeProjection == null || (kTypeProjection = kTypeProjection.getType()) == null) {
                    throw (Throwable)new JSONException("Type not specified");
                }
                KTypeProjection type = kTypeProjection;
                Iterable $this$map$iv = (Iterable)json;
                boolean $i$f$map = false;
                Iterable $this$apply = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    JSONValue element$iv = (JSONValue)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    Object object2 = INSTANCE.deserialize((KType)type, (JSONValue)it);
                    collection.add(object2);
                }
                List result = (List)destination$iv$iv;
                object = this.isMutable(resultClass) ? (Object)CollectionsKt.toMutableList((Collection)result) : (Object)result;
            } else if (Intrinsics.areEqual(kClass, (Object)Reflection.getOrCreateKotlinClass(HashSet.class))) {
                KTypeProjection kTypeProjection = (KTypeProjection)CollectionsKt.firstOrNull(types);
                if (kTypeProjection == null || (kTypeProjection = kTypeProjection.getType()) == null) {
                    throw (Throwable)new JSONException("Type not specified");
                }
                KTypeProjection type = kTypeProjection;
                HashSet<Object> result = new HashSet<Object>(json.size());
                boolean $this$map$iv = false;
                boolean $i$f$map = false;
                HashSet<Object> $this$apply = result;
                boolean bl = false;
                Iterable $this$forEach$iv = (Iterable)json;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    JSONValue it = (JSONValue)element$iv;
                    boolean bl6 = false;
                    $this$apply.add(INSTANCE.deserialize((KType)type, it));
                }
                object = result;
            } else if (Intrinsics.areEqual(kClass, (Object)Reflection.getOrCreateKotlinClass(LinkedHashSet.class))) {
                KTypeProjection kTypeProjection = (KTypeProjection)CollectionsKt.firstOrNull(types);
                if (kTypeProjection == null || (kTypeProjection = kTypeProjection.getType()) == null) {
                    throw (Throwable)new JSONException("Type not specified");
                }
                KTypeProjection type = kTypeProjection;
                LinkedHashSet<Object> result = new LinkedHashSet<Object>(json.size());
                boolean $this$map$iv = false;
                boolean $i$f$map = false;
                LinkedHashSet<Object> $this$apply = result;
                boolean bl = false;
                Iterable $this$forEach$iv = (Iterable)json;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    JSONValue it = (JSONValue)element$iv;
                    boolean bl7 = false;
                    $this$apply.add(INSTANCE.deserialize((KType)type, it));
                }
                object = result;
            } else if (Intrinsics.areEqual(kClass, (Object)Reflection.getOrCreateKotlinClass(Set.class))) {
                HashSet<Object> result = new HashSet<Object>(json.size());
                KTypeProjection kTypeProjection = (KTypeProjection)CollectionsKt.firstOrNull(types);
                if (kTypeProjection == null || (kTypeProjection = kTypeProjection.getType()) == null) {
                    throw (Throwable)new JSONException("Type not specified");
                }
                KTypeProjection type = kTypeProjection;
                Iterable $this$forEach$iv = (Iterable)json;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    JSONValue it = (JSONValue)element$iv;
                    boolean bl = false;
                    result.add(INSTANCE.deserialize((KType)type, it));
                }
                object = this.isMutable(resultClass) ? (Object)CollectionsKt.toMutableSet((Iterable)result) : (Object)CollectionsKt.toSet((Iterable)result);
            } else {
                throw (Throwable)new JSONException("Can't deserialize array as " + resultClass);
            }
            if (object == null) {
                throw new TypeCastException("null cannot be cast to non-null type T");
            }
            return (T)object;
        }
        catch (Exception e) {
            throw (Throwable)new JSONException("Can't deserialize array as " + resultClass, e);
        }
    }

    @NotNull
    public final <T> T deserializeObject(@NotNull KClass<T> resultClass, @NotNull List<KTypeProjection> types, @NotNull JSONObject json) {
        block13: {
            Intrinsics.checkParameterIsNotNull(resultClass, (String)"resultClass");
            Intrinsics.checkParameterIsNotNull(types, (String)"types");
            Intrinsics.checkParameterIsNotNull((Object)json, (String)"json");
            try {
                if (KClasses.isSubclassOf(resultClass, (KClass)Reflection.getOrCreateKotlinClass(Map.class))) {
                    if (types.size() != 2) {
                        throw (Throwable)new JSONException("Incorrect type arguments for Map");
                    }
                    KType kType = types.get(0).getType();
                    Object object = kType != null ? kType.getClassifier() : null;
                    if (!(object instanceof KClass)) {
                        object = null;
                    }
                    KClass kClass = (KClass)object;
                    if (kClass == null) {
                        throw (Throwable)new JSONException("Key type not specified for Map");
                    }
                    KClass keyClass = kClass;
                    KType kType2 = types.get(1).getType();
                    if (kType2 == null) {
                        throw (Throwable)new JSONException("Value type not specified for Map");
                    }
                    KType valueType = kType2;
                    HashMap result = new HashMap();
                    Iterable $this$forEach$iv = (Iterable)json;
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        String key = (String)element$iv;
                        boolean bl = false;
                        ((Map)result).put(INSTANCE.deserializeString(keyClass, key), INSTANCE.deserialize(valueType, (JSONValue)json.get((Object)key)));
                    }
                    Map map = this.isMutable(resultClass) ? MapsKt.toMutableMap((Map)result) : MapsKt.toMap((Map)result);
                    if (map == null) {
                        throw new TypeCastException("null cannot be cast to non-null type T");
                    }
                    return (T)map;
                }
                KFunction<T> kFunction = this.findBestConstructor(resultClass.getConstructors(), json);
                if (kFunction == null) break block13;
                KFunction<T> keyClass = kFunction;
                boolean bl = false;
                boolean bl2 = false;
                KFunction<T> constructor = keyClass;
                boolean bl3 = false;
                HashMap argMap = new HashMap();
                HashMap jsonCopy = new HashMap((Map)json);
                Iterable $this$forEach$iv = constructor.getParameters();
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    KParameter parameter = (KParameter)element$iv;
                    boolean bl4 = false;
                    String paramName = INSTANCE.aName(parameter);
                    Map map = jsonCopy;
                    boolean bl5 = false;
                    JSONValue jSONValue = (JSONValue)map.get(paramName);
                    if (jSONValue == null) continue;
                    map = jSONValue;
                    bl5 = false;
                    boolean bl6 = false;
                    Map it = map;
                    boolean bl7 = false;
                    ((Map)argMap).put(parameter, INSTANCE.deserialize(parameter.getType(), (JSONValue)it));
                    Map map2 = jsonCopy;
                    String string = paramName;
                    boolean bl8 = false;
                    JSONValue cfr_ignored_0 = (JSONValue)TypeIntrinsics.asMutableMap((Object)map2).remove(string);
                }
                Object instance = constructor.callBy((Map)argMap);
                Map $this$forEach$iv2 = jsonCopy;
                boolean $i$f$forEach2 = false;
                Map map = $this$forEach$iv2;
                boolean bl9 = false;
                Iterator iterator = map.entrySet().iterator();
                while (iterator.hasNext()) {
                    KMutableProperty<?> member;
                    Map.Entry element$iv;
                    Map.Entry entry = element$iv = iterator.next();
                    boolean bl10 = false;
                    if (INSTANCE.findFieldToSet(resultClass.getMembers(), (String)entry.getKey()) == null) {
                        throw (Throwable)new JSONException("Can't find property " + (String)entry.getKey() + " in " + resultClass.getSimpleName());
                    }
                    member.getSetter().call(new Object[]{instance, INSTANCE.deserialize(member.getReturnType(), (JSONValue)jsonCopy.get(entry.getKey()))});
                }
                return (T)instance;
            }
            catch (JSONException e) {
                throw (Throwable)e;
            }
            catch (Exception e) {
                throw (Throwable)new JSONException("Can't deserialize object as " + resultClass, e);
            }
        }
        throw (Throwable)new JSONException("Can't deserialize object as " + resultClass);
    }

    private final KMutableProperty<?> findFieldToSet(Collection<? extends KCallable<?>> members, String name) {
        for (KCallable<?> member : members) {
            if (!(member instanceof KMutableProperty) || !Intrinsics.areEqual((Object)this.aName((KMutableProperty)member), (Object)name)) continue;
            return (KMutableProperty)member;
        }
        return null;
    }

    private final <T> KFunction<T> findBestConstructor(Collection<? extends KFunction<? extends T>> constructors, JSONObject json) {
        KFunction<T> result = null;
        int best = -1;
        for (KFunction<T> kFunction : constructors) {
            int n;
            boolean bl;
            List parameters;
            block4: {
                parameters = kFunction.getParameters();
                Iterable $this$any$iv = parameters;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        KParameter it = (KParameter)element$iv;
                        boolean bl2 = false;
                        if (!(INSTANCE.aName(it) == null || it.getKind() != KParameter.Kind.VALUE)) continue;
                        bl = true;
                        break block4;
                    }
                    bl = false;
                }
            }
            if (bl || (n = this.findMatchingParameters(parameters, json)) <= best) continue;
            result = kFunction;
            best = n;
        }
        return result;
    }

    private final int findMatchingParameters(List<? extends KParameter> parameters, JSONObject json) {
        int n = 0;
        for (KParameter kParameter : parameters) {
            if (json.containsKey((Object)this.aName(kParameter))) {
                ++n;
                continue;
            }
            if (kParameter.isOptional()) continue;
            return -1;
        }
        return n;
    }

    private final String aName(@NotNull KParameter $this$aName) {
        Object object;
        Object v0;
        block2: {
            KAnnotatedElement $this$findAnnotation$iv = (KAnnotatedElement)$this$aName;
            boolean $i$f$findAnnotation = false;
            Iterable $this$firstOrNull$iv$iv = $this$findAnnotation$iv.getAnnotations();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv$iv : $this$firstOrNull$iv$iv) {
                Annotation it$iv = (Annotation)element$iv$iv;
                boolean bl = false;
                if (!(it$iv instanceof JSONName)) continue;
                v0 = element$iv$iv;
                break block2;
            }
            v0 = null;
        }
        if ((object = (JSONName)v0) == null || (object = object.name()) == null) {
            object = $this$aName.getName();
        }
        return object;
    }

    private final String aName(@NotNull KMutableProperty<?> $this$aName) {
        Object object;
        Object v0;
        block2: {
            KAnnotatedElement $this$findAnnotation$iv = (KAnnotatedElement)$this$aName;
            boolean $i$f$findAnnotation = false;
            Iterable $this$firstOrNull$iv$iv = $this$findAnnotation$iv.getAnnotations();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv$iv : $this$firstOrNull$iv$iv) {
                Annotation it$iv = (Annotation)element$iv$iv;
                boolean bl = false;
                if (!(it$iv instanceof JSONName)) continue;
                v0 = element$iv$iv;
                break block2;
            }
            v0 = null;
        }
        if ((object = (JSONName)v0) == null || (object = object.name()) == null) {
            object = $this$aName.getName();
        }
        return object;
    }

    private final KFunction<?> findFromJSON(KClass<?> resultClass) {
        Iterable iterable;
        Iterable newEntry;
        Iterable iterable2;
        KFunction<?> kFunction = fromJsonCache.get(resultClass);
        if (kFunction != null) {
            KFunction<?> kFunction2 = kFunction;
            boolean bl = false;
            boolean bl2 = false;
            KFunction<?> it = kFunction2;
            boolean bl3 = false;
            return it;
        }
        try {
            Iterable iterable3;
            Object object = KClasses.getCompanionObject(resultClass);
            if (object != null && (object = KClasses.getFunctions((KClass)object)) != null) {
                Object v3;
                block8: {
                    iterable2 = (Iterable)object;
                    boolean bl = false;
                    Iterable iterable4 = iterable2;
                    boolean bl3 = false;
                    for (Object t : iterable4) {
                        KFunction function = (KFunction)t;
                        boolean bl4 = false;
                        boolean bl5 = Intrinsics.areEqual((Object)function.getName(), (Object)"fromJSON") && function.getParameters().size() == 2 && Intrinsics.areEqual((Object)((KParameter)function.getParameters().get(0)).getType().getClassifier(), (Object)KClasses.getCompanionObject(resultClass)) && Intrinsics.areEqual((Object)((KParameter)function.getParameters().get(1)).getType().getClassifier(), (Object)Reflection.getOrCreateKotlinClass(JSONValue.class)) && Intrinsics.areEqual((Object)function.getReturnType().getClassifier(), resultClass);
                        if (!bl5) continue;
                        v3 = t;
                        break block8;
                    }
                    v3 = null;
                }
                iterable3 = v3;
            } else {
                iterable3 = null;
            }
            iterable2 = iterable3;
        }
        catch (Exception e) {
            iterable2 = null;
        }
        Iterable iterable5 = newEntry = iterable2;
        if (iterable5 != null) {
            iterable2 = iterable5;
            boolean bl = false;
            boolean bl6 = false;
            Iterable $this$apply = iterable2;
            boolean bl7 = false;
            ((Map)fromJsonCache).put(resultClass, $this$apply);
            iterable = iterable2;
        } else {
            iterable = null;
        }
        return iterable;
    }

    private final boolean isMutable(KClass<?> resultClass) {
        return KClasses.isSubclassOf(resultClass, (KClass)Reflection.getOrCreateKotlinClass(KMappedMarker.class));
    }

    private final <T> T deserialize(JSONValue json) {
        int $i$f$deserialize = 0;
        Intrinsics.reifiedOperationMarker((int)4, (String)"T");
        return this.deserialize(Reflection.getOrCreateKotlinClass(Object.class), json);
    }

    private JSONDeserializer() {
    }

    static {
        JSONDeserializer jSONDeserializer;
        INSTANCE = jSONDeserializer = new JSONDeserializer();
        fromJsonCache = new HashMap();
    }
}

