/*
 * Decompiled with CFR 0.152.
 */
package net.postgis.jdbc.smoketest;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import net.postgis.jdbc.java2d.Java2DWrapper;

public class Java2d {
    private static final boolean DEBUG = true;
    public static final Shape[] SHAPEARRAY = new Shape[0];
    public static final String[][] testDataset = new String[][]{{"point1", "POINT(10 11)"}, {"multipoint1", "MULTIPOINT(10.25 11,10.5 11,10.75 11,11 11,11.25 11,11.5 11,11.75 11,12 11)"}, {"linestring1", "LINESTRING(0 0,100 0,100 100,0 100)"}, {"linestring2", "LINESTRING(-310 110,210 110,210 210,-310 210,-310 110)"}, {"multilinestring", "MULTILINESTRING((0 0,10 10,20 0,30 10),(40 0,40 10,50 10,50 20,60 20))"}};

    public static void main(String[] args) throws ClassNotFoundException, SQLException {
        if (args.length != 5) {
            System.err.println("Usage: java examples/TestJava2D dburl user pass tablename column");
            System.err.println();
            System.err.println("dburl has the following format:");
            System.err.println("jdbc:postgis_j2d://HOST:PORT/DATABASENAME");
            System.err.println("tablename is 'jdbc_test' by default.");
            System.exit(1);
        }
        Shape[] geometries = Java2d.read(args[0], args[1], args[2], "SELECT " + args[4] + " FROM " + args[3]);
        System.err.println("read " + geometries.length + " geometries.");
        if (geometries.length == 0) {
            System.err.println("No geometries were read.");
            return;
        }
        System.err.println("Painting...");
        Frame window = new Frame("PostGIS java2D demo");
        GisCanvas CV = new GisCanvas(geometries);
        window.add(CV);
        window.setSize(500, 500);
        window.addWindowListener(new EventHandler());
        window.setVisible(true);
    }

    static Rectangle2D calcbbox(Shape[] geometries) {
        Rectangle2D bbox = geometries[0].getBounds2D();
        for (int i = 1; i < geometries.length; ++i) {
            bbox = bbox.createUnion(geometries[i].getBounds2D());
        }
        return bbox;
    }

    private static Shape[] read(String dburl, String dbuser, String dbpass, String query) throws ClassNotFoundException, SQLException {
        ArrayList<Shape> geometries = new ArrayList<Shape>();
        System.err.println("Creating JDBC connection...");
        Class.forName("org.postgresql.Driver");
        Connection conn = DriverManager.getConnection(dburl, dbuser, dbpass);
        System.err.println("fetching geometries: " + query);
        ResultSet r = conn.createStatement().executeQuery(query);
        while (r.next()) {
            Shape current = (Shape)r.getObject(1);
            if (current == null) continue;
            geometries.add(current);
        }
        conn.close();
        return geometries.toArray(SHAPEARRAY);
    }

    static {
        new Java2DWrapper();
    }

    public static class GisCanvas
    extends Canvas {
        private static final long serialVersionUID = 1L;
        final Rectangle2D bbox;
        final Shape[] geometries;

        public GisCanvas(Shape[] geometries) {
            this.geometries = geometries;
            this.bbox = Java2d.calcbbox(geometries);
            this.setBackground(Color.GREEN);
        }

        @Override
        public void paint(Graphics og) {
            Graphics2D g2 = (Graphics2D)og;
            double paddingTop = this.bbox.getHeight() * 0.05;
            double paddingBottom = this.bbox.getHeight() * 0.05;
            double paddingLeft = this.bbox.getWidth() * 0.05;
            double paddingRight = this.bbox.getWidth() * 0.05;
            double offsetX = this.bbox.getX() < 0.0 ? 0.0 - this.bbox.getX() : 0.0;
            double offsetY = this.bbox.getY() < 0.0 ? 0.0 - this.bbox.getY() : 0.0;
            double scaleX = ((double)super.getWidth() - (paddingLeft + paddingRight)) / this.bbox.getWidth();
            double scaleY = ((double)super.getHeight() - (paddingTop + paddingBottom)) / this.bbox.getHeight();
            AffineTransform at = new AffineTransform();
            at.translate(paddingLeft, paddingTop);
            at.scale(scaleX, scaleY);
            at.translate(offsetX, offsetY);
            System.err.println();
            System.err.println("paddingTop: " + paddingTop);
            System.err.println("paddingBottom: " + paddingBottom);
            System.err.println("paddingLeft: " + paddingLeft);
            System.err.println("paddingRight: " + paddingRight);
            System.err.println("offsetX: " + offsetX);
            System.err.println("offsetY: " + offsetY);
            System.err.println("scaleX: " + scaleX);
            System.err.println("scaleY: " + scaleY);
            System.err.println("bbox:  " + this.bbox);
            System.err.println("trans: " + at);
            System.err.println("new:   " + at.createTransformedShape(this.bbox).getBounds2D());
            System.err.println("visual:" + super.getBounds());
            for (int i = 0; i < this.geometries.length; ++i) {
                g2.setPaint(Color.BLUE);
                Shape shape = at.createTransformedShape(this.geometries[i]);
                g2.fill(shape);
                g2.setPaint(Color.ORANGE);
                g2.draw(shape);
            }
        }
    }

    public static class EventHandler
    implements WindowListener {
        @Override
        public void windowActivated(WindowEvent e) {
        }

        @Override
        public void windowClosed(WindowEvent e) {
        }

        @Override
        public void windowClosing(WindowEvent e) {
            e.getWindow().setVisible(false);
            System.exit(0);
        }

        @Override
        public void windowDeactivated(WindowEvent e) {
        }

        @Override
        public void windowDeiconified(WindowEvent e) {
        }

        @Override
        public void windowIconified(WindowEvent e) {
        }

        @Override
        public void windowOpened(WindowEvent e) {
        }
    }
}

