/*
 * Decompiled with CFR 0.152.
 */
package net.postgis.jdbc.java2d;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Properties;
import java.util.logging.Logger;
import net.postgis.jdbc.PGbox2d;
import net.postgis.jdbc.PGbox3d;
import net.postgis.jdbc.java2d.PGShapeGeometry;
import org.postgresql.Driver;
import org.postgresql.PGConnection;

public class Java2DWrapper
extends Driver {
    private static final String POSTGRES_PROTOCOL = "jdbc:postgresql:";
    public static final String POSTGIS_PROTOCOL = "jdbc:postgis_j2d:";
    public static final String REVISION = "$Revision$";

    @Override
    public Connection connect(String url, Properties info) throws SQLException {
        url = Java2DWrapper.mangleURL(url);
        Connection result = super.connect(url, info);
        Java2DWrapper.addGISTypes((PGConnection)((Object)result));
        return result;
    }

    public static void addGISTypes(PGConnection pgconn) throws SQLException {
        pgconn.addDataType("geometry", PGShapeGeometry.class);
        pgconn.addDataType("box3d", PGbox3d.class);
        pgconn.addDataType("box2d", PGbox2d.class);
    }

    public static String mangleURL(String url) {
        return url.startsWith(POSTGIS_PROTOCOL) ? POSTGRES_PROTOCOL + url.substring(POSTGIS_PROTOCOL.length()) : null;
    }

    @Override
    public boolean acceptsURL(String url) {
        return (url = Java2DWrapper.mangleURL(url)) != null && super.acceptsURL(url);
    }

    @Override
    public int getMajorVersion() {
        return super.getMajorVersion();
    }

    @Override
    public int getMinorVersion() {
        return super.getMinorVersion();
    }

    public static String getVersion() {
        return "Java2DWrapper $Revision$, wrapping " + Driver.getVersion();
    }

    @Override
    public Logger getParentLogger() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    static {
        try {
            DriverManager.registerDriver(new Java2DWrapper());
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }
}

