/*
 * Decompiled with CFR 0.152.
 */
package burp.api.montoya.http.message.requests;

import burp.api.montoya.core.ByteArray;
import burp.api.montoya.http.ContentType;
import burp.api.montoya.http.HttpService;
import burp.api.montoya.http.HttpTransformation;
import burp.api.montoya.http.message.HttpMessage;
import burp.api.montoya.http.message.headers.HttpHeader;
import burp.api.montoya.http.message.params.HttpParameter;
import burp.api.montoya.http.message.params.ParsedHttpParameter;
import burp.api.montoya.internal.ObjectFactoryLocator;
import java.util.List;

public interface HttpRequest
extends HttpMessage {
    public static HttpRequest httpRequest(ByteArray request) {
        return HttpRequest.httpRequest(null, request);
    }

    public static HttpRequest httpRequest(String request) {
        return HttpRequest.httpRequest(null, request);
    }

    public static HttpRequest httpRequest(HttpService service, ByteArray request) {
        return ObjectFactoryLocator.FACTORY.httpRequest(service, request);
    }

    public static HttpRequest httpRequest(HttpService service, String request) {
        return ObjectFactoryLocator.FACTORY.httpRequest(service, request);
    }

    public static HttpRequest httpRequest(HttpService service, List<String> headers, ByteArray body) {
        return ObjectFactoryLocator.FACTORY.httpRequest(service, headers, body);
    }

    public static HttpRequest httpRequest(HttpService service, List<String> headers, String body) {
        return ObjectFactoryLocator.FACTORY.httpRequest(service, headers, body);
    }

    public static HttpRequest httpVerbatimRequest(HttpService service, List<HttpHeader> headers, ByteArray body) {
        return ObjectFactoryLocator.FACTORY.httpVerbatimRequest(service, headers, body);
    }

    public static HttpRequest httpVerbatimRequest(HttpService service, List<HttpHeader> headers, String body) {
        return ObjectFactoryLocator.FACTORY.httpVerbatimRequest(service, headers, body);
    }

    public static HttpRequest httpRequestFromUrl(String url) {
        return ObjectFactoryLocator.FACTORY.httpRequestFromUrl(url);
    }

    public HttpService httpService();

    public String method();

    public String url();

    public ContentType contentType();

    public List<ParsedHttpParameter> parameters();

    public HttpRequest withService(HttpService var1);

    public HttpRequest withPath(String var1);

    public HttpRequest withAddedParameters(List<HttpParameter> var1);

    public HttpRequest withAddedParameters(HttpParameter ... var1);

    public HttpRequest withRemovedParameters(List<HttpParameter> var1);

    public HttpRequest withRemovedParameters(HttpParameter ... var1);

    public HttpRequest withUpdatedParameters(List<HttpParameter> var1);

    public HttpRequest withUpdatedParameters(HttpParameter ... var1);

    public HttpRequest withTransformationApplied(HttpTransformation var1);

    public HttpRequest withBody(String var1);

    public HttpRequest withBody(ByteArray var1);

    public HttpRequest addHeader(String var1, String var2);

    public HttpRequest addHeader(HttpHeader var1);

    public HttpRequest updateHeader(String var1, String var2);

    public HttpRequest updateHeader(HttpHeader var1);

    public HttpRequest removeHeader(String var1);

    public HttpRequest removeHeader(HttpHeader var1);
}

