package com.easefun.polyv.livescenes.video.api;

import android.support.annotation.MainThread;

import com.easefun.polyv.businesssdk.api.common.player.listener.IPolyvVideoViewListenerEvent;
import com.easefun.polyv.businesssdk.api.common.ppt.IPolyvPPTView;
import com.easefun.polyv.livescenes.model.PolyvLiveCountdownVO;

/**
 * 公开给用户的api
 *
 * @author df
 * @create 2018/7/30
 * @Describe
 */
public interface IPolyvLiveListenerEvent extends IPolyvVideoViewListenerEvent {
    /**
     * 即将播放暖场视频/图片的监听器
     */
    public interface OnWillPlayWaittingListener {
        /**
         * 即将播放暖场视频/图片的回调方法
         *
         * @param isCoverImage 是否是暖场图片
         */
        @MainThread
        public void onWillPlayWaitting(boolean isCoverImage);
    }

    /**
     * 当前暂无直播的监听器
     */
    public abstract class OnNoLiveAtPresentListener {
        /**
         * 当前暂无直播的回调方法
         */
        public abstract void onNoLiveAtPresent();

        /**
         * 直播结束回调
         */
        public abstract void onLiveEnd();

        /**
         * 直播暂停回调
         */
        public void onLiveStop() {
        }
    }

    public abstract class OnNoLiveAtPresentListenerExt extends OnNoLiveAtPresentListener {
        /**
         * 直播倒计时回调
         *
         * @param liveCountdownVO
         */
        public abstract void onLiveCountdownCallback(PolyvLiveCountdownVO liveCountdownVO);
    }

    /**
     * 当前暂无直播且可以获取到回放地址的监听器
     */
    public interface OnNoLivePlaybackListener {
        /**
         * 当前暂无直播且可以获取到回放地址的回调方法
         *
         * @param playbackUrl         回放地址
         * @param recordFileSessionId 回放视频的sessionId，非ppt回放时为null
         * @param title               标题
         */
        public void onNoLivePlayback(String playbackUrl, String recordFileSessionId, String title, boolean isList);
    }


    /**
     * ///暂时用不上该跑马灯样式的监听
     * 获取直播后台设置的跑马灯样式的监听器
     * public interface OnGetMarqueeVoListener {
     * /**
     *  * 获取直播后台设置的跑马灯样式的回调方法
     *  * @param marqueeVo 跑马灯实例
     * //
     * public void onGetMarqueeVo(PolyvLiveMarqueeVO marqueeVo);
     /    }
     **/


    /**
     * 广告弹出回调
     *
     * @author TanQu
     * @version 2.0
     */
    public interface OnAdvertisementOutListener {

        /**
         * ///暂时不使用
         * 弹出
         * @param adMatter
         * @MainThread
         * public void onOut(@NonNull PolyvLiveChannelVO.ADMatter adMatter);
         *
         * /**
         *  * 点击
         *  * @param adMatter
         * //
         * @MainThread
         * public void onClick(@NonNull PolyvLiveChannelVO.ADMatter adMatter);
         */

    }


    /**
     * 举手连麦回调
     */
    interface MicroPhoneListener {
        /**
         * 是否显示连麦按钮
         */

        void showMicPhoneLine(@IPolyvPPTView.Visibility int visiable);
    }

    /**
     * 摄像头显示回掉类
     */
    interface OnCameraShowListener {

        /**
         * 显示或隐藏摄像头窗口
         */
        void cameraOpen(boolean open);

    }

    /**
     * 线路切换回掉
     */
    interface OnLinesChangedListener {
        /**
         * @param linesPos 线路切换索引
         */
        void onLinesChanged(int linesPos);
    }

    /**
     * 是否支持RTC的回调
     */
    interface OnSupportRTCListener {
        /**
         * @param isSupportRTC true：支持，false：不支持
         */
        void onSupportRTC(boolean isSupportRTC);
    }

    interface OnRTCPlayEventListener {
        /**
         * RTC直播开始
         */
        void onRTCLiveStart();

        /**
         * RTC直播结束
         */
        void onRTCLiveEnd();
    }
}
