package net.polyv.vclass.v1.service.teach.impl;

import java.io.IOException;
import java.security.NoSuchAlgorithmException;

import net.polyv.vclass.v1.constant.VClassURL;
import net.polyv.vclass.v1.entity.teach.VClassTokenLoginRequest;
import net.polyv.vclass.v1.service.VClassBaseService;
import net.polyv.vclass.v1.service.teach.VClassTeachService;

/**
 * 讲师
 * @author: liyongxuan
 */
public class VClassTeachServiceImpl extends VClassBaseService implements VClassTeachService {
    
    /**
     * 讲师单点登录
     * API地址：https://help.polyv.net/#/vclass/api/teach/token_login
     * @param vClassTokenLoginRequest 讲师单点登录请求实体
     * @return 讲师单点登录响应实体
     * @throws IOException 异常
     * @throws NoSuchAlgorithmException 异常
     */
    @Override
    public Boolean tokenLogin(VClassTokenLoginRequest vClassTokenLoginRequest)
            throws IOException, NoSuchAlgorithmException {
        String url = VClassURL.VCLASS_TOKEN_LOGIN_URL;
        this.postJsonBodyReturnOne(url, vClassTokenLoginRequest, String.class);
        return Boolean.TRUE;
    }
}
