package net.polyv.vclass.v1.entity.statistics;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import net.polyv.common.v1.validator.constraints.NotNull;
import net.polyv.vclass.v1.entity.VClassPageNumberCommonRequest;

/**
 * 基于课节维度查询用户信息请求实体
 * @author jiangyifan
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@ApiModel("基于课节维度查询用户信息请求实体")
public class VClassLessonStatisticsRequest extends VClassPageNumberCommonRequest {
    
    /**
     * 课节号
     */
    @ApiModelProperty(name = "lessonId", value = "课节号", required = true)
    @NotNull(message = "属性lessonId不能为空")
    private Long lessonId;
    
}