package net.polyv.vclass.v1.entity.lesson;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import net.polyv.common.v1.validator.constraints.NotNull;
import net.polyv.vclass.v1.entity.VClassCommonRequest;

/**
 * 获取课节信息请求实体
 * @author jiangyifan
 */
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@ApiModel("获取课节信息请求实体")
public class VClassGetLessonInfoRequest extends VClassCommonRequest {
    
    /**
     * 课节号
     */
    @ApiModelProperty(name = "lessonId", value = "课节号", required = true)
    @NotNull(message = "属性lessonId不能为空")
    private Long lessonId;
}
