package net.polyv.vclass.v1.entity.lesson;

import java.util.Date;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

/**
 * 创建课节响应实体
 * @author jiangyifan
 */
@Data
@Accessors(chain = true)
@ApiModel("创建课节响应实体")
public class VClassAddLessonResponse {
    
    /**
     * 课节ID
     */
    @ApiModelProperty(name = "lessonId", value = "课节ID", required = false)
    private Long lessonId;
    
    /**
     * 课节名称
     */
    @ApiModelProperty(name = "name", value = "课节名称", required = false)
    private String name;
    
    /**
     * 老师ID
     */
    @ApiModelProperty(name = "teacherId", value = "老师ID", required = false)
    private String teacherId;
    
    /**
     * 老师登录手机区号
     */
    @ApiModelProperty(name = "teacherCode", value = "老师登录手机区号", required = false)
    private String teacherCode;
    
    /**
     * 老师名称
     */
    @ApiModelProperty(name = "teacherName", value = "老师名称", required = false)
    private String teacherName;
    
    /**
     * 老师账号
     */
    @ApiModelProperty(name = "teacherMobile", value = "老师账号", required = false)
    private String teacherMobile;
    
    /**
     * 老师账号密码
     */
    @ApiModelProperty(name = "teacherPasswd", value = "老师账号密码", required = false)
    private String teacherPasswd;
    
    /**
     * 开始时间
     */
    @ApiModelProperty(name = "startTime", value = "开始时间", required = false)
    private Date startTime;
    
    /**
     * 开始时间
     */
    @ApiModelProperty(name = "endTime", value = "开始时间", required = false)
    private Date endTime;
    
    /**
     * 上课时长，单位: 分钟
     */
    @ApiModelProperty(name = "duration", value = "上课时长，单位: 分钟", required = false)
    private Integer duration;
    
    /**
     * 连麦人数 0 - 16
     */
    @ApiModelProperty(name = "linkNumber", value = "连麦人数 0 - 16", required = false)
    private Integer linkNumber;
    
    /**
     * 是否自动连麦 Y：自动连麦 N：不自动连麦
     */
    @ApiModelProperty(name = "autoConnectMicroEnabled", value = "是否自动连麦 Y：自动连麦 N：不自动连麦", required = false)
    private String autoConnectMicroEnabled;
    
    /**
     * 是否自动录制 Y：自动录制 N：不自动录制
     */
    @ApiModelProperty(name = "autoRecordCourseEnabled", value = "是否自动录制 Y：自动录制 N：不自动录制", required = false)
    private String autoRecordCourseEnabled;
    
    /**
     * 观看条件 NULL：无条件 CODE：验证码 WHITE_LIST：白名单 DIRECT：独立授权
     */
    @ApiModelProperty(name = "watchCondition", value = "观看条件 NULL：无条件 CODE：验证码 WHITE_LIST：白名单 DIRECT：独立授权", required
            = false)
    private String watchCondition;
    
    /**
     * 当观看条件为CODE时需要填写观看验证码（限制16位以内）
     */
    @ApiModelProperty(name = "code", value = "当观看条件为CODE时需要填写观看验证码（限制16位以内）", required = false)
    private String code;
    
    /**
     * 授权观看KEY
     */
    @ApiModelProperty(name = "secretKey", value = "授权观看KEY", required = false)
    private String secretKey;
    
    /**
     * 封面URL
     */
    @ApiModelProperty(name = "cover", value = "封面URL", required = false)
    private String cover;
    
    /**
     * 录制清晰度, 720, 1080
     */
    @ApiModelProperty(name = "resolution", value = "录制清晰度, 720, 1080", required = false)
    private Integer resolution;
    
    /**
     * 上课清晰度, 360
     */
    @ApiModelProperty(name = "playResolution", value = "上课清晰度, 360", required = false)
    private Integer playResolution;
    
}