/*
 * Decompiled with CFR 0.152.
 */
package net.polyv.common.v1.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.annotation.JSONField;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.polyv.common.v1.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MapUtil {
    private static final Logger LOG = LoggerFactory.getLogger(MapUtil.class);

    private MapUtil() {
    }

    public static Map<String, String> order(Map<String, String> map) {
        LinkedHashMap<String, String> tempMap = new LinkedHashMap<String, String>();
        ArrayList<Map.Entry<String, String>> infoIds = new ArrayList<Map.Entry<String, String>>(map.entrySet());
        Collections.sort(infoIds, new Comparator<Map.Entry<String, String>>(){

            @Override
            public int compare(Map.Entry<String, String> o1, Map.Entry<String, String> o2) {
                return o1.getKey().compareTo(o2.getKey());
            }
        });
        for (Map.Entry entry : infoIds) {
            tempMap.put((String)entry.getKey(), (String)entry.getValue());
        }
        return tempMap;
    }

    public static Map<String, String> objectToMap(Object obj) {
        HashMap<String, String> reMap = new HashMap<String, String>();
        if (null == obj) {
            return null;
        }
        try {
            for (Class<?> objClass = obj.getClass(); null != objClass; objClass = objClass.getSuperclass()) {
                Field[] fields = objClass.getDeclaredFields();
                for (int i = 0; i < fields.length; ++i) {
                    Field f = objClass.getDeclaredField(fields[i].getName());
                    f.setAccessible(true);
                    Object o = f.get(obj);
                    if (o instanceof File) continue;
                    JSONField jsonField = f.getAnnotation(JSONField.class);
                    String key = jsonField != null && StringUtils.isNotBlank(jsonField.name()) ? jsonField.name() : fields[i].getName();
                    String value = null;
                    if (o != null) {
                        if (o instanceof List) {
                            value = JSON.toJSONString(o);
                        } else if (o instanceof Date) {
                            if (jsonField != null && StringUtils.isNotBlank(jsonField.format())) {
                                value = JSON.toJSONStringWithDateFormat(o, jsonField.format(), new SerializerFeature[0]);
                                value = value.replace("\"", "");
                            } else {
                                value = JSON.toJSONString(o);
                            }
                        } else {
                            value = o.toString();
                        }
                    }
                    reMap.put(key, null == o ? null : value);
                }
            }
        }
        catch (NoSuchFieldException e) {
            LOG.error(e.getMessage(), e);
        }
        catch (IllegalArgumentException e) {
            LOG.error(e.getMessage(), e);
        }
        catch (IllegalAccessException e) {
            LOG.error(e.getMessage(), e);
        }
        catch (SecurityException e) {
            LOG.error(e.getMessage(), e);
        }
        return reMap;
    }

    private static List<Field> getAllFields(Class<?> clazz) {
        if (!clazz.equals(Object.class)) {
            return new ArrayList<Field>();
        }
        ArrayList<Field> fields = new ArrayList<Field>(Arrays.asList(clazz.getDeclaredFields()));
        List<Field> fields2 = MapUtil.getAllFields(clazz.getSuperclass());
        if (null != fields2) {
            fields.addAll(fields2);
        }
        return fields;
    }

    public static String mapJoin_noUser(Map<String, String> map, boolean keyLower, boolean valueUrlEncode) {
        StringBuilder stringBuilder = new StringBuilder();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            if (StringUtils.isBlank(value)) continue;
            try {
                String temp = key.endsWith("_") && key.length() > 1 ? key.substring(0, key.length() - 1) : key;
                stringBuilder.append(keyLower ? temp.toLowerCase() : temp).append("=").append(valueUrlEncode ? URLEncoder.encode(value, "UTF-8").replace("+", "%20") : value).append("&");
            }
            catch (UnsupportedEncodingException e) {
                LOG.error(e.getMessage(), e);
            }
        }
        if (stringBuilder.length() > 0) {
            stringBuilder.deleteCharAt(stringBuilder.length() - 1);
        }
        return stringBuilder.toString();
    }

    public static String mapJoinNotEncode(Map<String, String> map) {
        StringBuilder stringBuilder = new StringBuilder();
        int i = 0;
        for (Map.Entry<String, String> entry : map.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            if (StringUtils.isBlank(value)) continue;
            if (0 != i) {
                stringBuilder.append("&");
            }
            stringBuilder.append(key).append("=").append(map.get(key));
            ++i;
        }
        return stringBuilder.toString();
    }

    public static Map<String, String> filterNullValue(Map<String, String> sourceMap) {
        HashMap<String, String> destMap = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : sourceMap.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            if (StringUtils.isBlank(value) && !"password".equals(key)) continue;
            destMap.put(key, value);
        }
        return destMap;
    }

    public static String appendUrl(String url, Map<String, String> paramMap) throws UnsupportedEncodingException {
        if (paramMap == null) {
            return url;
        }
        StringBuffer paramStringBuffer = new StringBuffer();
        for (Map.Entry<String, String> next : paramMap.entrySet()) {
            String value = next.getValue();
            if (!StringUtils.isNotBlank(value)) continue;
            paramStringBuffer.append(next.getKey()).append("=").append(URLEncoder.encode(value, "UTF-8")).append("&");
        }
        String paramStr = paramStringBuffer.toString();
        if (StringUtils.isNotBlank(paramStr)) {
            url = url.indexOf("?") > 0 ? (url.endsWith("&") ? url + paramStr.substring(0, paramStr.length() - 1) : url + "&" + paramStr.substring(0, paramStr.length() - 1)) : url + "?" + paramStr.substring(0, paramStr.length() - 1);
        }
        return url;
    }
}

