/*
 * Decompiled with CFR 0.152.
 */
package net.polyv.common.v1.validator.handle;

import java.io.File;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import net.polyv.common.v1.constant.Constant;
import net.polyv.common.v1.exception.PloyvSdkException;
import net.polyv.common.v1.validator.constraints.NotNull;
import net.polyv.common.v1.validator.handle.Validator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NotNullValidator
extends Validator {
    private static final Logger log = LoggerFactory.getLogger(NotNullValidator.class);

    public NotNullValidator() {
        this.currentClass = NotNull.class;
    }

    @Override
    protected String dealValidate(Annotation annotation, Field field, Object data, Class<?> ... groups) {
        NotNull cast = (NotNull)NotNull.class.cast(annotation);
        if (data instanceof File) {
            if (data == null) {
                return cast.message();
            }
            if (!((File)data).exists()) {
                throw new PloyvSdkException(Constant.ERROR_CODE, "\u6587\u4ef6\u4e0d\u5b58\u5728\uff0c\u8def\u5f84\uff1a" + ((File)data).getPath());
            }
            return null;
        }
        if (this.showMsg(groups, cast.groups())) {
            return data == null ? cast.message() : null;
        }
        return null;
    }
}

