/*
 * Decompiled with CFR 0.152.
 */
package net.polyv.common.v1.base;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.polyv.common.v1.base.DataParse;
import net.polyv.common.v1.base.HttpClientUtil;
import net.polyv.common.v1.exception.PloyvSdkException;
import net.polyv.common.v1.util.MapUtil;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.FileBody;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpUtil {
    private static final Logger log = LoggerFactory.getLogger(HttpUtil.class);
    public static final String SOURCE = "source";
    public static final String VERSION = "version";
    public static final String USER_AGENT = "User-Agent";
    public static final String APP_ID_NAME = "java-sdk-app-id";
    public static final String USER_ID_NAME = "java-sdk-user-id";
    public static final String CURRENT_VERSION = "1.0.25";
    private static final String UTF8 = "UTF-8";

    private HttpUtil() {
    }

    public static String get(String url) throws IOException {
        return HttpUtil.get(url, null, new HashMap<String, String>());
    }

    public static String get(String url, Map<String, String> paramMap, Map<String, String> headMap) throws IOException {
        return HttpUtil.get(url, paramMap, headMap, UTF8);
    }

    public static String get(String url, Map<String, String> paramMap, Map<String, String> headMap, String encoding) throws IOException {
        encoding = encoding == null ? UTF8 : encoding;
        url = MapUtil.appendUrl(url, paramMap);
        return HttpUtil.get(url, headMap, encoding, new DataParse<String>(){

            @Override
            public String parseData(HttpEntity httpEntity, String encoding) throws IOException {
                return EntityUtils.toString((HttpEntity)httpEntity, (String)encoding);
            }
        });
    }

    public static byte[] getBinary(String url, Map<String, String> paramMap, Map<String, String> headMap, String encoding) throws IOException {
        encoding = encoding == null ? UTF8 : encoding;
        url = MapUtil.appendUrl(url, paramMap);
        return HttpUtil.get(url, headMap, encoding, new DataParse<byte[]>(){

            @Override
            public byte[] parseData(HttpEntity httpEntity, String encoding) throws IOException {
                return EntityUtils.toByteArray((HttpEntity)httpEntity);
            }
        });
    }

    private static <T> T get(String url, Map<String, String> headMap, String encoding, DataParse<T> dataParse) throws IOException {
        CloseableHttpResponse response;
        log.debug("http \u8bf7\u6c42 url: {}", (Object)url);
        T result = null;
        PloyvSdkException ployvSdkException = null;
        CloseableHttpClient httpClient = HttpClientUtil.getHttpClient();
        HttpGet httpGet = new HttpGet(url);
        httpGet.addHeader("Content-type", "application/json; charset=UTF-8");
        if (headMap != null) {
            Set<Map.Entry<String, String>> entries = headMap.entrySet();
            for (Map.Entry<String, String> next : entries) {
                httpGet.addHeader(next.getKey(), next.getValue());
            }
        }
        if (null != (response = HttpUtil.sendRequestAndGetResult(url, httpClient, (HttpUriRequest)httpGet))) {
            result = dataParse.parseData(response.getEntity(), encoding);
            if (!(result instanceof byte[])) {
                log.debug("http \u8bf7\u6c42\u7ed3\u679c: {}", result);
            } else {
                Header[] headers;
                for (Header responseHead : headers = response.getHeaders("Content-type")) {
                    String headStr = responseHead.getValue();
                    if (!headStr.startsWith("application/json")) continue;
                    String json = new String((byte[])result);
                    JSONObject jsonObject = JSON.parseObject((String)json);
                    String message = jsonObject.getString("message");
                    Integer code = jsonObject.getInteger("code");
                    ployvSdkException = new PloyvSdkException(code, message);
                }
            }
        }
        try {
            if (null != response) {
                response.close();
            }
        }
        catch (IOException ex) {
            log.error(ex.getMessage(), (Throwable)ex);
        }
        if (ployvSdkException != null) {
            throw ployvSdkException;
        }
        return result;
    }

    public static String postFormBody(String url, Map<String, String> paramMap, Map<String, String> headMap) throws IOException {
        return HttpUtil.postFormBody(url, paramMap, headMap, null);
    }

    public static String postFormBody(String url, Map<String, String> paramMap, Map<String, String> headMap, String encoding) throws IOException {
        return HttpUtil.post(url, paramMap, headMap, encoding);
    }

    private static String post(String url, Map<String, String> paramMap, Map<String, String> headMap, String encoding) throws IOException {
        log.debug("http \u8bf7\u6c42 url: {} , \u8bf7\u6c42\u53c2\u6570: {}", (Object)url, (Object)JSON.toJSONString(paramMap));
        encoding = encoding == null ? UTF8 : encoding;
        HttpPost httpPost = new HttpPost(url);
        ArrayList<BasicNameValuePair> nameValuePairs = new ArrayList<BasicNameValuePair>();
        if (paramMap != null) {
            for (Map.Entry<String, String> entry : paramMap.entrySet()) {
                String value = entry.getValue();
                if (value == null) continue;
                nameValuePairs.add(new BasicNameValuePair(entry.getKey(), value));
            }
        }
        httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(nameValuePairs, encoding));
        httpPost.setHeader("Content-type", "application/x-www-form-urlencoded; charset=UTF-8");
        return HttpUtil.post(url, headMap, httpPost, encoding, new DataParse<String>(){

            @Override
            public String parseData(HttpEntity httpEntity, String encoding) throws IOException {
                return EntityUtils.toString((HttpEntity)httpEntity, (String)encoding);
            }
        });
    }

    public static String postJsonBody(String url, Map<String, String> headMap, String json, String encoding) throws IOException {
        log.debug("http \u8bf7\u6c42 url: {} , \u8bf7\u6c42\u53c2\u6570: {}", (Object)url, (Object)json);
        encoding = encoding == null ? UTF8 : encoding;
        HttpPost httpPost = new HttpPost(url);
        StringEntity stringEntity = new StringEntity(json, ContentType.APPLICATION_JSON);
        stringEntity.setContentEncoding(encoding);
        httpPost.setEntity((HttpEntity)stringEntity);
        String result = HttpUtil.post(url, headMap, httpPost, encoding, new DataParse<String>(){

            @Override
            public String parseData(HttpEntity httpEntity, String encoding) throws IOException {
                return EntityUtils.toString((HttpEntity)httpEntity, (String)encoding);
            }
        });
        return result;
    }

    private static <T> T post(String url, Map<String, String> headMap, HttpPost httpPost, String encoding, DataParse<T> dataParse) throws IOException {
        T result = null;
        CloseableHttpResponse response = null;
        CloseableHttpClient httpClient = HttpClientUtil.getHttpClient();
        if (headMap != null) {
            Set<Map.Entry<String, String>> entries = headMap.entrySet();
            for (Map.Entry<String, String> next : entries) {
                httpPost.addHeader(next.getKey(), next.getValue());
            }
        }
        if (null != (response = HttpUtil.sendRequestAndGetResult(url, httpClient, (HttpUriRequest)httpPost))) {
            result = dataParse.parseData(response.getEntity(), encoding);
            log.debug("http \u8bf7\u6c42\u7ed3\u679c: {}", result);
        }
        try {
            if (null != response) {
                response.close();
            }
        }
        catch (IOException ex) {
            log.error(ex.getMessage(), (Throwable)ex);
        }
        return result;
    }

    private static CloseableHttpResponse sendRequestAndGetResult(String url, CloseableHttpClient httpClient, HttpUriRequest httpUriRequest) throws IOException {
        long startTime = System.currentTimeMillis();
        CloseableHttpResponse response = httpClient.execute(httpUriRequest);
        long endTime = System.currentTimeMillis();
        HttpUtil.collectAPISpendTime(url, startTime, endTime, httpUriRequest);
        return response;
    }

    private static void collectAPISpendTime(String url, long startTime, long endTime, HttpUriRequest httpUriRequest) {
        log.debug("HTTP\u8bf7\u6c42\u8017\u65f6\u5206\u6790\uff0c\u8bf7\u6c42URL: {} \uff0c \u8bf7\u6c42\u5934\u4fe1\u606f\uff1a{} \uff0c   \u8017\u65f6: {} ms", new Object[]{url, JSON.toJSONString((Object)httpUriRequest.getAllHeaders()), endTime - startTime});
    }

    public static String postFile(String url, Map<String, String> paramMap, Map<String, File> fileMap, Map<String, String> headMap, String encoding) throws IOException {
        if (fileMap != null) {
            HashMap<String, List<File>> fileListMap = new HashMap<String, List<File>>();
            for (Map.Entry<String, File> entry : fileMap.entrySet()) {
                File file = entry.getValue();
                ArrayList<File> fileList = new ArrayList<File>();
                fileList.add(file);
                fileListMap.put(entry.getKey(), fileList);
            }
            return HttpUtil.postMultipleFile(url, paramMap, fileListMap, headMap, encoding);
        }
        return HttpUtil.postMultipleFile(url, paramMap, null, headMap, encoding);
    }

    public static String postMultipleFile(String url, Map<String, String> paramMap, Map<String, List<File>> fileListMap, Map<String, String> headMap, String encoding) throws IOException {
        return HttpUtil.postFileBody(url, paramMap, fileListMap, headMap, encoding, new DataParse<String>(){

            @Override
            public String parseData(HttpEntity httpEntity, String encoding) throws IOException {
                return EntityUtils.toString((HttpEntity)httpEntity, (String)encoding);
            }
        });
    }

    private static <T> T postFileBody(String url, Map<String, String> paramMap, Map<String, List<File>> fileListMap, Map<String, String> headMap, String encoding, DataParse<T> dataParse) throws IOException {
        CloseableHttpResponse closeableHttpResponse;
        log.debug("http \u8bf7\u6c42 url: {} , \u8bf7\u6c42\u53c2\u6570: {}", (Object)url, (Object)JSON.toJSONString(paramMap));
        encoding = encoding == null ? UTF8 : encoding;
        T result = null;
        CloseableHttpClient httpClient = HttpClientUtil.getHttpClient();
        HttpPost httpPost = new HttpPost(url);
        MultipartEntityBuilder entityBuilder = MultipartEntityBuilder.create();
        ContentType contentType = ContentType.create((String)"text/plain", (Charset)Charset.forName(encoding));
        if (null != paramMap) {
            for (Map.Entry<String, Object> entry : paramMap.entrySet()) {
                entityBuilder.addTextBody(entry.getKey(), (String)entry.getValue(), contentType);
            }
        }
        if (null != fileListMap) {
            for (Map.Entry<String, Object> entry : fileListMap.entrySet()) {
                String key = entry.getKey();
                List fileList = (List)entry.getValue();
                for (File file : fileList) {
                    FileBody fileBody = new FileBody(file);
                    entityBuilder.addPart(key, (ContentBody)fileBody);
                }
            }
        }
        HttpEntity entity = entityBuilder.build();
        httpPost.setEntity(entity);
        if (headMap != null) {
            Set<Map.Entry<String, String>> set = headMap.entrySet();
            for (Map.Entry<String, String> next : set) {
                httpPost.addHeader(next.getKey(), next.getValue());
            }
        }
        if (null != (closeableHttpResponse = HttpUtil.sendRequestAndGetResult(url, httpClient, (HttpUriRequest)httpPost))) {
            result = dataParse.parseData(closeableHttpResponse.getEntity(), encoding);
            log.debug("http \u8bf7\u6c42\u7ed3\u679c: {}", result);
        }
        try {
            if (null != closeableHttpResponse) {
                closeableHttpResponse.close();
            }
        }
        catch (IOException ex) {
            log.error(ex.getMessage(), (Throwable)ex);
        }
        return result;
    }
}

