/*
 * Decompiled with CFR 0.152.
 */
package net.polyv.live.v1.service.web.impl;

import java.io.File;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.polyv.live.v1.config.LiveGlobalConfig;
import net.polyv.live.v1.constant.LiveURL;
import net.polyv.live.v1.entity.channel.operate.LiveChannelSettingRequest;
import net.polyv.live.v1.entity.web.auth.LiveChannelAuthCustomRequest;
import net.polyv.live.v1.entity.web.auth.LiveChannelAuthCustomResponse;
import net.polyv.live.v1.entity.web.auth.LiveChannelAuthExternalRequest;
import net.polyv.live.v1.entity.web.auth.LiveChannelAuthExternalResponse;
import net.polyv.live.v1.entity.web.auth.LiveChannelAuthFieldRequest;
import net.polyv.live.v1.entity.web.auth.LiveChannelAuthFieldResponse;
import net.polyv.live.v1.entity.web.auth.LiveChannelAuthInfoRequest;
import net.polyv.live.v1.entity.web.auth.LiveChannelAuthInfoResponse;
import net.polyv.live.v1.entity.web.auth.LiveChannelAuthRequest;
import net.polyv.live.v1.entity.web.auth.LiveChannelAuthResponse;
import net.polyv.live.v1.entity.web.auth.LiveChannelAuthTypeRequest;
import net.polyv.live.v1.entity.web.auth.LiveChannelWhiteListRequest;
import net.polyv.live.v1.entity.web.auth.LiveChannelWhiteListResponse;
import net.polyv.live.v1.entity.web.auth.LiveCreateChannelWhiteListRequest;
import net.polyv.live.v1.entity.web.auth.LiveDeleteChannelWhiteListRequest;
import net.polyv.live.v1.entity.web.auth.LiveDownloadChannelAuthInfoRequest;
import net.polyv.live.v1.entity.web.auth.LiveDownloadChannelWhiteListRequest;
import net.polyv.live.v1.entity.web.auth.LiveUpdateChannelAuthRequest;
import net.polyv.live.v1.entity.web.auth.LiveUpdateChannelAuthUrlRequest;
import net.polyv.live.v1.entity.web.auth.LiveUpdateChannelWhiteListRequest;
import net.polyv.live.v1.entity.web.auth.LiveUploadWhiteListRequest;
import net.polyv.live.v1.service.LiveBaseService;
import net.polyv.live.v1.service.web.ILiveWebAuthService;
import net.polyv.live.v1.util.LiveSignUtil;

public class LiveWebAuthServiceImpl
extends LiveBaseService
implements ILiveWebAuthService {
    @Override
    public Boolean createChannelWhiteList(LiveCreateChannelWhiteListRequest liveCreateChannelWhiteListRequest) throws IOException, NoSuchAlgorithmException {
        String url = "api.polyv.net/live/v3/channel/auth/add-white-list";
        this.postFormBodyReturnOne(url, liveCreateChannelWhiteListRequest, String.class);
        return Boolean.TRUE;
    }

    @Override
    public Boolean updateChannelAuth(LiveUpdateChannelAuthRequest liveUpdateChannelAuthRequest) throws IOException, NoSuchAlgorithmException {
        String url = "api.polyv.net/live/v3/channel/auth/update";
        Map<String, String> signMap = LiveSignUtil.getSignMap(liveUpdateChannelAuthRequest);
        String channelId = liveUpdateChannelAuthRequest.getChannelId();
        if (channelId != null) {
            signMap.put("channelId", channelId);
        }
        this.postJsonBodyReturnOne(url, signMap, liveUpdateChannelAuthRequest, String.class);
        return Boolean.TRUE;
    }

    @Override
    public LiveChannelAuthExternalResponse updateChannelAuthExternal(LiveChannelAuthExternalRequest liveChannelAuthExternalRequest) throws IOException, NoSuchAlgorithmException {
        liveChannelAuthExternalRequest.setUserId(LiveGlobalConfig.getUserId());
        String url = LiveURL.getRealUrl("api.polyv.net/live/v2/channelSetting/%s/auth-external", liveChannelAuthExternalRequest.getUserId());
        List<LiveChannelAuthExternalResponse.ChannelAuthExternal> channelAuthExternals = this.postFormBodyReturnList(url, liveChannelAuthExternalRequest, LiveChannelAuthExternalResponse.ChannelAuthExternal.class);
        LiveChannelAuthExternalResponse liveChannelAuthExternalResponse = new LiveChannelAuthExternalResponse();
        liveChannelAuthExternalResponse.setChannelAuthExternals(channelAuthExternals);
        return liveChannelAuthExternalResponse;
    }

    @Override
    public LiveChannelAuthCustomResponse updateChannelAuthCustom(LiveChannelAuthCustomRequest liveChannelAuthCustomRequest) throws IOException, NoSuchAlgorithmException {
        liveChannelAuthCustomRequest.setUserId(LiveGlobalConfig.getUserId());
        String url = LiveURL.getRealUrl("api.polyv.net/live/v2/channelSetting/%s/oauth-custom", liveChannelAuthCustomRequest.getUserId());
        List<LiveChannelAuthCustomResponse.ChannelAuthExternal> channelAuthExternals = this.postFormBodyReturnList(url, liveChannelAuthCustomRequest, LiveChannelAuthCustomResponse.ChannelAuthExternal.class);
        LiveChannelAuthCustomResponse liveChannelAuthCustomResponse = new LiveChannelAuthCustomResponse();
        liveChannelAuthCustomResponse.setChannelAuthExternals(channelAuthExternals);
        return liveChannelAuthCustomResponse;
    }

    @Override
    public Boolean updateChannelAuthType(LiveChannelAuthTypeRequest liveChannelAuthTypeRequest) throws IOException, NoSuchAlgorithmException {
        String url = LiveURL.getRealUrl("api.polyv.net/live/v2/channelSetting/%s/set-auth-type", liveChannelAuthTypeRequest.getChannelId());
        this.postFormBodyReturnOne(url, liveChannelAuthTypeRequest, String.class);
        return Boolean.TRUE;
    }

    @Override
    public LiveChannelAuthResponse getChannelAuth(LiveChannelAuthRequest liveChannelAuthRequest) throws IOException, NoSuchAlgorithmException {
        String url = "api.polyv.net/live/v3/channel/auth/get";
        List<LiveChannelSettingRequest.AuthSetting> authSettings = this.postFormBodyReturnList(url, liveChannelAuthRequest, LiveChannelSettingRequest.AuthSetting.class);
        LiveChannelAuthResponse liveChannelAuthResponse = new LiveChannelAuthResponse();
        liveChannelAuthResponse.setAuthSettings(authSettings);
        return liveChannelAuthResponse;
    }

    @Override
    public LiveChannelWhiteListResponse getChannelWhiteList(LiveChannelWhiteListRequest liveChannelWhiteListRequest) throws IOException, NoSuchAlgorithmException {
        String url = "api.polyv.net/live/v3/channel/auth/get-white-list";
        return this.getReturnOne(url, liveChannelWhiteListRequest, LiveChannelWhiteListResponse.class);
    }

    @Override
    public Boolean updateChannelAuthUrl(LiveUpdateChannelAuthUrlRequest liveUpdateChannelAuthUrlRequest) throws IOException, NoSuchAlgorithmException {
        String url = "api.polyv.net/live/v3/channel/restrict/update-auth-url";
        this.postFormBodyReturnOne(url, liveUpdateChannelAuthUrlRequest, String.class);
        return Boolean.TRUE;
    }

    @Override
    public Boolean updateChannelWhiteList(LiveUpdateChannelWhiteListRequest liveUpdateChannelWhiteListRequest) throws IOException, NoSuchAlgorithmException {
        String url = "api.polyv.net/live/v3/channel/auth/update-white-list";
        this.postFormBodyReturnOne(url, liveUpdateChannelWhiteListRequest, String.class);
        return Boolean.TRUE;
    }

    @Override
    public Boolean deleteChannelWhiteList(LiveDeleteChannelWhiteListRequest liveDeleteChannelWhiteListRequest) throws IOException, NoSuchAlgorithmException {
        String url = "api.polyv.net/live/v3/channel/auth/delete-white-list";
        this.postFormBodyReturnOne(url, liveDeleteChannelWhiteListRequest, String.class);
        return Boolean.TRUE;
    }

    @Override
    public LiveChannelAuthFieldResponse getChannelAuthField(LiveChannelAuthFieldRequest liveChannelAuthFieldRequest) throws IOException, NoSuchAlgorithmException {
        String url = "api.polyv.net/live/v3/channel/auth/get-record-field";
        List<LiveChannelAuthFieldResponse.ChannelAuthField> channelAuthFields = this.getReturnList(url, liveChannelAuthFieldRequest, LiveChannelAuthFieldResponse.ChannelAuthField.class);
        LiveChannelAuthFieldResponse liveChannelAuthFieldResponse = new LiveChannelAuthFieldResponse();
        liveChannelAuthFieldResponse.setChannelAuthFields(channelAuthFields);
        return liveChannelAuthFieldResponse;
    }

    @Override
    public LiveChannelAuthInfoResponse getChannelAuthInfo(LiveChannelAuthInfoRequest liveChannelAuthInfoRequest) throws IOException, NoSuchAlgorithmException {
        String url = "api.polyv.net/live/v3/channel/auth/get-record-info";
        return this.getReturnOne(url, liveChannelAuthInfoRequest, LiveChannelAuthInfoResponse.class);
    }

    @Override
    public byte[] downloadChannelAuthInfo(LiveDownloadChannelAuthInfoRequest liveDownloadChannelAuthInfoRequest) throws IOException, NoSuchAlgorithmException {
        String url = "api.polyv.net/live/v3/channel/auth/download-record-info";
        return this.getReturnBinary(url, liveDownloadChannelAuthInfoRequest);
    }

    @Override
    public Boolean uploadWhiteList(LiveUploadWhiteListRequest liveUploadWhiteListRequest) throws IOException, NoSuchAlgorithmException {
        String url = "api.polyv.net/live/v3/channel/auth/upload-white-list";
        HashMap<String, File> fileMap = new HashMap<String, File>();
        fileMap.put("file", liveUploadWhiteListRequest.getFile());
        this.uploadOneFile(url, liveUploadWhiteListRequest, fileMap, String.class);
        return Boolean.TRUE;
    }

    @Override
    public byte[] downloadChannelWhiteList(LiveDownloadChannelWhiteListRequest liveDownloadChannelWhiteListRequest) throws IOException, NoSuchAlgorithmException {
        String url = "api.polyv.net/live/v3/channel/auth/download-white-list";
        return this.getReturnBinary(url, liveDownloadChannelWhiteListRequest);
    }
}

