/*
 * Decompiled with CFR 0.152.
 */
package net.polyv.live.v1.service;

import com.alibaba.fastjson.JSON;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import net.polyv.common.v1.constant.Constant;
import net.polyv.common.v1.exception.PloyvSdkException;
import net.polyv.common.v1.util.StringUtils;
import net.polyv.live.v1.entity.LiveCommonResponse;
import net.polyv.live.v1.entity.LiveResultCommonResponse;
import net.polyv.live.v1.service.LiveBaseService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LiveResultBaseService
extends LiveBaseService {
    private static final Logger log = LoggerFactory.getLogger(LiveResultBaseService.class);

    @Override
    protected LiveCommonResponse responseConversion(String response, String requestId) throws IOException, NoSuchAlgorithmException {
        LiveResultCommonResponse liveResultCommonResponse;
        if (StringUtils.isNotBlank((String)response)) {
            liveResultCommonResponse = (LiveResultCommonResponse)JSON.parseObject((String)response, LiveResultCommonResponse.class);
            if (!"success".equals(liveResultCommonResponse.getStatus())) {
                String errorMessage = liveResultCommonResponse.getResult();
                int errorCode = 400;
                String message = "\u4fdd\u5229\u5a01\u8bf7\u6c42\u8fd4\u56de\u6570\u636e\u9519\u8bef\uff0c\u8bf7\u6c42\u6d41\u6c34\u53f7\uff1a" + requestId + " ,\u9519\u8bef\u539f\u56e0\uff1a " + errorMessage;
                PloyvSdkException exception = new PloyvSdkException(Integer.valueOf(errorCode), message);
                log.error(message, (Throwable)exception);
                throw exception;
            }
        } else {
            String message = "\u4fdd\u5229\u5a01HTTP\u9519\u8bef\uff0c\u8bf7\u6c42\u6d41\u6c34\u53f7\uff1a" + requestId + " ,\u9519\u8bef\u539f\u56e0\uff1a \u670d\u52a1\u5668\u63a5\u53e3\u672a\u8fd4\u56de\u4efb\u4f55\u6570\u636e";
            PloyvSdkException exception = new PloyvSdkException(Constant.ERROR_CODE, message);
            log.error(message, (Throwable)exception);
            throw exception;
        }
        LiveCommonResponse liveCommonResponse = new LiveCommonResponse();
        liveCommonResponse.setCode(200);
        liveCommonResponse.setSuccess(true);
        liveCommonResponse.setRequestId(requestId);
        liveCommonResponse.setData(liveResultCommonResponse.getResult());
        return liveCommonResponse;
    }
}

