/*
 * Decompiled with CFR 0.152.
 */
package net.pincette.jwt;

import com.auth0.jwt.JWT;
import com.auth0.jwt.JWTVerifier;
import com.auth0.jwt.algorithms.Algorithm;
import com.auth0.jwt.interfaces.DecodedJWT;
import java.security.PublicKey;
import java.security.interfaces.ECKey;
import java.security.interfaces.RSAKey;
import java.util.Optional;
import net.pincette.jwt.Util;
import net.pincette.util.Util;

public class Verifier {
    final JWTVerifier[] verifiers = new JWTVerifier[3];

    public Verifier(String publicKey) {
        this(Util.publicKey(publicKey));
    }

    public Verifier(PublicKey publicKey) {
        net.pincette.util.Util.must((publicKey instanceof RSAKey || publicKey instanceof ECKey ? 1 : 0) != 0);
        if (publicKey instanceof RSAKey) {
            RSAKey k = (RSAKey)((Object)publicKey);
            this.verifiers[0] = JWT.require((Algorithm)Algorithm.RSA256((RSAKey)k)).build();
            this.verifiers[1] = JWT.require((Algorithm)Algorithm.RSA384((RSAKey)k)).build();
            this.verifiers[2] = JWT.require((Algorithm)Algorithm.RSA512((RSAKey)k)).build();
        } else {
            this.verifiers[0] = JWT.require((Algorithm)Algorithm.ECDSA256((ECKey)((ECKey)((Object)publicKey)))).build();
            this.verifiers[1] = JWT.require((Algorithm)Algorithm.ECDSA384((ECKey)((ECKey)((Object)publicKey)))).build();
            this.verifiers[2] = JWT.require((Algorithm)Algorithm.ECDSA512((ECKey)((ECKey)((Object)publicKey)))).build();
        }
    }

    private static int selectVerifier(String algorithm) {
        return switch (algorithm) {
            case "ES256", "RS256" -> 0;
            case "ES384", "RS384" -> 1;
            case "ES512", "RS512" -> 2;
            default -> throw new Util.GeneralException("Unknown algorithm " + algorithm);
        };
    }

    public Optional<DecodedJWT> verify(String jwt) {
        return Optional.of(JWT.decode((String)jwt)).flatMap(this::verify);
    }

    public Optional<DecodedJWT> verify(DecodedJWT jwt) {
        return net.pincette.util.Util.tryToGetSilent(() -> this.verifiers[Verifier.selectVerifier(jwt.getAlgorithm())].verify(jwt));
    }
}

