/*
 * Decompiled with CFR 0.152.
 */
package net.pincette.jwt;

import java.nio.charset.StandardCharsets;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.EncodedKeySpec;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Arrays;
import java.util.Base64;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.json.JsonObject;
import javax.json.JsonValue;
import net.pincette.function.BiFunctionWithException;
import net.pincette.json.JsonUtil;

public class Util {
    private Util() {
    }

    private static byte[] decode(String key) {
        return Base64.getDecoder().decode(Util.extractKey(key));
    }

    private static String extractKey(String s) {
        return Arrays.stream(s.split("\\n")).filter(line -> !line.startsWith("-----")).collect(Collectors.joining());
    }

    private static <T> T generate(EncodedKeySpec spec, BiFunctionWithException<KeyFactory, EncodedKeySpec, T> gen) {
        return (T)net.pincette.util.Util.tryToGetSilent(() -> gen.apply((Object)KeyFactory.getInstance("RSA"), (Object)spec)).orElseGet(() -> net.pincette.util.Util.tryToGetRethrow(() -> gen.apply((Object)KeyFactory.getInstance("EC"), (Object)spec)).orElse(null));
    }

    public static Optional<JsonObject> getJwtPayload(String token) {
        return Optional.of(token).map(t -> t.split("\\.")).filter(s -> ((String[])s).length > 1).map(s -> s[1].replace('-', '+').replace('_', '/')).map(s -> Base64.getDecoder().decode((String)s)).map(b -> new String((byte[])b, StandardCharsets.UTF_8)).flatMap(JsonUtil::from).filter(JsonUtil::isObject).map(JsonValue::asJsonObject);
    }

    static PrivateKey privateKey(String key) {
        return (PrivateKey)Util.generate(new PKCS8EncodedKeySpec(Util.decode(key)), KeyFactory::generatePrivate);
    }

    static PublicKey publicKey(String key) {
        return (PublicKey)Util.generate(new X509EncodedKeySpec(Util.decode(key)), KeyFactory::generatePublic);
    }
}

