/*
 * Decompiled with CFR 0.152.
 */
package net.pincette.jwt;

import com.auth0.jwt.JWTCreator;
import com.auth0.jwt.algorithms.Algorithm;
import java.security.PrivateKey;
import java.security.interfaces.ECKey;
import java.security.interfaces.RSAKey;
import net.pincette.jwt.BitSize;
import net.pincette.jwt.Util;

public class Signer {
    private final Algorithm algorithm;

    public Signer(String privateKey) {
        this(Util.privateKey(privateKey));
    }

    public Signer(PrivateKey privateKey) {
        this(privateKey, BitSize.BIT256);
    }

    public Signer(String privateKey, BitSize bits) {
        this(Util.privateKey(privateKey), bits);
    }

    public Signer(PrivateKey privateKey, BitSize bits) {
        this.algorithm = Signer.algorithm(privateKey, bits);
    }

    private static Algorithm algorithm(PrivateKey key, BitSize bits) {
        Algorithm algorithm;
        net.pincette.util.Util.must((key instanceof RSAKey || key instanceof ECKey ? 1 : 0) != 0);
        if (key instanceof RSAKey) {
            RSAKey k = (RSAKey)((Object)key);
            algorithm = bits.rsaAlgorithm.apply(k);
        } else {
            algorithm = bits.ecAlgorithm.apply((ECKey)((Object)key));
        }
        return algorithm;
    }

    public String sign(JWTCreator.Builder builder) {
        return builder.sign(this.algorithm);
    }
}

