/*
 * Decompiled with CFR 0.152.
 */
package net.pincette.jes;

import java.util.Collection;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.json.JsonArray;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonStructure;
import javax.json.JsonValue;
import net.pincette.jes.Util;
import net.pincette.json.JsonUtil;
import net.pincette.util.Collections;
import net.pincette.util.ImmutableBuilder;
import net.pincette.util.Or;

public class Command {
    private Command() {
    }

    public static JsonObject createCommand(String type, String id, String name) {
        return Command.createCommandBuilder(type, id, name).build();
    }

    public static JsonObjectBuilder createCommandBuilder(String type, String id, String name) {
        return JsonUtil.createObjectBuilder().add("_type", type).add("_id", id.toLowerCase()).add("_command", name);
    }

    public static JsonObject createCommandFor(JsonObject json, String name) {
        return Command.createCommandBuilderFor(json, name).build();
    }

    public static JsonObjectBuilder createCommandBuilderFor(JsonObject json, String name) {
        return (JsonObjectBuilder)ImmutableBuilder.create(() -> Command.createCommandBuilder(json.getString("_type"), json.getString("_id"), name)).updateIf(builder -> json.containsKey((Object)"_jwt"), builder -> builder.add("_jwt", (JsonValue)json.getJsonObject("_jwt"))).build();
    }

    private static Optional<JsonArray> getAllowedRoles(JsonObject state, JsonObject command) {
        return Or.tryWith(() -> JsonUtil.getArray((JsonStructure)state, (String)("/_acl/" + command.getString("_command"))).orElse(null)).or(() -> JsonUtil.getArray((JsonStructure)state, (String)"/_acl/write").orElse(null)).get();
    }

    public static boolean hasError(JsonObject json) {
        return json != null && (json.getBoolean("_error", false) || !json.getBoolean("valid", true));
    }

    public static boolean isAllowed(JsonObject currentState, JsonObject command, boolean breakingTheGlass) {
        return Util.getUsername(command).map(user -> user.equals("system") || !currentState.containsKey((Object)"_acl") || breakingTheGlass && JsonUtil.getBoolean((JsonStructure)command, (String)"/_jwt/breakingTheGlass").orElse(false) != false || JsonUtil.getArray((JsonStructure)command, (String)"/_jwt/roles").map(JsonUtil::strings).map(roles -> Command.isAllowed(currentState, command, Stream.concat(roles, Stream.of(user)).collect(Collectors.toSet()))).orElse(false) != false).orElse(false);
    }

    private static boolean isAllowed(JsonObject state, JsonObject command, Set<String> roles) {
        Optional<JsonArray> allowed = Command.getAllowedRoles(state, command);
        return allowed.isEmpty() || allowed.map(JsonUtil::strings).map(principals -> principals.collect(Collectors.toSet())).map(principals -> !Collections.intersection((Collection[])new Collection[]{principals, roles}).isEmpty()).orElse(false) != false;
    }

    public static boolean isCommand(JsonObject json) {
        return Util.isJesObject(json) && JsonUtil.getString((JsonStructure)json, (String)"/_corr").isPresent() && JsonUtil.getString((JsonStructure)json, (String)"/_command").isPresent() && ("patch".equals(json.getString("_command")) || !json.containsKey((Object)"_ops"));
    }

    public static boolean isCommand(JsonObject command, String name) {
        return Command.isCommand(command) && name != null && name.equals(command.getString("_command"));
    }
}

