@file:OptIn(ExperimentalTypeInference::class)

package net.peanuuutz.fork.util.common

import kotlin.experimental.ExperimentalTypeInference

// -------- ByteArray --------

public inline fun ByteArray.fastAny(predicate: (Byte) -> Boolean): Boolean {
    for (i in indices) {
        if (predicate(get(i))) {
            return true
        }
    }
    return false
}

public inline fun ByteArray.fastAll(predicate: (Byte) -> Boolean): Boolean {
    for (i in indices) {
        if (predicate(get(i)).not()) {
            return false
        }
    }
    return true
}

public inline fun ByteArray.fastForEach(action: (Byte) -> Unit) {
    for (i in indices) {
        action(get(i))
    }
}

public inline fun ByteArray.fastForEachIndexed(action: (index: Int, Byte) -> Unit) {
    for (i in indices) {
        action(i, get(i))
    }
}

public inline fun ByteArray.fastForEachReversed(action: (Byte) -> Unit) {
    for (i in lastIndex downTo 0) {
        action(get(i))
    }
}

public inline fun ByteArray.fastForEachIndexedReversed(action: (index: Int, Byte) -> Unit) {
    for (i in lastIndex downTo 0) {
        action(i, get(i))
    }
}

public inline fun ByteArray.fastIndexOfFirst(predicate: (Byte) -> Boolean): Int {
    for (i in indices) {
        if (predicate(get(i))) {
            return i
        }
    }
    return -1
}

public inline fun ByteArray.fastIndexOfLast(predicate: (Byte) -> Boolean): Int {
    for (i in lastIndex downTo 0) {
        if (predicate(get(i))) {
            return i
        }
    }
    return -1
}

public fun ByteArray.fastJoinToString(
    separator: CharSequence = ", ",
    prefix: CharSequence = "",
    suffix: CharSequence = "",
    transform: (Byte) -> String = { it.toString() }
): String {
    val lastIndex = lastIndex
    val builder = StringBuilder(prefix)
    for (i in indices) {
        builder.append(transform(get(i)))
        if (i != lastIndex) {
            builder.append(separator)
        }
    }
    return builder.append(suffix).toString()
}

public inline fun <R> ByteArray.fastMap(transform: (Byte) -> R): List<R> {
    val result = ArrayList<R>(size)
    for (i in indices) {
        result.add(transform(get(i)))
    }
    return result
}

public inline fun <R> ByteArray.fastMapIndexed(transform: (index: Int, Byte) -> R): List<R> {
    val result = ArrayList<R>(size)
    for (i in indices) {
        result.add(transform(i, get(i)))
    }
    return result
}

public inline fun ByteArray.fastFilter(predicate: (Byte) -> Boolean): List<Byte> {
    val result = mutableListOf<Byte>()
    for (i in indices) {
        val item = get(i)
        if (predicate(item)) {
            result.add(item)
        }
    }
    return result
}

// -------- IntArray --------

public inline fun IntArray.fastAny(predicate: (Int) -> Boolean): Boolean {
    for (i in indices) {
        if (predicate(get(i))) {
            return true
        }
    }
    return false
}

public inline fun IntArray.fastAll(predicate: (Int) -> Boolean): Boolean {
    for (i in indices) {
        if (predicate(get(i)).not()) {
            return false
        }
    }
    return true
}

public inline fun IntArray.fastForEach(action: (Int) -> Unit) {
    for (i in indices) {
        action(get(i))
    }
}

public inline fun IntArray.fastForEachIndexed(action: (index: Int, Int) -> Unit) {
    for (i in indices) {
        action(i, get(i))
    }
}

public inline fun IntArray.fastForEachReversed(action: (Int) -> Unit) {
    for (i in lastIndex downTo 0) {
        action(get(i))
    }
}

public inline fun IntArray.fastForEachIndexedReversed(action: (index: Int, Int) -> Unit) {
    for (i in lastIndex downTo 0) {
        action(i, get(i))
    }
}

public inline fun IntArray.fastIndexOfFirst(predicate: (Int) -> Boolean): Int {
    for (i in indices) {
        if (predicate(get(i))) {
            return i
        }
    }
    return -1
}

public inline fun IntArray.fastIndexOfLast(predicate: (Int) -> Boolean): Int {
    for (i in lastIndex downTo 0) {
        if (predicate(get(i))) {
            return i
        }
    }
    return -1
}

public fun IntArray.fastSum(): Int {
    var sum = 0
    for (i in indices) {
        sum += get(i)
    }
    return sum
}

public fun IntArray.fastJoinToString(
    separator: CharSequence = ", ",
    prefix: CharSequence = "",
    suffix: CharSequence = "",
    transform: (Int) -> String = { it.toString() }
): String {
    val lastIndex = lastIndex
    val builder = StringBuilder(prefix)
    for (i in indices) {
        builder.append(transform(get(i)))
        if (i != lastIndex) {
            builder.append(separator)
        }
    }
    return builder.append(suffix).toString()
}

public inline fun <R> IntArray.fastMap(transform: (Int) -> R): List<R> {
    val result = ArrayList<R>(size)
    for (i in indices) {
        result.add(transform(get(i)))
    }
    return result
}

public inline fun <R> IntArray.fastMapIndexed(transform: (index: Int, Int) -> R): List<R> {
    val result = ArrayList<R>(size)
    for (i in indices) {
        result.add(transform(i, get(i)))
    }
    return result
}

public inline fun IntArray.fastFilter(predicate: (Int) -> Boolean): List<Int> {
    val result = mutableListOf<Int>()
    for (i in indices) {
        val item = get(i)
        if (predicate(item)) {
            result.add(item)
        }
    }
    return result
}

// -------- FloatArray --------

public inline fun FloatArray.fastAny(predicate: (Float) -> Boolean): Boolean {
    for (i in indices) {
        if (predicate(get(i))) {
            return true
        }
    }
    return false
}

public inline fun FloatArray.fastAll(predicate: (Float) -> Boolean): Boolean {
    for (i in indices) {
        if (predicate(get(i)).not()) {
            return false
        }
    }
    return true
}

public inline fun FloatArray.fastForEach(action: (Float) -> Unit) {
    for (i in indices) {
        action(get(i))
    }
}

public inline fun FloatArray.fastForEachIndexed(action: (index: Int, Float) -> Unit) {
    for (i in indices) {
        action(i, get(i))
    }
}

public inline fun FloatArray.fastForEachReversed(action: (Float) -> Unit) {
    for (i in lastIndex downTo 0) {
        action(get(i))
    }
}

public inline fun FloatArray.fastForEachIndexedReversed(action: (index: Int, Float) -> Unit) {
    for (i in lastIndex downTo 0) {
        action(i, get(i))
    }
}

public inline fun FloatArray.fastIndexOfFirst(predicate: (Float) -> Boolean): Int {
    for (i in indices) {
        if (predicate(get(i))) {
            return i
        }
    }
    return -1
}

public inline fun FloatArray.fastIndexOfLast(predicate: (Float) -> Boolean): Int {
    for (i in lastIndex downTo 0) {
        if (predicate(get(i))) {
            return i
        }
    }
    return -1
}

public fun FloatArray.fastSum(): Float {
    var sum = 0.0f
    for (i in indices) {
        sum += get(i)
    }
    return sum
}

public fun FloatArray.fastJoinToString(
    separator: CharSequence = ", ",
    prefix: CharSequence = "",
    suffix: CharSequence = "",
    transform: (Float) -> String = { it.toString() }
): String {
    val lastIndex = lastIndex
    val builder = StringBuilder(prefix)
    for (i in indices) {
        builder.append(transform(get(i)))
        if (i != lastIndex) {
            builder.append(separator)
        }
    }
    return builder.append(suffix).toString()
}

public inline fun <R> FloatArray.fastMap(transform: (Float) -> R): List<R> {
    val result = ArrayList<R>(size)
    for (i in indices) {
        result.add(transform(get(i)))
    }
    return result
}

public inline fun <R> FloatArray.fastMapIndexed(transform: (index: Int, Float) -> R): List<R> {
    val result = ArrayList<R>(size)
    for (i in indices) {
        result.add(transform(i, get(i)))
    }
    return result
}

public inline fun FloatArray.fastFilter(predicate: (Float) -> Boolean): List<Float> {
    val result = mutableListOf<Float>()
    for (i in indices) {
        val item = get(i)
        if (predicate(item)) {
            result.add(item)
        }
    }
    return result
}

// -------- DoubleArray --------

public inline fun DoubleArray.fastAny(predicate: (Double) -> Boolean): Boolean {
    for (i in indices) {
        if (predicate(get(i))) {
            return true
        }
    }
    return false
}

public inline fun DoubleArray.fastAll(predicate: (Double) -> Boolean): Boolean {
    for (i in indices) {
        if (predicate(get(i)).not()) {
            return false
        }
    }
    return true
}

public inline fun DoubleArray.fastForEach(action: (Double) -> Unit) {
    for (i in indices) {
        action(get(i))
    }
}

public inline fun DoubleArray.fastForEachIndexed(action: (index: Int, Double) -> Unit) {
    for (i in indices) {
        action(i, get(i))
    }
}

public inline fun DoubleArray.fastForEachReversed(action: (Double) -> Unit) {
    for (i in lastIndex downTo 0) {
        action(get(i))
    }
}

public inline fun DoubleArray.fastForEachIndexedReversed(action: (index: Int, Double) -> Unit) {
    for (i in lastIndex downTo 0) {
        action(i, get(i))
    }
}

public inline fun DoubleArray.fastIndexOfFirst(predicate: (Double) -> Boolean): Int {
    for (i in indices) {
        if (predicate(get(i))) {
            return i
        }
    }
    return -1
}

public inline fun DoubleArray.fastIndexOfLast(predicate: (Double) -> Boolean): Int {
    for (i in lastIndex downTo 0) {
        if (predicate(get(i))) {
            return i
        }
    }
    return -1
}

public fun DoubleArray.fastSum(): Double {
    var sum = 0.0
    for (i in indices) {
        sum += get(i)
    }
    return sum
}

public fun DoubleArray.fastJoinToString(
    separator: CharSequence = ", ",
    prefix: CharSequence = "",
    suffix: CharSequence = "",
    transform: (Double) -> String = { it.toString() }
): String {
    val lastIndex = lastIndex
    val builder = StringBuilder(prefix)
    for (i in indices) {
        builder.append(transform(get(i)))
        if (i != lastIndex) {
            builder.append(separator)
        }
    }
    return builder.append(suffix).toString()
}

public inline fun <R> DoubleArray.fastMap(transform: (Double) -> R): List<R> {
    val result = ArrayList<R>(size)
    for (i in indices) {
        result.add(transform(get(i)))
    }
    return result
}

public inline fun <R> DoubleArray.fastMapIndexed(transform: (index: Int, Double) -> R): List<R> {
    val result = ArrayList<R>(size)
    for (i in indices) {
        result.add(transform(i, get(i)))
    }
    return result
}

public inline fun DoubleArray.fastFilter(predicate: (Double) -> Boolean): List<Double> {
    val result = mutableListOf<Double>()
    for (i in indices) {
        val item = get(i)
        if (predicate(item)) {
            result.add(item)
        }
    }
    return result
}

// -------- CharArray --------

public inline fun CharArray.fastAny(predicate: (Char) -> Boolean): Boolean {
    for (i in indices) {
        if (predicate(get(i))) {
            return true
        }
    }
    return false
}

public inline fun CharArray.fastAll(predicate: (Char) -> Boolean): Boolean {
    for (i in indices) {
        if (predicate(get(i)).not()) {
            return false
        }
    }
    return true
}

public inline fun CharArray.fastForEach(action: (Char) -> Unit) {
    for (i in indices) {
        action(get(i))
    }
}

public inline fun CharArray.fastForEachIndexed(action: (index: Int, Char) -> Unit) {
    for (i in indices) {
        action(i, get(i))
    }
}

public inline fun CharArray.fastForEachReversed(action: (Char) -> Unit) {
    for (i in lastIndex downTo 0) {
        action(get(i))
    }
}

public inline fun CharArray.fastForEachIndexedReversed(action: (index: Int, Char) -> Unit) {
    for (i in lastIndex downTo 0) {
        action(i, get(i))
    }
}

public inline fun CharArray.fastIndexOfFirst(predicate: (Char) -> Boolean): Int {
    for (i in indices) {
        if (predicate(get(i))) {
            return i
        }
    }
    return -1
}

public inline fun CharArray.fastIndexOfLast(predicate: (Char) -> Boolean): Int {
    for (i in lastIndex downTo 0) {
        if (predicate(get(i))) {
            return i
        }
    }
    return -1
}

public fun CharArray.fastJoinToString(
    separator: CharSequence = ", ",
    prefix: CharSequence = "",
    suffix: CharSequence = "",
    transform: (Char) -> String = { it.toString() }
): String {
    val lastIndex = lastIndex
    val builder = StringBuilder(prefix)
    for (i in indices) {
        builder.append(transform(get(i)))
        if (i != lastIndex) {
            builder.append(separator)
        }
    }
    return builder.append(suffix).toString()
}

public inline fun <R> CharArray.fastMap(transform: (Char) -> R): List<R> {
    val result = ArrayList<R>(size)
    for (i in indices) {
        result.add(transform(get(i)))
    }
    return result
}

public inline fun <R> CharArray.fastMapIndexed(transform: (index: Int, Char) -> R): List<R> {
    val result = ArrayList<R>(size)
    for (i in indices) {
        result.add(transform(i, get(i)))
    }
    return result
}

public inline fun CharArray.fastFilter(predicate: (Char) -> Boolean): List<Char> {
    val result = mutableListOf<Char>()
    for (i in indices) {
        val item = get(i)
        if (predicate(item)) {
            result.add(item)
        }
    }
    return result
}

// -------- Array --------

public inline fun <T> Array<T>.fastAny(predicate: (T) -> Boolean): Boolean {
    for (i in indices) {
        if (predicate(get(i))) {
            return true
        }
    }
    return false
}

public inline fun <T> Array<T>.fastAll(predicate: (T) -> Boolean): Boolean {
    for (i in indices) {
        if (predicate(get(i)).not()) {
            return false
        }
    }
    return true
}

public inline fun <T> Array<T>.fastForEach(action: (T) -> Unit) {
    for (i in indices) {
        action(get(i))
    }
}

public inline fun <T> Array<T>.fastForEachIndexed(action: (index: Int, T) -> Unit) {
    for (i in indices) {
        action(i, get(i))
    }
}

public inline fun <T> Array<T>.fastForEachReversed(action: (T) -> Unit) {
    for (i in lastIndex downTo 0) {
        action(get(i))
    }
}

public inline fun <T> Array<T>.fastForEachIndexedReversed(action: (index: Int, T) -> Unit) {
    for (i in lastIndex downTo 0) {
        action(i, get(i))
    }
}

public inline fun <T> Array<T>.fastIndexOfFirst(predicate: (T) -> Boolean): Int {
    for (i in indices) {
        if (predicate(get(i))) {
            return i
        }
    }
    return -1
}

public inline fun <T> Array<T>.fastIndexOfLast(predicate: (T) -> Boolean): Int {
    for (i in lastIndex downTo 0) {
        if (predicate(get(i))) {
            return i
        }
    }
    return -1
}

@OverloadResolutionByLambdaReturnType
public inline fun <T> Array<T>.fastSumOf(selector: (T) -> Int): Int {
    var sum = 0
    for (i in indices) {
        sum += selector(get(i))
    }
    return sum
}

@OverloadResolutionByLambdaReturnType
public inline fun <T> Array<T>.fastSumOf(selector: (T) -> Float): Float {
    var sum = 0.0f
    for (i in indices) {
        sum += selector(get(i))
    }
    return sum
}

@OverloadResolutionByLambdaReturnType
public inline fun <T> Array<T>.fastSumOf(selector: (T) -> Double): Double {
    var sum = 0.0
    for (i in indices) {
        sum += selector(get(i))
    }
    return sum
}

public fun <T> Array<T>.fastJoinToString(
    separator: CharSequence = ", ",
    prefix: CharSequence = "",
    suffix: CharSequence = "",
    transform: (T) -> String = { it.toString() }
): String {
    val lastIndex = lastIndex
    val builder = StringBuilder(prefix)
    for (i in indices) {
        builder.append(transform(get(i)))
        if (i != lastIndex) {
            builder.append(separator)
        }
    }
    return builder.append(suffix).toString()
}

public inline fun <T, R> Array<T>.fastMap(transform: (T) -> R): List<R> {
    val result = ArrayList<R>(size)
    for (i in indices) {
        result.add(transform(get(i)))
    }
    return result
}

public inline fun <T, R> Array<T>.fastMapIndexed(transform: (index: Int, T) -> R): List<R> {
    val result = ArrayList<R>(size)
    for (i in indices) {
        result.add(transform(i, get(i)))
    }
    return result
}

public inline fun <T> Array<T>.fastFilter(predicate: (T) -> Boolean): List<T> {
    val result = mutableListOf<T>()
    for (i in indices) {
        val item = get(i)
        if (predicate(item)) {
            result.add(item)
        }
    }
    return result
}

public fun <T> Array<T>.fastToList(): List<T> {
    return List(size) { get(it) }
}

// -------- List --------

public inline fun <T> List<T>.fastAny(predicate: (T) -> Boolean): Boolean {
    for (i in indices) {
        if (predicate(get(i))) {
            return true
        }
    }
    return false
}

public inline fun <T> List<T>.fastAll(predicate: (T) -> Boolean): Boolean {
    for (i in indices) {
        if (predicate(get(i)).not()) {
            return false
        }
    }
    return true
}

public inline fun <T> List<T>.fastForEach(action: (T) -> Unit) {
    for (i in indices) {
        action(get(i))
    }
}

public inline fun <T> List<T>.fastForEachIndexed(action: (index: Int, T) -> Unit) {
    for (i in indices) {
        action(i, get(i))
    }
}

public inline fun <T> List<T>.fastForEachReversed(action: (T) -> Unit) {
    for (i in lastIndex downTo 0) {
        action(get(i))
    }
}

public inline fun <T> List<T>.fastForEachIndexedReversed(action: (index: Int, T) -> Unit) {
    for (i in lastIndex downTo 0) {
        action(i, get(i))
    }
}

public inline fun <T> List<T>.fastIndexOfFirst(predicate: (T) -> Boolean): Int {
    for (i in indices) {
        if (predicate(get(i))) {
            return i
        }
    }
    return -1
}

public inline fun <T> List<T>.fastIndexOfLast(predicate: (T) -> Boolean): Int {
    for (i in lastIndex downTo 0) {
        if (predicate(get(i))) {
            return i
        }
    }
    return -1
}

@OverloadResolutionByLambdaReturnType
public inline fun <T> List<T>.fastSumOf(selector: (T) -> Int): Int {
    var sum = 0
    for (i in indices) {
        sum += selector(get(i))
    }
    return sum
}

@OverloadResolutionByLambdaReturnType
public inline fun <T> List<T>.fastSumOf(selector: (T) -> Float): Float {
    var sum = 0.0f
    for (i in indices) {
        sum += selector(get(i))
    }
    return sum
}

@OverloadResolutionByLambdaReturnType
public inline fun <T> List<T>.fastSumOf(selector: (T) -> Double): Double {
    var sum = 0.0
    for (i in indices) {
        sum += selector(get(i))
    }
    return sum
}

public fun <T> List<T>.fastJoinToString(
    separator: CharSequence = ", ",
    prefix: CharSequence = "",
    suffix: CharSequence = "",
    transform: (T) -> String = { it.toString() }
): String {
    val lastIndex = lastIndex
    val builder = StringBuilder(prefix)
    for (i in indices) {
        builder.append(transform(get(i)))
        if (i != lastIndex) {
            builder.append(separator)
        }
    }
    return builder.append(suffix).toString()
}

public inline fun <T, R> List<T>.fastMap(transform: (T) -> R): List<R> {
    val result = ArrayList<R>(size)
    for (i in indices) {
        result.add(transform(get(i)))
    }
    return result
}

public inline fun <T, R> List<T>.fastMapIndexed(transform: (index: Int, T) -> R): List<R> {
    val result = ArrayList<R>(size)
    for (i in indices) {
        result.add(transform(i, get(i)))
    }
    return result
}

public inline fun <T> List<T>.fastFilter(predicate: (T) -> Boolean): List<T> {
    val result = mutableListOf<T>()
    for (i in indices) {
        val item = get(i)
        if (predicate(item)) {
            result.add(item)
        }
    }
    return result
}

public inline fun <T, R> List<T>.fastFold(initial: R, operation: (acc: R, T) -> R): R {
    var accumulator = initial
    for (i in indices) {
        accumulator = operation(accumulator, get(i))
    }
    return accumulator
}

public inline fun <T> List<T>.fastFind(predicate: (T) -> Boolean): T {
    return fastFindOrNull(predicate) ?: missing("Cannot find element matching the predicate")
}

public inline fun <T> List<T>.fastFindOrNull(predicate: (T) -> Boolean): T? {
    for (i in indices) {
        val item = get(i)
        if (predicate(item)) {
            return item
        }
    }
    return null
}

public inline fun <reified V> List<*>.fastFindInstance(): V {
    return fastFindInstanceOrNull<V>() ?: missing("Cannot find element matching class ${V::class.simpleName}")
}

public inline fun <reified V> List<*>.fastFindInstanceOrNull(): V? {
    for (i in indices) {
        val item = get(i)
        if (item is V) {
            return item
        }
    }
    return null
}

public fun List<Byte>.toByteArray(): ByteArray {
    return ByteArray(size) { get(it) }
}

public fun List<Short>.toShortArray(): ShortArray {
    return ShortArray(size) { get(it) }
}

public fun List<Int>.toIntArray(): IntArray {
    return IntArray(size) { get(it) }
}

public fun List<Long>.toLongArray(): LongArray {
    return LongArray(size) { get(it) }
}

public fun List<Float>.toByteArray(): FloatArray {
    return FloatArray(size) { get(it) }
}

public fun List<Double>.toDoubleArray(): DoubleArray {
    return DoubleArray(size) { get(it) }
}

public fun List<Char>.toCharArray(): CharArray {
    return CharArray(size) { get(it) }
}

// ======== Internal ========

@PublishedApi
internal fun missing(message: String): Nothing {
    throw NoSuchElementException(message)
}
