package net.peanuuutz.fork.math

import org.joml.Vector2d
import org.joml.Vector2dc
import org.joml.Vector2f
import org.joml.Vector2fc
import org.joml.Vector2ic
import org.joml.Vector3f
import org.joml.Vector3fc

// TODO Deprecate when Mojang promotes JOML version

// -------- Vector2d --------

public operator fun Vector2dc.component1(): Double = x()

public operator fun Vector2dc.component2(): Double = y()

public fun Vector2dc.rotate(radian: Float, dest: Vector2d): Vector2d {
    val (x, y) = this
    val dstX = x * fastCos(radian) - y * fastSin(radian)
    val dstY = x * fastSin(radian) + y * fastCos(radian)
    dest.set(dstX, dstY)
    return dest
}

public fun Vector2d.rotate(radian: Float): Vector2d {
    return rotate(radian, this)
}

public infix fun Vector2dc.cross(other: Vector2dc): Double {
    return x() * other.y() - y() * other.x()
}

public infix fun Vector2dc.dot(other: Vector2dc): Double {
    return dot(other)
}

// -------- Vector2f --------

// TODO Migrate to namespace
public object Vector2fs {
    public val PositiveX: Vector2fc = Vector2f(1.0f, 0.0f)

    public val NegativeX: Vector2fc = Vector2f(-1.0f, 0.0f)

    public val PositiveY: Vector2fc = Vector2f(0.0f, 1.0f)

    public val NegativeY: Vector2fc = Vector2f(0.0f, -1.0f)
}

public operator fun Vector2fc.component1(): Float = x()

public operator fun Vector2fc.component2(): Float = y()

public fun Vector2fc.rotate(radian: Float, dest: Vector2f): Vector2f {
    val (x, y) = this
    val dstX = x * fastCos(radian) - y * fastSin(radian)
    val dstY = x * fastSin(radian) + y * fastCos(radian)
    dest.set(dstX, dstY)
    return dest
}

public fun Vector2f.rotate(radian: Float): Vector2f {
    return rotate(radian, this)
}

public infix fun Vector2fc.cross(other: Vector2fc): Float {
    return x() * other.y() - y() * other.x()
}

public infix fun Vector2fc.dot(other: Vector2fc): Float {
    return dot(other)
}

// -------- Vector2i --------

public operator fun Vector2ic.component1(): Int = x()

public operator fun Vector2ic.component2(): Int = y()

// -------- Vector3f --------

// TODO Migrate to namespace
public object Vector3fs {
    public val PositiveX: Vector3fc = Vector3f(1.0f, 0.0f, 0.0f)

    public val NegativeX: Vector3fc = Vector3f(-1.0f, 0.0f, 0.0f)

    public val PositiveY: Vector3fc = Vector3f(0.0f, 1.0f, 0.0f)

    public val NegativeY: Vector3fc = Vector3f(0.0f, -1.0f, 0.0f)

    public val PositiveZ: Vector3fc = Vector3f(0.0f, 0.0f, 1.0f)

    public val NegativeZ: Vector3fc = Vector3f(0.0f, 0.0f, -1.0f)
}
