package net.peanuuutz.fork.math

import org.joml.Math.cos
import org.joml.Math.sin
import kotlin.math.PI

public const val PIDoubled: Double = PI * 2

public const val PIHalved: Double = PI / 2

public const val FloatPI: Float = PI.toFloat()

public const val FloatPIDoubled: Float = PIDoubled.toFloat()

public const val FloatPIHalved: Float = PIHalved.toFloat()

@Suppress("NOTHING_TO_INLINE")
public inline fun fastSin(radian: Float): Float {
    return sin(radian)
}

@Suppress("NOTHING_TO_INLINE")
public inline fun fastSin(radian: Double): Double {
    return sin(radian)
}

@Suppress("NOTHING_TO_INLINE")
public inline fun fastCos(radian: Float): Float {
    return cos(radian)
}

@Suppress("NOTHING_TO_INLINE")
public inline fun fastCos(radian: Double): Double {
    return cos(radian)
}

@Suppress("NOTHING_TO_INLINE")
public inline fun Float.toRadian(): Float {
    return this / 180 * FloatPI
}

@Suppress("NOTHING_TO_INLINE")
public inline fun Double.toRadian(): Double {
    return this / 180 * PI
}

@Suppress("NOTHING_TO_INLINE")
public inline fun Float.toDegree(): Float {
    return this / FloatPI * 180
}

@Suppress("NOTHING_TO_INLINE")
public inline fun Double.toDegree(): Double {
    return this / PI * 180
}
