/*
 * Decompiled with CFR 0.152.
 */
package net.peachjean.commons.base.service;

import com.google.common.base.Charsets;
import com.google.common.base.Throwables;
import com.google.common.collect.Maps;
import com.google.common.io.Resources;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Enumeration;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import net.peachjean.commons.base.service.ServiceImplementation;
import net.peachjean.commons.base.service.ServiceLookupException;
import net.peachjean.commons.base.service.ServiceName;

public class ServiceLoader<T> {
    private Class<T> serviceType;
    private Map<String, Class<? extends T>> nameMap;

    public ServiceLoader(Class<T> serviceType) {
        this.serviceType = serviceType;
        this.nameMap = ServiceLoader.loadNameMap(serviceType);
    }

    private static <T> Map<String, Class<? extends T>> loadNameMap(Class<T> serviceType) {
        ConcurrentMap nameMap = Maps.newConcurrentMap();
        try {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            Enumeration<URL> serviceDescriptors = classLoader.getResources(serviceType.getName());
            while (serviceDescriptors.hasMoreElements()) {
                for (String line : Resources.readLines((URL)serviceDescriptors.nextElement(), (Charset)Charsets.UTF_8)) {
                    Class<?> implementationType = classLoader.loadClass(line);
                    if (!serviceType.isAssignableFrom(implementationType)) {
                        throw new ServiceLookupException(serviceType, implementationType);
                    }
                    if (implementationType.isAnnotationPresent(ServiceName.class)) {
                        nameMap.put(implementationType.getAnnotation(ServiceName.class).value(), implementationType);
                    }
                    nameMap.put(implementationType.getName(), implementationType);
                }
            }
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
        catch (ClassNotFoundException e) {
            throw Throwables.propagate((Throwable)e);
        }
        return nameMap;
    }

    public ServiceImplementation<T> lookup(String name) throws ServiceLookupException {
        if (this.nameMap.containsKey(name)) {
            return new ServiceImplementation<T>(this.serviceType, this.nameMap.get(name));
        }
        try {
            Class<T> fqcn = this.loadAsFQCN(name);
            if (!this.serviceType.isAssignableFrom(fqcn)) {
                throw new ServiceLookupException(this.serviceType, fqcn);
            }
            this.nameMap.put(name, fqcn);
            return new ServiceImplementation<T>(this.serviceType, fqcn);
        }
        catch (ClassNotFoundException e) {
            throw new ServiceLookupException(this.serviceType, name);
        }
    }

    private Class<? extends T> loadAsFQCN(String name) throws ClassNotFoundException {
        return Thread.currentThread().getContextClassLoader().loadClass(name);
    }
}

