/*
 * Decompiled with CFR 0.152.
 */
package net.peachjean.commons.base.service;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import net.peachjean.commons.base.constructor.ConstructorSignatures;
import net.peachjean.commons.base.service.ServiceInstantiationException;

public class ServiceImplementation<T> {
    private Class<T> serviceType;
    private Class<? extends T> implementationType;

    public ServiceImplementation(Class<T> serviceType, Class<? extends T> implementationType) {
        this.serviceType = serviceType;
        this.implementationType = implementationType;
    }

    public T instantiate(Object ... args) {
        Class<?>[] argTypes = ConstructorSignatures.forService(this.serviceType);
        try {
            Constructor<T> constructor = this.implementationType.getConstructor(argTypes);
            return constructor.newInstance(args);
        }
        catch (NoSuchMethodException e) {
            throw new ServiceInstantiationException(this.serviceType, this.implementationType, e);
        }
        catch (InvocationTargetException e) {
            throw new ServiceInstantiationException(this.serviceType, this.implementationType, e);
        }
        catch (InstantiationException e) {
            throw new ServiceInstantiationException(this.serviceType, this.implementationType, e);
        }
        catch (IllegalAccessException e) {
            throw new ServiceInstantiationException(this.serviceType, this.implementationType, e);
        }
    }
}

