/*
 * Decompiled with CFR 0.152.
 */
package net.peachjean.commons.base.service;

import com.google.common.collect.Lists;
import com.google.common.io.Closeables;
import com.google.common.io.OutputSupplier;
import java.io.Closeable;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import javax.lang.model.type.TypeMirror;
import net.peachjean.commons.base.constructor.ConstructorSignatureProcessor;
import org.antlr.stringtemplate.AutoIndentWriter;
import org.antlr.stringtemplate.StringTemplate;
import org.antlr.stringtemplate.StringTemplateGroup;
import org.antlr.stringtemplate.StringTemplateWriter;

class ServiceDescriptor {
    public static final String TEMPLATE_PATH = ServiceDescriptor.class.getPackage().getName().replaceAll("\\.", "/") + "/";
    private String packageName;
    private String simpleName;
    private List<List<ArgDescriptor>> constructorArgList;

    ServiceDescriptor(String packageName, String simpleName, Iterable<ConstructorSignatureProcessor.ConstructorRequirement> constructorRequirements) {
        this.packageName = packageName;
        this.simpleName = simpleName;
        this.constructorArgList = Lists.newArrayList();
        int index = 0;
        for (ConstructorSignatureProcessor.ConstructorRequirement constructorRequirement : constructorRequirements) {
            ArrayList argList = Lists.newArrayList();
            for (TypeMirror argType : constructorRequirement.getParams()) {
                argList.add(new ArgDescriptor(argType.toString(), "arg" + index++));
            }
            this.constructorArgList.add(argList);
        }
    }

    public String getPackageName() {
        return this.packageName;
    }

    public String getSimpleName() {
        return this.simpleName;
    }

    public List<List<ArgDescriptor>> getConstructorArgList() {
        return this.constructorArgList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generateSource(OutputSupplier<Writer> writerSupplier) throws IOException {
        StringTemplateGroup stGroup = new StringTemplateGroup("parameterResolver"){

            public String getFileNameFromTemplateName(String templateName) {
                return TEMPLATE_PATH + super.getFileNameFromTemplateName(templateName);
            }
        };
        StringTemplate typeTemplate = stGroup.getInstanceOf("factoryClass");
        typeTemplate.setAttribute("serviceType", (Object)this);
        Writer writer = (Writer)writerSupplier.getOutput();
        try {
            typeTemplate.write((StringTemplateWriter)new AutoIndentWriter(writer, "\n"));
        }
        finally {
            Closeables.close((Closeable)writer, (boolean)false);
        }
    }

    private static class ArgDescriptor {
        private String type;
        private String name;

        ArgDescriptor(String type, String name) {
            this.type = type;
            this.name = name;
        }

        public String getType() {
            return this.type;
        }

        public String getName() {
            return this.name;
        }
    }
}

