/*
 * Decompiled with CFR 0.152.
 */
package net.peachjean.commons.base.constructor;

import com.google.common.base.Optional;
import java.lang.annotation.Annotation;
import net.peachjean.commons.base.constructor.ConstructorSignature;

public class ConstructorSignatures {
    private ConstructorSignatures() {
    }

    public static Class<?>[] forService(Class<?> serviceType) {
        Optional<ConstructorSignature> args = ConstructorSignatures.getConstructorArgs(serviceType);
        if (!args.isPresent()) {
            throw new IllegalArgumentException("No constructor signature defined for " + serviceType.getName());
        }
        return ((ConstructorSignature)args.get()).value();
    }

    private static Optional<ConstructorSignature> getConstructorArgs(Class<?> serviceType) {
        for (Annotation annotation : serviceType.getAnnotations()) {
            if (annotation instanceof ConstructorSignature) {
                return Optional.of((Object)((ConstructorSignature)annotation));
            }
            Optional<ConstructorSignature> applied = ConstructorSignatures.getConstructorArgs(annotation.getClass());
            if (!applied.isPresent()) continue;
            return applied;
        }
        return Optional.absent();
    }
}

