/*
 * Decompiled with CFR 0.152.
 */
package net.peachjean.commons.base.constructor;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.NoType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.SimpleAnnotationValueVisitor6;
import javax.lang.model.util.SimpleElementVisitor6;
import javax.lang.model.util.SimpleTypeVisitor6;
import javax.tools.Diagnostic;
import net.peachjean.commons.base.constructor.ConstructorSignature;

@SupportedAnnotationTypes(value={"*"})
public class ConstructorSignatureProcessor
extends AbstractProcessor {
    private TypeMirror constructorArgsType;
    private ExecutableElement valueElement;
    private static final SimpleAnnotationValueVisitor6<TypeMirror, Object> elementVisitor = new SimpleAnnotationValueVisitor6<TypeMirror, Object>(){

        @Override
        public TypeMirror visitType(TypeMirror t, Object o) {
            return t;
        }
    };
    private static final SimpleAnnotationValueVisitor6<List<TypeMirror>, Object> valueVisitor = new SimpleAnnotationValueVisitor6<List<TypeMirror>, Object>(){

        @Override
        public List<TypeMirror> visitArray(List<? extends AnnotationValue> vals, Object o) {
            ArrayList<TypeMirror> returnValues = new ArrayList<TypeMirror>(vals.size());
            for (AnnotationValue annotationValue : vals) {
                returnValues.add((TypeMirror)annotationValue.accept(elementVisitor, null));
            }
            return returnValues;
        }
    };
    private static final SimpleElementVisitor6<TypeElement, Object> typeConversionVisitor = new SimpleElementVisitor6<TypeElement, Object>(){

        @Override
        public TypeElement visitType(TypeElement e, Object o) {
            return e;
        }
    };
    private static final SimpleTypeVisitor6<Boolean, ConstructorRequirement> requirementVisitor = new SimpleTypeVisitor6<Boolean, ConstructorRequirement>(){

        @Override
        public Boolean visitExecutable(ExecutableType t, ConstructorRequirement requirement) {
            List<? extends TypeMirror> parameterTypes = t.getParameterTypes();
            return parameterTypes.equals(requirement.getParams());
        }
    };

    @Override
    public void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        this.constructorArgsType = processingEnv.getElementUtils().getTypeElement(ConstructorSignature.class.getName()).asType();
        this.valueElement = ConstructorSignatureProcessor.getValueElement((DeclaredType)this.constructorArgsType);
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latest();
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment env) {
        this.findAndValidate(env.getRootElements());
        return false;
    }

    private void findAndValidate(Collection<? extends Element> elements) {
        for (TypeElement type : ElementFilter.typesIn(elements)) {
            this.findAndValidate(type.getEnclosedElements());
            this.findAndValidate(type);
        }
    }

    private void findAndValidate(TypeElement type) {
        for (ConstructorRequirement constructorRequirement : this.determineConcreteRequirements(type)) {
            this.validateRequirement(type, constructorRequirement);
        }
    }

    private Iterable<ConstructorRequirement> determineConcreteRequirements(TypeElement type) {
        if (type.getKind().isInterface()) {
            return Collections.emptySet();
        }
        return this.determineRequirements(type);
    }

    public Iterable<ConstructorRequirement> determineRequirements(TypeElement type) {
        HashSet requirements = Sets.newHashSet();
        this.populateRequirementsSet(requirements, type);
        return requirements;
    }

    private void populateRequirementsSet(Set<ConstructorRequirement> requirements, TypeElement type) {
        this.populateRequirementsSet(requirements, type, Sets.newHashSet());
    }

    private void populateRequirementsSet(Set<ConstructorRequirement> requirements, TypeElement type, Set<TypeElement> previouslyConsidered) {
        if (this.hasAlreadyBeenConsidered(type, previouslyConsidered)) {
            return;
        }
        this.populateRequirementsFromAnnotations(requirements, previouslyConsidered, this.buildAnnotationMirrorList(type));
        this.populateRequirementsFromInterfaces(requirements, previouslyConsidered, type.getInterfaces());
    }

    private List<? extends AnnotationMirror> buildAnnotationMirrorList(TypeElement type) {
        ImmutableList.Builder mirrorList = ImmutableList.builder();
        TypeElement target = type;
        while (target != null) {
            mirrorList.addAll(target.getAnnotationMirrors());
            TypeMirror superclass = target.getSuperclass();
            if (superclass instanceof NoType) break;
            target = (TypeElement)this.processingEnv.getTypeUtils().asElement(superclass);
        }
        return mirrorList.build();
    }

    private boolean hasAlreadyBeenConsidered(TypeElement type, Set<TypeElement> previouslyConsidered) {
        if (previouslyConsidered.contains(type)) {
            return true;
        }
        previouslyConsidered.add(type);
        return false;
    }

    private void populateRequirementsFromAnnotations(Set<ConstructorRequirement> requirements, Set<TypeElement> previouslyConsidered, List<? extends AnnotationMirror> annotationMirrors) {
        for (AnnotationMirror annotationMirror : annotationMirrors) {
            TypeElement annotationType = annotationMirror.getAnnotationType().asElement().accept(typeConversionVisitor, null);
            if (this.isConstructorArg(annotationMirror)) {
                requirements.add(new ConstructorRequirement(annotationMirror));
            }
            this.populateRequirementsSet(requirements, annotationType, previouslyConsidered);
        }
    }

    private void populateRequirementsFromInterfaces(Set<ConstructorRequirement> requirements, Set<TypeElement> previouslyConsidered, List<? extends TypeMirror> interfaces) {
        for (TypeMirror typeMirror : interfaces) {
            TypeElement interfaceType = this.processingEnv.getTypeUtils().asElement(typeMirror).accept(typeConversionVisitor, null);
            this.populateRequirementsSet(requirements, interfaceType, previouslyConsidered);
        }
    }

    private boolean isConstructorArg(AnnotationMirror mirror) {
        boolean isType = mirror.getAnnotationType().accept(new SimpleTypeVisitor6<Boolean, Object>(){

            @Override
            protected Boolean defaultAction(TypeMirror e, Object o) {
                return false;
            }

            @Override
            public Boolean visitDeclared(DeclaredType t, Object o) {
                return true;
            }
        }, null);
        return isType && this.processingEnv.getTypeUtils().isSameType(this.constructorArgsType, mirror.getAnnotationType());
    }

    private void validateRequirement(TypeElement type, ConstructorRequirement constructorRequirement) {
        if (!this.doesClassMeetRequirement(type, constructorRequirement)) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Class " + type + " needs a public Constructor with parameters " + constructorRequirement.getParams());
        }
    }

    private boolean doesClassMeetRequirement(TypeElement type, ConstructorRequirement constructorRequirement) {
        for (Element element : type.getEnclosedElements()) {
            TypeMirror mirror;
            if (element.getKind() != ElementKind.CONSTRUCTOR || !element.getModifiers().contains((Object)Modifier.PUBLIC) || !(mirror = element.asType()).accept(requirementVisitor, constructorRequirement).booleanValue()) continue;
            return true;
        }
        return false;
    }

    private static ExecutableElement getValueElement(DeclaredType type) {
        for (Element element : type.asElement().getEnclosedElements()) {
            if (!(element instanceof ExecutableElement) || !element.getSimpleName().contentEquals("value")) continue;
            return (ExecutableElement)element;
        }
        throw new IllegalStateException("Could not locate value element on " + type);
    }

    public class ConstructorRequirement {
        private final List<TypeMirror> params;

        private ConstructorRequirement(AnnotationMirror annotationMirror) {
            Preconditions.checkArgument((boolean)ConstructorSignatureProcessor.this.isConstructorArg(annotationMirror), (Object)("Requirement must be built from @" + ConstructorSignature.class.getName()));
            Map<? extends ExecutableElement, ? extends AnnotationValue> elementValuesWithDefaults = ConstructorSignatureProcessor.this.processingEnv.getElementUtils().getElementValuesWithDefaults(annotationMirror);
            this.params = Collections.unmodifiableList((List)elementValuesWithDefaults.get(ConstructorSignatureProcessor.this.valueElement).accept(valueVisitor, null));
        }

        public List<TypeMirror> getParams() {
            return this.params;
        }
    }
}

