package net.peachjean.commons.base.service;

public class ServiceInstantiationException extends RuntimeException
{
	public <T> ServiceInstantiationException(final Class<T> serviceType, final Class<? extends T> implementationType,
	                                     final Throwable cause)
	{
		super(String.format("Failed to instantiate implementation %s of service %s.", implementationType.getName(),
		                    serviceType.getName()), cause);
	}

	public <T> ServiceInstantiationException(final Class<T> serviceType, final String name)
	{
		super(String.format("'%s' is not the name of an implementation of service %s nor is it a valid fully qualified class name."));
	}
}
