package net.peachjean.commons.base.service;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;

import net.peachjean.commons.base.constructor.ConstructorSignatures;

/**
 * Utility used by generated {service}Factory classes.
 * @param <T>
 */
public class ServiceImplementation<T>
{
	private Class<T> serviceType;
	private Class<? extends T> implementationType;

	public ServiceImplementation(final Class<T> serviceType, final Class<? extends T> implementationType)
	{
		this.serviceType = serviceType;
		this.implementationType = implementationType;
	}

	public T instantiate(Object ... args)
	{
		final Class<?>[] argTypes = ConstructorSignatures.forService(serviceType);
		try
		{
			Constructor<? extends T> constructor = implementationType.getConstructor(argTypes);
			return constructor.newInstance(args);
		}
		catch (NoSuchMethodException e)
		{
			throw new ServiceInstantiationException(serviceType, implementationType, e);
		}
		catch (InvocationTargetException e)
		{
			throw new ServiceInstantiationException(serviceType, implementationType, e);
		}
		catch (InstantiationException e)
		{
			throw new ServiceInstantiationException(serviceType, implementationType, e);
		}
		catch (IllegalAccessException e)
		{
			throw new ServiceInstantiationException(serviceType, implementationType, e);
		}
	}
}
