package net.peachjean.commons.base.service;

import java.io.IOException;
import java.io.Writer;
import java.util.List;

import javax.lang.model.element.TypeElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ErrorType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.NoType;
import javax.lang.model.type.NullType;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.type.WildcardType;
import javax.lang.model.util.Elements;
import javax.lang.model.util.SimpleTypeVisitor6;
import javax.lang.model.util.Types;

import net.peachjean.commons.base.constructor.ConstructorSignatureProcessor;

import com.google.common.collect.Lists;
import com.google.common.io.Closeables;
import com.google.common.io.OutputSupplier;

import org.antlr.stringtemplate.AutoIndentWriter;
import org.antlr.stringtemplate.StringTemplate;
import org.antlr.stringtemplate.StringTemplateGroup;

class ServiceDescriptor
{
	public static final String TEMPLATE_PATH =
			ServiceDescriptor.class.getPackage().getName().replaceAll("\\.", "/") + "/";

	private String packageName;
	private String simpleName;
	private List<List<ArgDescriptor>> constructorArgList;

	ServiceDescriptor(final String packageName, final String simpleName,
	                  final Iterable<ConstructorSignatureProcessor.ConstructorRequirement> constructorRequirements)
	{
		this.packageName = packageName;
		this.simpleName = simpleName;
		this.constructorArgList = Lists.newArrayList();
		int index = 0;
		for(ConstructorSignatureProcessor.ConstructorRequirement constructorRequirement: constructorRequirements)
		{
			List<ArgDescriptor> argList = Lists.newArrayList();
			for(TypeMirror argType: constructorRequirement.getParams())
			{
				argList.add(new ArgDescriptor( argType.toString(), "arg" + index++));
			}
			this.constructorArgList.add(argList);
		}
	}

	public String getPackageName()
	{
		return packageName;
	}

	public String getSimpleName()
	{
		return simpleName;
	}

	public List<List<ArgDescriptor>> getConstructorArgList()
	{
		return constructorArgList;
	}

	public void generateSource(OutputSupplier<Writer> writerSupplier)
			throws IOException
	{
		StringTemplateGroup stGroup = new StringTemplateGroup("parameterResolver")
		{
			@Override
			public String getFileNameFromTemplateName(final String templateName)
			{
				return TEMPLATE_PATH + super.getFileNameFromTemplateName(templateName);
			}
		};
		StringTemplate typeTemplate = stGroup.getInstanceOf("factoryClass");
		typeTemplate.setAttribute("serviceType", this);
		Writer writer = writerSupplier.getOutput();
		try
		{
			typeTemplate.write(new AutoIndentWriter(writer, "\n"));
		}
		finally
		{
			Closeables.close(writer, false);
		}
	}

	private static class ArgDescriptor
	{
		private String type;
		private String name;

		ArgDescriptor(final String type, final String name)
		{
			this.type = type;
			this.name = name;
		}

		public String getType()
		{
			return type;
		}

		public String getName()
		{
			return name;
		}
	}
}
