package net.peachjean.commons.base.service;

import java.lang.annotation.ElementType;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.Target;

import static java.lang.annotation.RetentionPolicy.*;

/**
 * When a class ({@code serviceType}) is annotated as a service, the compiler will generate a class
 * {@code ${serviceType}Factory}. Service implementations are discovered in the {@link java.util.ServiceLoader} standard manner}.
 * <br/>
 * This class will have a static method {@code instantiate(String implementation)} that returns an implementation. If the
 * serviceType has {@link net.peachjean.commons.base.constructor.ConstructorSignature constructor arguments} specified, then
 * the signature of the static method will have the required constructor arguments added after the implementation.
 * <br/>
 * This class will also have a static method {@code create(String implementation)} which returns an instance of
 * {@code ${serviceType}Factory}.  The factory class itself will have a method {@code create()} that returns an
 * implementation.  Like the static create method, the signature will be augmented if required constructor arguments
 * are specified.
 *
 * The implementation parameter to the create methods is either the name ({@see ServiceName}) of an implementation or a
 * fully qualified class name.
 *
 * {@see ExampleService} and {@see ExampleServiceFactory} for examples of a service with a constructor signature, and
 * the generated factory.
 */
@Retention(RUNTIME)
@Target(ElementType.TYPE)
@Inherited
public @interface Service
{
}
