package net.peachjean.commons.base.service;

public class ExampleServiceFactory {

	public static final Class<ExampleService> SERVICE_TYPE = ExampleService.class;
	private static final ServiceLoader<ExampleService> SERVICE_LOADER = new ServiceLoader<ExampleService>(SERVICE_TYPE);

	private final ServiceImplementation<? extends ExampleService> implementation;

	public ExampleServiceFactory(final ServiceImplementation<? extends ExampleService> implementation)
	{
		this.implementation = implementation;
	}

	public ExampleService create(java.lang.String arg0, java.util.Properties arg1)
	{
		return implementation.instantiate(arg0, arg1);
	}

	public static ExampleServiceFactory create(String name)
	{
		final ServiceImplementation<? extends ExampleService> implementation = SERVICE_LOADER.lookup(name);
		return new ExampleServiceFactory(implementation);
	}

	public static ExampleService create(String name, java.lang.String arg0, java.util.Properties arg1)
	{
		return create(name).create(arg0, arg1);
	}

}