package net.peachjean.commons.base.constructor;

import java.lang.annotation.Annotation;
import java.util.Set;

import javax.lang.model.element.TypeElement;

import com.google.common.base.Optional;
import com.google.common.collect.Sets;

public class ConstructorSignatures
{
	private ConstructorSignatures(){}

	public static Class<?>[] forService(Class<?> serviceType)
	{
		Optional<ConstructorSignature> args = getConstructorArgs(serviceType);
		if(!args.isPresent())
		{
			throw new IllegalArgumentException("No constructor signature defined for " + serviceType.getName());
		}
		return args.get().value();
	}

	private static Optional<ConstructorSignature> getConstructorArgs(final Class<?> serviceType)
	{
		for(Annotation annotation: serviceType.getAnnotations())
		{
			if(annotation instanceof ConstructorSignature)
			{
				return Optional.of((ConstructorSignature) annotation);
			}
			Optional<ConstructorSignature> applied = getConstructorArgs(annotation.getClass());
			if(applied.isPresent())
			{
				return applied;
			}
		}
		return Optional.absent();
	}
}
