/*
 * Decompiled with CFR 0.152.
 */
package net.paissad.tools.reqcoco.runner;

import ch.qos.logback.classic.Level;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.regex.Pattern;
import net.paissad.tools.reqcoco.api.exception.ReqReportBuilderException;
import net.paissad.tools.reqcoco.api.model.Requirement;
import net.paissad.tools.reqcoco.api.report.ReqReportBuilder;
import net.paissad.tools.reqcoco.api.report.ReqReportConfig;
import net.paissad.tools.reqcoco.core.report.ReqReportBuilderConsole;
import net.paissad.tools.reqcoco.core.report.ReqReportBuilderExcel;
import net.paissad.tools.reqcoco.core.report.ReqReportBuilderHtml;
import net.paissad.tools.reqcoco.core.report.ReqReportBuilderJson;
import net.paissad.tools.reqcoco.parser.simple.api.ReqGeneratorConfig;
import net.paissad.tools.reqcoco.parser.simple.exception.ReqGeneratorConfigException;
import net.paissad.tools.reqcoco.parser.simple.exception.ReqGeneratorExecutionException;
import net.paissad.tools.reqcoco.parser.simple.impl.AbstractReqGenerator;
import net.paissad.tools.reqcoco.parser.simple.impl.SimpleReqGeneratorConfig;
import net.paissad.tools.reqcoco.parser.simple.spi.ReqDeclParser;
import net.paissad.tools.reqcoco.parser.simple.spi.ReqDeclParserProvider;
import net.paissad.tools.reqcoco.runner.ExitStatus;
import net.paissad.tools.reqcoco.runner.ReqRunnerOptions;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.kohsuke.args4j.CmdLineParser;
import org.slf4j.ILoggerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zeroturnaround.zip.ZipUtil;

public class ReqRunner {
    private static final Logger LOGGER = LoggerFactory.getLogger(ReqRunner.class);
    private static final String LOGGER_PREFIX_TAG = String.format("%-15s -", "[ReqRunner]");
    private ReqRunnerOptions options = new ReqRunnerOptions();

    public static void main(String ... args) {
        ReqRunner reqRunner = new ReqRunner();
        int parseArgsStatus = reqRunner.parseArguments(args);
        if (ExitStatus.OK.getCode() == parseArgsStatus && !reqRunner.getOptions().isHelp()) {
            System.exit(reqRunner.generateReports());
        } else {
            System.exit(parseArgsStatus);
        }
    }

    public int parseArguments(String ... args) {
        ReqRunner.setLoggingLevelSafely("INFO");
        CmdLineParser parser = null;
        try {
            parser = this.getOptions().parseOptions(args);
            this.getOptions().parseConfigFile();
        }
        catch (Exception e) {
            LOGGER.trace(LOGGER_PREFIX_TAG + " An error occured while parsing the options", (Throwable)e);
            return this.getExitCode(ExitStatus.OPTIONS_PARSING_ERROR);
        }
        if (this.getOptions().isHelp()) {
            ReqRunnerOptions.printUsage(parser);
        }
        return this.getExitCode(ExitStatus.OK);
    }

    public int generateReports() {
        if (this.getRunner().getOptions().getLogLevel() != null) {
            ReqRunner.setLoggingLevelSafely(this.getRunner().getOptions().getLogLevel());
        }
        try {
            File rawCoverageFile = Paths.get(this.getOptions().getOutputFolder(), this.buildRawCoverageFileName()).toFile();
            AbstractReqGenerator reqCoverageGenerator = new AbstractReqGenerator(){};
            SimpleReqGeneratorConfig coverageGeneratorCfg = new SimpleReqGeneratorConfig();
            coverageGeneratorCfg.setExtraOptions(ReqRunnerOptions.mapFromProperties(this.getOptions().getConfigProperties()));
            coverageGeneratorCfg.setSourceRequirements(this.getReqSourceURI());
            if (this.getOptions().isCreateRawReportFile()) {
                LOGGER.info("{} The raw report coverage file will be created at '{}'", (Object)LOGGER_PREFIX_TAG, (Object)rawCoverageFile);
                coverageGeneratorCfg.setCoverageOutput(rawCoverageFile.toPath());
            } else {
                LOGGER.debug("{} Skip the creation of the raw report coverage file.", (Object)LOGGER_PREFIX_TAG);
            }
            coverageGeneratorCfg.setSourceCodePath(Paths.get(this.getOptions().getSourceCodePath(), new String[0]));
            coverageGeneratorCfg.setTestsCodePath(Paths.get(this.getOptions().getTestCodePath(), new String[0]));
            String parserIdentitfier = this.getOptions().getSourceType();
            ReqDeclParser reqDeclParser = ReqDeclParserProvider.getInstance().getParserHavingIdentifier(parserIdentitfier);
            if (reqDeclParser == null) {
                throw new ReqGeneratorConfigException("Unable to find a requirements declarations parser with the following identifier --> " + parserIdentitfier, null);
            }
            coverageGeneratorCfg.setSourceParser(reqDeclParser);
            coverageGeneratorCfg.getFileIncludes().addAll(Arrays.asList(this.getOptions().getResourceIncludes().split(",")));
            coverageGeneratorCfg.getFileExcludes().addAll(Arrays.asList(this.getOptions().getResourceExcludes().split(",")));
            coverageGeneratorCfg.getIgnoreList().addAll(Arrays.asList(this.getOptions().getIgnores().split(",")));
            reqCoverageGenerator.configure((ReqGeneratorConfig)coverageGeneratorCfg);
            Collection requirements = reqCoverageGenerator.run();
            Collection<ReqReportBuilder> reportBuilders = this.getReportBuilders(this.getOptions());
            this.runReportBuilders(reportBuilders, requirements);
        }
        catch (URISyntaxException e) {
            String errrMsg = LOGGER_PREFIX_TAG + " Error while building the URI from the specified source of declared requiremets : " + e.getMessage();
            LOGGER.error(errrMsg, (Throwable)e);
            return this.getExitCode(ExitStatus.URI_BUILD_ERROR);
        }
        catch (IOException e) {
            String errMsg = "Error while creating the temporary/intermediate coverage report : " + e.getMessage();
            LOGGER.error(LOGGER_PREFIX_TAG + " " + errMsg, (Throwable)e);
            return this.getExitCode(ExitStatus.I_O_ERROR);
        }
        catch (ReqReportBuilderException | ReqGeneratorConfigException | ReqGeneratorExecutionException e) {
            String errMsg = "Error while building the report : " + e.getMessage();
            LOGGER.error(LOGGER_PREFIX_TAG + " " + errMsg, e);
            return this.getExitCode(ExitStatus.BUILD_REPORT_ERROR);
        }
        return this.getExitCode(ExitStatus.OK);
    }

    private String buildRawCoverageFileName() {
        String reportName = this.getOptions().getReportName();
        return (StringUtils.isBlank((CharSequence)reportName) ? "REPORT-requirements" : reportName) + ".xml";
    }

    private URI getReqSourceURI() throws URISyntaxException, IOException {
        String reqSource = this.getOptions().getRequirementSource();
        if (Pattern.compile("^.*?:/").matcher(reqSource).find()) {
            return new URI(reqSource);
        }
        return new URI("file:/" + new File(reqSource).getCanonicalPath().replace("\\", "/").replaceFirst("^/+", ""));
    }

    private ReqRunner getRunner() {
        return this;
    }

    private void runReportBuilders(Collection<ReqReportBuilder> reportBuilders, Collection<Requirement> requirements) throws ReqReportBuilderException {
        ReqReportConfig reqReportConfig = new ReqReportConfig();
        String filteredVersions = this.getOptions().getVersionsInclude();
        for (ReqReportBuilder reportBuilder : reportBuilders) {
            LOGGER.info("{} Running report builder", (Object)LOGGER_PREFIX_TAG);
            if (!StringUtils.isBlank((CharSequence)filteredVersions)) {
                reqReportConfig.setFilteredVersions(Arrays.asList(filteredVersions.split("\\s*,\\s*")));
            }
            reportBuilder.configure(requirements, reqReportConfig);
            reportBuilder.run();
            LOGGER.info("{} Finished running report builder", (Object)LOGGER_PREFIX_TAG);
        }
        if (this.getOptions().isReportZip() && this.getReportOutputDirPath(this.getOptions()).toFile().list().length != 0) {
            String zipFilename = (StringUtils.isBlank((CharSequence)this.getOptions().getReportName()) ? "REPORT-requirements" : this.getOptions().getReportName()) + ".zip";
            Path zipFilePath = Paths.get(this.getReportOutputDirPath(this.getOptions()).toString(), zipFilename);
            LOGGER.info("{} Archive all reports into a single .zip file : {}", (Object)LOGGER_PREFIX_TAG, (Object)zipFilePath);
            File temporaryZipFile = null;
            try {
                temporaryZipFile = Files.createTempFile("reqcoco", "zip", new FileAttribute[0]).toFile();
                FileUtils.deleteQuietly((File)zipFilePath.toFile());
                ZipUtil.pack((File)this.getReportOutputDirPath(this.getOptions()).toFile(), (File)temporaryZipFile);
                Files.move(temporaryZipFile.toPath(), zipFilePath, new CopyOption[0]);
            }
            catch (Exception e) {
                try {
                    throw new ReqReportBuilderException("Error while creating the report zip file", e);
                }
                catch (Throwable throwable) {
                    FileUtils.deleteQuietly(temporaryZipFile);
                    throw throwable;
                }
            }
            FileUtils.deleteQuietly((File)temporaryZipFile);
        }
    }

    private Collection<ReqReportBuilder> getReportBuilders(ReqRunnerOptions options) {
        LinkedList<ReqReportBuilder> reportBuilders = new LinkedList<ReqReportBuilder>();
        if (this.getOptions().isReportConsole()) {
            LOGGER.debug("{} Including console report", (Object)LOGGER_PREFIX_TAG);
            reportBuilders.add((ReqReportBuilder)new ReqReportBuilderConsole());
        }
        if (this.getOptions().isReportJson()) {
            LOGGER.debug("{} Including JSON report", (Object)LOGGER_PREFIX_TAG);
            Path jsonReportOutputDirPath = Paths.get(this.getReportOutputDirPath(options).toString(), "json");
            ReqReportBuilderJson jsonReportBuilder = StringUtils.isBlank((CharSequence)options.getReportName()) ? new ReqReportBuilderJson(jsonReportOutputDirPath) : new ReqReportBuilderJson(jsonReportOutputDirPath, options.getReportName() + ".json");
            reportBuilders.add((ReqReportBuilder)jsonReportBuilder);
        }
        if (this.getOptions().isReportHtml()) {
            LOGGER.debug("{} Including HTML report", (Object)LOGGER_PREFIX_TAG);
            Path htmlReportOutputDirPath = Paths.get(this.getReportOutputDirPath(options).toString(), "html");
            ReqReportBuilderHtml htmlReportBuilder = StringUtils.isBlank((CharSequence)options.getReportName()) ? new ReqReportBuilderHtml(htmlReportOutputDirPath) : new ReqReportBuilderHtml(htmlReportOutputDirPath, options.getReportName() + ".html");
            reportBuilders.add((ReqReportBuilder)htmlReportBuilder);
        }
        if (this.getOptions().isReportExcel()) {
            LOGGER.debug("{} Including EXCEL report", (Object)LOGGER_PREFIX_TAG);
            Path excelReportOutputDirPath = Paths.get(this.getReportOutputDirPath(options).toString(), "excel");
            ReqReportBuilderExcel excelReportBuilder = StringUtils.isBlank((CharSequence)options.getReportName()) ? new ReqReportBuilderExcel(excelReportOutputDirPath) : new ReqReportBuilderExcel(excelReportOutputDirPath, options.getReportName() + ".xlsx");
            reportBuilders.add((ReqReportBuilder)excelReportBuilder);
        }
        return reportBuilders;
    }

    private Path getReportOutputDirPath(ReqRunnerOptions options) {
        return Paths.get(options.getOutputFolder(), new String[0]);
    }

    private int getExitCode(ExitStatus exitStatus) {
        return exitStatus.getCode();
    }

    private static void setLoggingLevelSafely(String logLevel) {
        ILoggerFactory loggerFactory = LoggerFactory.getILoggerFactory();
        Logger appLogger = loggerFactory.getLogger("net.paissad.tools.reqcoco");
        if (appLogger instanceof ch.qos.logback.classic.Logger) {
            ((ch.qos.logback.classic.Logger)appLogger).setLevel(Level.valueOf((String)logLevel));
        }
    }

    public ReqRunnerOptions getOptions() {
        return this.options;
    }
}

