/*
 * Decompiled with CFR 0.152.
 */
package net.paissad.tools.reqcoco.runner;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.paissad.tools.reqcoco.parser.redmine.RedmineReqDeclParser;
import org.apache.commons.lang3.StringUtils;
import org.kohsuke.args4j.Argument;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;
import org.kohsuke.args4j.Option;
import org.kohsuke.args4j.ParserProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReqRunnerOptions {
    private static final Logger LOGGER = LoggerFactory.getLogger(ReqRunnerOptions.class);
    public static final String CONFIG_LOG_LEVEL = "log.level";
    public static final String CONFIG_SOURCE_CODE_PATH = "code.source.path";
    public static final String CONFIG_TEST_CODE_PATH = "code.test.path";
    public static final String CONFIG_RESOURCE_INCLUDES = "resource.includes";
    public static final String CONFIG_RESOURCE_EXCLUDES = "resource.excludes";
    public static final String CONFIG_REQUIREMENT_IGNORES = "requirement.ignores";
    public static final String CONFIG_REPORT_CONSOLE = "report.console";
    public static final String CONFIG_REPORT_HTML = "report.html";
    public static final String CONFIG_REPORT_EXCEL = "report.excel";
    public static final String CONFIG_REPORT_JSON = "report.json";
    public static final String CONFIG_REPORT_ZIP = "report.zip";
    public static final String CONFIG_CREATE_RAW_REPORT_FILE = "create.raw.report.file";
    private String logLevel;
    private String sourceCodePath;
    private String testCodePath;
    private String resourceIncludes;
    private String resourceExcludes;
    private String ignores;
    private boolean reportConsole;
    private boolean reportHtml;
    private boolean reportExcel;
    private boolean reportJson;
    private boolean reportZip;
    private boolean createRawReportFile;
    private Properties configProperties;
    @Option(name="-h", aliases={"--help"}, help=true, usage="Shows the help.")
    private boolean help;
    @Option(name="--config", required=true, usage="The configuration file.")
    private File configFile;
    @Option(name="--input-type", required=true, usage="The type of the requirements source declaration.")
    private String sourceType;
    @Option(name="--input", required=true, metaVar="<input>", usage="Source containing the requirements to parse.")
    private String requirementSource;
    @Option(name="--output", required=true, metaVar="<dir>", usage="Directory where to store the coverage reports.")
    private String outputFolder;
    @Option(name="--report-name", required=false, metaVar="[name]", usage="The name of the report file. The default value is 'REPORT-requirements'")
    private String reportName;
    @Argument
    private List<String> arguments = new ArrayList<String>();

    public CmdLineParser parseOptions(String ... args) throws CmdLineException {
        CmdLineParser parser = new CmdLineParser((Object)this);
        ParserProperties.defaults().withUsageWidth(150);
        try {
            parser.parseArgument(args);
        }
        catch (CmdLineException e) {
            System.err.println();
            System.err.println("======> " + e.getMessage());
            System.err.println();
            ReqRunnerOptions.printUsage(parser);
            throw e;
        }
        return parser;
    }

    public void parseConfigFile() throws IOException {
        try (InputStream in = Files.newInputStream(this.getConfigFile().toPath(), new OpenOption[0]);){
            this.setConfigProperties(new Properties());
            this.getConfigProperties().load(in);
            this.buildOptionsFromProperties(this.getConfigProperties());
            this.updatePropertiesForRedmine(this.getConfigProperties());
            this.updatePropertiesForGithub(this.getConfigProperties());
        }
        catch (IOException | NullPointerException e) {
            String errMsg = "Error while parsing the configuration file : " + e.getMessage();
            LOGGER.error(errMsg, (Throwable)e);
            throw new IOException(errMsg, e);
        }
    }

    private void buildOptionsFromProperties(Properties props) {
        this.setLogLevel(props.getProperty(CONFIG_LOG_LEVEL, "INFO"));
        this.setSourceCodePath(props.getProperty(CONFIG_SOURCE_CODE_PATH));
        this.setTestCodePath(props.getProperty(CONFIG_TEST_CODE_PATH));
        this.setResourceIncludes(props.getProperty(CONFIG_RESOURCE_INCLUDES, "*"));
        this.setResourceExcludes(props.getProperty(CONFIG_RESOURCE_EXCLUDES, ""));
        this.setIgnores(props.getProperty(CONFIG_REQUIREMENT_IGNORES, ""));
        this.setReportConsole(Boolean.parseBoolean(props.getProperty(CONFIG_REPORT_CONSOLE, Boolean.FALSE.toString())));
        this.setReportHtml(Boolean.parseBoolean(props.getProperty(CONFIG_REPORT_HTML, Boolean.TRUE.toString())));
        this.setReportExcel(Boolean.parseBoolean(props.getProperty(CONFIG_REPORT_EXCEL, Boolean.TRUE.toString())));
        this.setReportJson(Boolean.parseBoolean(props.getProperty(CONFIG_REPORT_JSON, Boolean.TRUE.toString())));
        this.setReportZip(Boolean.parseBoolean(props.getProperty(CONFIG_REPORT_ZIP, Boolean.TRUE.toString())));
        this.setCreateRawReportFile(Boolean.parseBoolean(props.getProperty(CONFIG_CREATE_RAW_REPORT_FILE, Boolean.FALSE.toString())));
    }

    private void updatePropertiesForRedmine(Properties props) {
        String statusFilter = StringUtils.isBlank((CharSequence)props.getProperty("redmine.status.filter")) ? "*" : props.getProperty("redmine.status.filter");
        props.put("redmine.status.filter", statusFilter);
        boolean includeChildren = StringUtils.isBlank((CharSequence)props.getProperty("redmine.include.children")) ? true : Boolean.parseBoolean(props.getProperty("redmine.include.children"));
        props.put("redmine.include.children", (Object)includeChildren);
        boolean includeRelations = StringUtils.isBlank((CharSequence)props.getProperty("redmine.include.relations")) ? true : Boolean.parseBoolean(props.getProperty("redmine.include.relations"));
        props.put("redmine.include.relations", (Object)includeRelations);
        Set targetVersions = StringUtils.isBlank((CharSequence)((String)props.get("redmine.target.versions"))) ? RedmineReqDeclParser.getDefautValueForTargetVersions() : Arrays.asList(props.get("redmine.target.versions").toString().split(","));
        props.put("redmine.target.versions", targetVersions);
        boolean reqTagMustBePresent = StringUtils.isBlank((CharSequence)props.getProperty("redmine.req.tag.required")) ? false : Boolean.parseBoolean(props.getProperty("redmine.req.tag.required"));
        props.put("redmine.req.tag.required", (Object)reqTagMustBePresent);
        Properties redmineExtraProperties = this.getRedmineExtraProperties();
        if (redmineExtraProperties != null) {
            props.put("redmine.extra.properties", redmineExtraProperties);
        }
    }

    public Properties getRedmineExtraProperties() {
        return this.getComplexProperties("redmine.extra.properties");
    }

    private void updatePropertiesForGithub(Properties props) {
        Properties githubIssuesFilters = this.getComplexProperties("github.issues.filter");
        if (githubIssuesFilters != null) {
            props.put("github.issues.filter", githubIssuesFilters.entrySet().stream().collect(Collectors.toMap(e -> (String)e.getKey(), e -> (String)e.getValue())));
        }
    }

    private Properties getComplexProperties(String prefix) {
        Properties complexProps = null;
        Predicate<String> predicate = Pattern.compile(Pattern.quote(prefix + ".key.")).asPredicate();
        Set filterKeys = this.getConfigProperties().keySet().stream().map(Object::toString).filter(predicate).collect(Collectors.toSet());
        if (!filterKeys.isEmpty()) {
            complexProps = new Properties();
            for (String key : filterKeys) {
                String suffix = key.substring((prefix + ".key.").length(), key.length());
                String extraPropsKey = this.getConfigProperties().getProperty(key);
                String extraPropsValue = this.getConfigProperties().getProperty(prefix + ".value." + suffix);
                complexProps.put(extraPropsKey, extraPropsValue);
            }
        }
        return complexProps;
    }

    public static Map<String, Object> mapFromProperties(Properties properties) {
        return properties.keySet().stream().map(Object::toString).collect(Collectors.toMap(Function.identity(), properties::get));
    }

    public static void printUsage(CmdLineParser parser) {
        System.out.println("reqcoco-runner [options...] arguments...");
        parser.printUsage((OutputStream)System.out);
        System.out.println();
        System.out.println("  Example: reqcoco-runner " + parser.printExample(filter -> !filter.option.help()));
    }

    public String getLogLevel() {
        return this.logLevel;
    }

    public String getSourceCodePath() {
        return this.sourceCodePath;
    }

    public String getTestCodePath() {
        return this.testCodePath;
    }

    public String getResourceIncludes() {
        return this.resourceIncludes;
    }

    public String getResourceExcludes() {
        return this.resourceExcludes;
    }

    public String getIgnores() {
        return this.ignores;
    }

    public boolean isReportConsole() {
        return this.reportConsole;
    }

    public boolean isReportHtml() {
        return this.reportHtml;
    }

    public boolean isReportExcel() {
        return this.reportExcel;
    }

    public boolean isReportJson() {
        return this.reportJson;
    }

    public boolean isReportZip() {
        return this.reportZip;
    }

    public boolean isCreateRawReportFile() {
        return this.createRawReportFile;
    }

    public Properties getConfigProperties() {
        return this.configProperties;
    }

    public boolean isHelp() {
        return this.help;
    }

    public File getConfigFile() {
        return this.configFile;
    }

    public String getSourceType() {
        return this.sourceType;
    }

    public String getRequirementSource() {
        return this.requirementSource;
    }

    public String getOutputFolder() {
        return this.outputFolder;
    }

    public String getReportName() {
        return this.reportName;
    }

    public List<String> getArguments() {
        return this.arguments;
    }

    public void setLogLevel(String logLevel) {
        this.logLevel = logLevel;
    }

    public void setSourceCodePath(String sourceCodePath) {
        this.sourceCodePath = sourceCodePath;
    }

    public void setTestCodePath(String testCodePath) {
        this.testCodePath = testCodePath;
    }

    public void setResourceIncludes(String resourceIncludes) {
        this.resourceIncludes = resourceIncludes;
    }

    public void setResourceExcludes(String resourceExcludes) {
        this.resourceExcludes = resourceExcludes;
    }

    public void setIgnores(String ignores) {
        this.ignores = ignores;
    }

    public void setReportConsole(boolean reportConsole) {
        this.reportConsole = reportConsole;
    }

    public void setReportHtml(boolean reportHtml) {
        this.reportHtml = reportHtml;
    }

    public void setReportExcel(boolean reportExcel) {
        this.reportExcel = reportExcel;
    }

    public void setReportJson(boolean reportJson) {
        this.reportJson = reportJson;
    }

    public void setReportZip(boolean reportZip) {
        this.reportZip = reportZip;
    }

    public void setCreateRawReportFile(boolean createRawReportFile) {
        this.createRawReportFile = createRawReportFile;
    }

    public void setConfigProperties(Properties configProperties) {
        this.configProperties = configProperties;
    }

    public void setHelp(boolean help) {
        this.help = help;
    }

    public void setConfigFile(File configFile) {
        this.configFile = configFile;
    }

    public void setSourceType(String sourceType) {
        this.sourceType = sourceType;
    }

    public void setRequirementSource(String requirementSource) {
        this.requirementSource = requirementSource;
    }

    public void setOutputFolder(String outputFolder) {
        this.outputFolder = outputFolder;
    }

    public void setReportName(String reportName) {
        this.reportName = reportName;
    }

    public void setArguments(List<String> arguments) {
        this.arguments = arguments;
    }
}

