/*
 * Decompiled with CFR 0.152.
 */
package net.paissad.tools.reqcoco.core.report;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import net.paissad.tools.reqcoco.api.exception.ReqReportBuilderException;
import net.paissad.tools.reqcoco.api.model.Requirement;
import net.paissad.tools.reqcoco.api.report.ReqReportConfig;
import net.paissad.tools.reqcoco.core.report.AbstractReqReportBuilder;
import net.paissad.tools.reqcoco.core.report.ReqReport;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReqReportBuilderJson
extends AbstractReqReportBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(ReqReportBuilderJson.class);
    public static final String JSON_REPORT_FILE_DEFAULT_EXTENSION = ".json";
    private static final String LOGGER_PREFIX_TAG = String.format("%-15s -", "[JsonReport]");
    private Path jsonReportFilePath;
    private Path reportOutputDirPath;
    private String reportFilename;

    public ReqReportBuilderJson(Path reportOutputDirPath) {
        this(reportOutputDirPath, null);
    }

    public ReqReportBuilderJson(Path reportOutputDirPath, String reportFilename) {
        this.reportOutputDirPath = reportOutputDirPath;
        this.reportFilename = StringUtils.isBlank((CharSequence)reportFilename) ? this.getDefaultReportFilename() : reportFilename;
    }

    @Override
    public void configure(Collection<Requirement> requirements, ReqReportConfig config) throws ReqReportBuilderException {
        super.configure(requirements, config);
        this.setJsonReportFilePath(Paths.get(this.getReportOutputDirPath().toString(), this.getReportFilename()));
        LOGGER.debug("{} JSON report file path --> {}", (Object)LOGGER_PREFIX_TAG, (Object)this.getJsonReportFilePath());
        try {
            Files.createDirectories(this.getReportOutputDirPath(), new FileAttribute[0]);
        }
        catch (Exception e) {
            throw new ReqReportBuilderException("Error while creating parent directories which are supposed to contain the JSON report file", e);
        }
    }

    public void run() throws ReqReportBuilderException {
        try (OutputStreamWriter out = new OutputStreamWriter((OutputStream)new BufferedOutputStream(new FileOutputStream(this.getJsonReportFilePath().toFile()), 8192), StandardCharsets.UTF_8);){
            LOGGER.info("{} Starting to generate JSON report to the directory --> {}", (Object)LOGGER_PREFIX_TAG, (Object)this.getReportOutputDirPath());
            Collection<ReqReport> reqReports = this.buildReqReports();
            Gson gson = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().excludeFieldsWithoutExposeAnnotation().create();
            GlobalJsonReport globalJsonReport = new GlobalJsonReport();
            globalJsonReport.setReqReportConfig(this.getReportConfig());
            globalJsonReport.setReports(reqReports);
            gson.toJson((Object)globalJsonReport, (Appendable)out);
            LOGGER.info("{} Finished generating JSON report", (Object)LOGGER_PREFIX_TAG);
        }
        catch (IOException e) {
            String errMsg = "Error while building JSON report : " + e.getMessage();
            LOGGER.error(errMsg, (Throwable)e);
            throw new ReqReportBuilderException(errMsg, (Exception)e);
        }
    }

    @Override
    protected String getDefaultFileReportExtension() {
        return JSON_REPORT_FILE_DEFAULT_EXTENSION;
    }

    private Path getJsonReportFilePath() {
        return this.jsonReportFilePath;
    }

    private void setJsonReportFilePath(Path jsonReportFilePath) {
        this.jsonReportFilePath = jsonReportFilePath;
    }

    private Path getReportOutputDirPath() {
        return this.reportOutputDirPath;
    }

    private String getReportFilename() {
        return this.reportFilename;
    }

    private static class GlobalJsonReport {
        @Expose
        @SerializedName(value="reports")
        private Collection<ReqReport> reports;
        @Expose
        @SerializedName(value="metadata")
        private ReqReportConfig reqReportConfig;

        private GlobalJsonReport() {
        }

        public Collection<ReqReport> getReports() {
            return this.reports;
        }

        public ReqReportConfig getReqReportConfig() {
            return this.reqReportConfig;
        }

        public void setReports(Collection<ReqReport> reports) {
            this.reports = reports;
        }

        public void setReqReportConfig(ReqReportConfig reqReportConfig) {
            this.reqReportConfig = reqReportConfig;
        }
    }
}

