/*
 * Decompiled with CFR 0.152.
 */
package net.paissad.tools.reqcoco.core.report;

import java.io.OutputStream;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.paissad.tools.reqcoco.api.exception.ReqReportBuilderException;
import net.paissad.tools.reqcoco.api.model.Requirement;
import net.paissad.tools.reqcoco.api.model.Requirements;
import net.paissad.tools.reqcoco.api.report.ReqReportBuilder;
import net.paissad.tools.reqcoco.api.report.ReqReportConfig;
import net.paissad.tools.reqcoco.core.report.ReqReport;

public abstract class AbstractReqReportBuilder
implements ReqReportBuilder {
    public static final String DEFAULT_REPORT_FILENAME_WITHOUT_EXTENSION = "REPORT-requirements";
    private Collection<Requirement> requirements;
    private ReqReportConfig reportConfig;
    private ReqReportConfig defaultReportConfig;
    private OutputStream output;

    public void configure(Collection<Requirement> requirements, ReqReportConfig config) throws ReqReportBuilderException {
        ReqReportConfig cfg = config == null ? this.getDefaultReportConfig() : config;
        this.setReportConfig(cfg);
        if (cfg.getFilteredVersions() == null || cfg.getFilteredVersions().isEmpty()) {
            this.setRequirements(requirements);
        } else {
            List<Requirement> filteredRequirements = requirements.stream().filter(req -> cfg.getFilteredVersions().contains(req.getVersion())).collect(Collectors.toList());
            this.setRequirements(filteredRequirements);
        }
    }

    protected long getCodeDoneCount() {
        return this.getRequirements().stream().filter(req -> !req.isCodeIgnore() && req.isCodeDone()).count();
    }

    protected long getCodeUndoneCount() {
        return (long)this.getRequirements().size() - this.getCodeDoneCount() - this.getIgnoredRequirementsCount();
    }

    protected long getCodeDoneCount(String version) {
        return this.getRequirementByVersion(version).stream().filter(req -> !req.isCodeIgnore() && req.isCodeDone()).count();
    }

    protected long getCodeUndoneCount(String version) {
        return (long)this.getRequirementByVersion(version).size() - this.getCodeDoneCount(version) - this.getIgnoredRequirementsCount(version);
    }

    protected Float getCodeDoneRatio() {
        return Float.valueOf((float)this.getCodeDoneCount() / (float)this.getRequirements().size());
    }

    protected Float getCodeDoneRatio(String version) {
        return Float.valueOf((float)this.getCodeDoneCount(version) / (float)this.getRequirementByVersion(version).size());
    }

    protected long getTestsDoneCount() {
        return this.getRequirements().stream().filter(req -> !req.isCodeIgnore() && req.isTestDone()).count();
    }

    protected long getTestsUndoneCount() {
        return (long)this.getRequirements().size() - this.getTestsDoneCount() - this.getIgnoredRequirementsCount();
    }

    protected long getTestsDoneCount(String version) {
        return this.getRequirementByVersion(version).stream().filter(req -> !req.isCodeIgnore() && req.isTestDone()).count();
    }

    protected long getTestsUndoneCount(String version) {
        return (long)this.getRequirementByVersion(version).size() - this.getTestsDoneCount(version) - this.getIgnoredRequirementsCount(version);
    }

    protected Float getTestDoneRatio() {
        return Float.valueOf((float)this.getTestsDoneCount() / (float)this.getRequirements().size());
    }

    protected Float getTestDoneRatio(String version) {
        return Float.valueOf((float)this.getTestsDoneCount(version) / (float)this.getRequirementByVersion(version).size());
    }

    protected long getIgnoredRequirementsCount() {
        Collection<Requirement> reqs = this.getRequirements();
        return reqs.stream().filter(Requirement::isIgnore).count();
    }

    protected long getIgnoredRequirementsCount(String version) {
        Collection<Requirement> reqs = this.getRequirementByVersion(version);
        return reqs.stream().filter(Requirement::isIgnore).count();
    }

    protected Collection<Requirement> getRequirementByVersion(String version) {
        return Requirements.getByVersion(this.getRequirements(), (String)version);
    }

    protected ReqReportConfig getDefaultReportConfig() {
        if (this.defaultReportConfig == null) {
            this.defaultReportConfig = new ReqReportConfig();
        }
        return this.defaultReportConfig;
    }

    protected float getRequirementsIgnoredRatio(String version) {
        return 1.0f * (float)this.getIgnoredRequirementsCount(version) / (float)this.getRequirementByVersion(version).size();
    }

    protected Collection<ReqReport> buildReqReports() {
        LinkedHashSet<ReqReport> reqReports = new LinkedHashSet<ReqReport>();
        Stream<String> versions = this.getRequirements().stream().map(Requirement::getVersion).distinct();
        versions.sorted().forEach(version -> {
            ReqReport reqReport = new ReqReport();
            Collection reqs = Requirements.getByVersion(this.getRequirements(), (String)version);
            reqReport.setVersion((String)version);
            reqReport.setTotalRequirements(reqs.size());
            reqReport.setRequirements(reqs);
            reqReport.setCodeDoneCount(this.getCodeDoneCount((String)version));
            reqReport.setCodeUndoneCount(this.getCodeUndoneCount((String)version));
            reqReport.setCodeDoneRatio(this.getCodeDoneRatio((String)version).floatValue());
            reqReport.setTestsDoneCount(this.getTestsDoneCount((String)version));
            reqReport.setTestsUndoneCount(this.getTestsUndoneCount((String)version));
            reqReport.setTestsDoneRatio(this.getTestDoneRatio((String)version).floatValue());
            reqReport.setIgnoredRequirementsCount(this.getIgnoredRequirementsCount((String)version));
            reqReport.setIgnoredRequirementsRatio(this.getRequirementsIgnoredRatio((String)version));
            reqReports.add(reqReport);
        });
        return reqReports;
    }

    protected String getDefaultReportFilename() {
        return DEFAULT_REPORT_FILENAME_WITHOUT_EXTENSION + this.getDefaultFileReportExtension();
    }

    protected abstract String getDefaultFileReportExtension();

    protected Collection<Requirement> getRequirements() {
        return this.requirements;
    }

    private void setRequirements(Collection<Requirement> requirements) {
        this.requirements = requirements;
    }

    public ReqReportConfig getReportConfig() {
        return this.reportConfig;
    }

    public void setReportConfig(ReqReportConfig reportConfig) {
        this.reportConfig = reportConfig;
    }

    protected OutputStream getOutput() {
        return this.output;
    }

    protected void setOutput(OutputStream output) {
        this.output = output;
    }
}

