/*
 * Decompiled with CFR 0.152.
 */
package net.paissad.tools.reqcoco.core.parser;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Unmarshaller;
import net.paissad.tools.reqcoco.api.exception.ReqReportParserException;
import net.paissad.tools.reqcoco.api.model.Requirement;
import net.paissad.tools.reqcoco.api.model.Requirements;
import net.paissad.tools.reqcoco.api.parser.ReqReportParser;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractReqReportParser
implements ReqReportParser {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractReqReportParser.class);
    private boolean sourceAlreadyParsed = false;
    private SOURCE_TYPE sourceType;
    private Requirements cachedRequirements;

    public Requirements getRequirements() throws ReqReportParserException {
        try {
            if (!this.isSourceAlreadyParsed()) {
                this.setSource(this.getURI(), this.getOptions());
                JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{Requirements.class});
                Unmarshaller u = jaxbContext.createUnmarshaller();
                switch (this.getSourceType()) {
                    case FILE: {
                        File f = Paths.get(this.getURI()).toFile();
                        this.setCachedRequirements((Requirements)u.unmarshal(f));
                        break;
                    }
                    case URL: {
                        URL url = this.getURI().toURL();
                        this.setCachedRequirements((Requirements)u.unmarshal(url));
                        break;
                    }
                }
                this.sanitizeRequirements();
            }
            return this.getCachedRequirements();
        }
        catch (Exception e) {
            String errMsg = "Error while retrieving requirements from the source : " + e.getMessage();
            LOGGER.error(errMsg, (Throwable)e);
            throw new ReqReportParserException(errMsg, e);
        }
    }

    public Collection<Requirement> getRequirements(String version) throws ReqReportParserException {
        return Requirements.getByVersion((Collection)this.getRequirements().getRequirements(), (String)version);
    }

    public void setSource(URI uri, Map<String, Object> options) throws IOException {
        if (uri == null) {
            throw new NullPointerException("The URI to parse should is null");
        }
        if (uri.getScheme() == null) {
            throw new NullPointerException("The scheme of the URI is null. Here is the URI --> " + uri.toString());
        }
        if (uri.getScheme().matches("(?i)^https{0,1}$")) {
            this.setSourceType(SOURCE_TYPE.URL);
        } else if (uri.getScheme().matches("(?i)^file$")) {
            this.setSourceType(SOURCE_TYPE.FILE);
        } else {
            throw new UnsupportedOperationException("Unable to parse source from the scheme type --> " + uri.getScheme());
        }
        this.setSourceAlreadyParsed(true);
    }

    private void sanitizeRequirements() {
        this.getCachedRequirements().getRequirements().stream().forEach(req -> {
            if (StringUtils.isBlank((CharSequence)req.getVersion())) {
                req.setVersion("N/A");
            }
            if (req.getCodeStatus() == null) {
                req.setCodeStatus(Requirement.DEFAULT_STATUS);
            }
            if (req.getTestStatus() == null) {
                req.setTestStatus(Requirement.DEFAULT_STATUS);
            }
        });
    }

    protected abstract URI getURI() throws URISyntaxException;

    protected abstract Map<String, Object> getOptions();

    private boolean isSourceAlreadyParsed() {
        return this.sourceAlreadyParsed;
    }

    private void setSourceAlreadyParsed(boolean sourceAlreadyParsed) {
        this.sourceAlreadyParsed = sourceAlreadyParsed;
    }

    private SOURCE_TYPE getSourceType() {
        return this.sourceType;
    }

    private void setSourceType(SOURCE_TYPE sourceType) {
        this.sourceType = sourceType;
    }

    private Requirements getCachedRequirements() {
        return this.cachedRequirements;
    }

    private void setCachedRequirements(Requirements cachedRequirements) {
        this.cachedRequirements = cachedRequirements;
    }

    private static enum SOURCE_TYPE {
        FILE,
        URL;

    }
}

