/*
 * Decompiled with CFR 0.152.
 */
package net.paissad.tools.reqcoco.core.report;

import java.awt.Color;
import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.text.DecimalFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import net.paissad.tools.reqcoco.api.exception.ReqReportBuilderException;
import net.paissad.tools.reqcoco.api.model.Requirement;
import net.paissad.tools.reqcoco.api.model.Requirements;
import net.paissad.tools.reqcoco.api.report.ReqReportConfig;
import net.paissad.tools.reqcoco.core.report.AbstractReqReportBuilder;
import net.paissad.tools.reqcoco.core.report.CellConfig;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.common.usermodel.HyperlinkType;
import org.apache.poi.hssf.usermodel.HeaderFooter;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CreationHelper;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.Footer;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.Hyperlink;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.PrintSetup;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.WorkbookUtil;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFColor;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReqReportBuilderExcel
extends AbstractReqReportBuilder {
    private static final int DEFAULT_ZOOM_SCALE = 100;
    public static final String EXCEL_REPORT_FILE_DEFAULT_EXTENSION = ".xlsx";
    private static final Logger LOGGER = LoggerFactory.getLogger(ReqReportBuilderExcel.class);
    private static final String LOGGER_PREFIX_TAG = String.format("%-15s -", "[ExcelReport]");
    private static final int HEADERS_ROW_POSITION = 0;
    private String reportFilename;
    private Path reportOutputDirPath;

    public ReqReportBuilderExcel(Path reportOutputDirPath) {
        this(reportOutputDirPath, null);
    }

    public ReqReportBuilderExcel(Path reportOutputDirPath, String reportFilename) {
        this.reportOutputDirPath = reportOutputDirPath;
        this.reportFilename = StringUtils.isBlank((CharSequence)reportFilename) ? this.getDefaultReportFilename() : reportFilename;
    }

    @Override
    public void configure(Collection<Requirement> requirements, ReqReportConfig config) throws ReqReportBuilderException {
        super.configure(requirements, config);
        try {
            Files.createDirectories(this.getReportOutputDirPath(), new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new ReqReportBuilderException("Error while creating the directory which is supposed to contain the EXCEL coverage report", (Exception)e);
        }
    }

    public void run() throws ReqReportBuilderException {
        Path excelOutputFile = Paths.get(this.getReportOutputDirPath().toString(), this.getReportFilename());
        LOGGER.info("{} Starting to generate EXCEL report to the file --> {}", (Object)LOGGER_PREFIX_TAG, (Object)excelOutputFile);
        try (BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(excelOutputFile.toFile()), 8192);
             XSSFWorkbook workbook = new XSSFWorkbook();){
            List versions = this.getRequirements().stream().map(Requirement::getVersion).distinct().collect(Collectors.toList());
            Collections.sort(versions);
            int summaryCurrentRowIndex = 5;
            this.createOrUpdateSummarySheet((Workbook)workbook, null, summaryCurrentRowIndex);
            for (String version : versions) {
                Collection reqs = Requirements.getByVersion(this.getRequirements(), (String)version).stream().sorted().collect(Collectors.toList());
                this.createOrUpdateSummarySheet((Workbook)workbook, version, summaryCurrentRowIndex);
                summaryCurrentRowIndex += 6;
                Sheet sheet = workbook.createSheet(WorkbookUtil.createSafeSheetName((String)("Version " + version)));
                sheet.setZoom(100);
                PrintSetup ps = sheet.getPrintSetup();
                sheet.setAutobreaks(true);
                ps.setFitHeight((short)1);
                ps.setFitWidth((short)1);
                this.createHeaders((Workbook)workbook, sheet);
                int rowIndex = 1;
                for (Requirement req : reqs) {
                    Row row = sheet.createRow(rowIndex++);
                    this.populateRow((Workbook)workbook, row, req);
                }
                Footer footer = sheet.getFooter();
                footer.setRight("Page " + HeaderFooter.page() + " of " + HeaderFooter.numPages());
            }
            LOGGER.trace("{} Creating the .xlsx file -> {}", (Object)LOGGER_PREFIX_TAG, (Object)excelOutputFile);
            workbook.write((OutputStream)out);
            LOGGER.info("{} Finished generating EXCEL report", (Object)LOGGER_PREFIX_TAG);
        }
        catch (Exception e) {
            String errMsg = "Error while building the EXCEL coverage report : " + e.getMessage();
            LOGGER.error(errMsg, (Throwable)e);
            throw new ReqReportBuilderException(errMsg, e);
        }
    }

    private void createOrUpdateSummarySheet(Workbook wb, String version, int rowStartPosition) {
        Sheet sheet = wb.getSheet("Summary");
        if (sheet == null) {
            sheet = wb.createSheet(WorkbookUtil.createSafeSheetName((String)"Summary"));
            CreationHelper creationHelper = wb.getCreationHelper();
            Font font = wb.createFont();
            XSSFCellStyle cellStyle = (XSSFCellStyle)wb.createCellStyle();
            Row rowTitle = sheet.createRow(0);
            cellStyle.setAlignment(HorizontalAlignment.CENTER);
            cellStyle.setFillForegroundColor(IndexedColors.CORNFLOWER_BLUE.getIndex());
            cellStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
            font.setBold(true);
            cellStyle.setFont(font);
            Cell cellTitle = rowTitle.createCell(4);
            cellTitle.setCellValue(creationHelper.createRichTextString(this.getDefaultReportConfig().getTitle()));
            cellTitle.setCellStyle((CellStyle)cellStyle);
            sheet.autoSizeColumn(cellTitle.getColumnIndex());
            Row rowTotalOfReqsForAllVersions = sheet.createRow(3);
            Cell cellTotalOfReqs = rowTotalOfReqsForAllVersions.createCell(0);
            cellTotalOfReqs.setCellValue(creationHelper.createRichTextString("Total of requirements : " + this.getRequirements().size()));
            cellTotalOfReqs.getCellStyle().setFont(font);
            sheet.autoSizeColumn(cellTotalOfReqs.getColumnIndex());
            sheet.setZoom(100);
        }
        if (!StringUtils.isBlank((CharSequence)version)) {
            this.updateSummarySheet(wb, sheet, version, rowStartPosition);
        }
    }

    private void createHeaders(Workbook wb, Sheet sheet) {
        Row row = sheet.createRow(0);
        XSSFCellStyle cellStyle = (XSSFCellStyle)wb.createCellStyle();
        cellStyle.setAlignment(HorizontalAlignment.CENTER);
        cellStyle.setFillForegroundColor(new XSSFColor(Color.LIGHT_GRAY));
        cellStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        Font headerFont = wb.createFont();
        headerFont.setBold(true);
        cellStyle.setFont(headerFont);
        CreationHelper creationHelper = wb.getCreationHelper();
        for (CellConfig cellConfig : CellConfig.values()) {
            Cell cell = row.createCell(cellConfig.position);
            cell.setCellValue(creationHelper.createRichTextString(cellConfig.header));
            ReqReportBuilderExcel.addBordersToCellStyle(cellStyle, BorderStyle.MEDIUM);
            cell.setCellStyle((CellStyle)cellStyle);
            sheet.autoSizeColumn(cellConfig.position);
        }
    }

    private void updateSummarySheet(Workbook wb, Sheet sheet, String version, int rowStartPosition) {
        this.createCodeCoverageSummary(wb, sheet, rowStartPosition, CODE_TYPE.SOURCE, version);
        this.createCodeCoverageSummary(wb, sheet, rowStartPosition, CODE_TYPE.TEST, version);
    }

    private void createCodeCoverageSummary(Workbook wb, Sheet sheet, int rowStartPosition, CODE_TYPE codeType, String version) {
        CreationHelper creationHelper = wb.getCreationHelper();
        XSSFCellStyle cellStyle = (XSSFCellStyle)wb.createCellStyle();
        cellStyle.setAlignment(HorizontalAlignment.CENTER);
        cellStyle.setFillForegroundColor(new XSSFColor(Color.LIGHT_GRAY));
        cellStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        ReqReportBuilderExcel.addBordersToCellStyle(cellStyle, BorderStyle.MEDIUM);
        Font font = wb.createFont();
        font.setBold(true);
        cellStyle.setFont(font);
        XSSFCellStyle cellStyleTitle = (XSSFCellStyle)wb.createCellStyle();
        cellStyleTitle.setAlignment(HorizontalAlignment.CENTER);
        cellStyleTitle.setFillForegroundColor(IndexedColors.CORNFLOWER_BLUE.getIndex());
        cellStyleTitle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        ReqReportBuilderExcel.addBordersToCellStyle(cellStyleTitle, BorderStyle.MEDIUM);
        cellStyleTitle.setFont(font);
        XSSFCellStyle cellStyleVersion = (XSSFCellStyle)wb.createCellStyle();
        cellStyleVersion.setAlignment(HorizontalAlignment.CENTER);
        cellStyleVersion.setFillForegroundColor(IndexedColors.CORNFLOWER_BLUE.getIndex());
        cellStyleVersion.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        cellStyleVersion.setBorderTop(BorderStyle.MEDIUM);
        cellStyleVersion.setBorderBottom(BorderStyle.MEDIUM);
        cellStyleVersion.setFont(font);
        Row rowVersion = sheet.getRow(rowStartPosition);
        if (rowVersion == null) {
            rowVersion = sheet.createRow(rowStartPosition);
        }
        for (int i = 0; i < 9; ++i) {
            Cell cell = rowVersion.createCell(i);
            cell.setCellStyle((CellStyle)cellStyleVersion);
        }
        Cell cellVersion = rowVersion.getCell(4);
        cellVersion.setCellValue(creationHelper.createRichTextString("Version " + version));
        sheet.autoSizeColumn(cellVersion.getColumnIndex());
        int columnOffset = 0;
        Row rowCodeCoverageTitle = sheet.getRow(rowStartPosition + 1);
        if (rowCodeCoverageTitle != null) {
            columnOffset += 5;
        } else {
            rowCodeCoverageTitle = sheet.createRow(rowStartPosition + 1);
        }
        Cell cellCodeCoverateTitle = rowCodeCoverageTitle.createCell(columnOffset);
        if (CODE_TYPE.SOURCE == codeType) {
            cellCodeCoverateTitle.setCellValue(creationHelper.createRichTextString(this.getDefaultReportConfig().getCodeCoverageDiagramName()));
        } else {
            cellCodeCoverateTitle.setCellValue(creationHelper.createRichTextString(this.getDefaultReportConfig().getTestsCoverageDiagramName()));
        }
        cellCodeCoverateTitle.setCellStyle((CellStyle)cellStyleTitle);
        Cell cellCodeDoneTitle = rowCodeCoverageTitle.createCell(columnOffset + 1);
        cellCodeDoneTitle.setCellValue(creationHelper.createRichTextString("Done"));
        cellCodeDoneTitle.setCellStyle((CellStyle)cellStyle);
        Cell cellCodeUndoneTitle = rowCodeCoverageTitle.createCell(columnOffset + 2);
        cellCodeUndoneTitle.setCellValue(creationHelper.createRichTextString("Undone"));
        cellCodeUndoneTitle.setCellStyle((CellStyle)cellStyle);
        Cell cellReqIgnoredTitle = rowCodeCoverageTitle.createCell(columnOffset + 3);
        cellReqIgnoredTitle.setCellValue(creationHelper.createRichTextString("Ignored"));
        cellReqIgnoredTitle.setCellStyle((CellStyle)cellStyle);
        Row rowTotalCount = sheet.getRow(rowStartPosition + 2);
        if (rowTotalCount == null) {
            rowTotalCount = sheet.createRow(rowStartPosition + 2);
        }
        Cell cellCountTitle = rowTotalCount.createCell(columnOffset);
        cellCountTitle.setCellStyle((CellStyle)cellStyle);
        cellCountTitle.setCellValue(creationHelper.createRichTextString("Total"));
        Row rowPercentage = sheet.getRow(rowStartPosition + 3);
        if (rowPercentage == null) {
            rowPercentage = sheet.createRow(rowStartPosition + 3);
        }
        Cell cellPercentageTitle = rowPercentage.createCell(columnOffset);
        cellPercentageTitle.setCellStyle((CellStyle)cellStyle);
        cellPercentageTitle.setCellValue(creationHelper.createRichTextString("%"));
        XSSFCellStyle cellStyleDone = (XSSFCellStyle)wb.createCellStyle();
        cellStyleDone.setAlignment(HorizontalAlignment.CENTER);
        cellStyleDone.setFillForegroundColor(new XSSFColor(Color.GREEN));
        cellStyleDone.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        ReqReportBuilderExcel.addBordersToCellStyle(cellStyleDone, BorderStyle.THIN);
        Cell cellDoneCount = rowTotalCount.createCell(columnOffset + 1);
        cellDoneCount.setCellStyle((CellStyle)cellStyleDone);
        if (CODE_TYPE.SOURCE == codeType) {
            long codeDoneCount = this.getCodeDoneCount(version);
            cellDoneCount.setCellValue(creationHelper.createRichTextString(String.valueOf(codeDoneCount)));
        } else if (CODE_TYPE.TEST == codeType) {
            long testsDoneCount = this.getTestsDoneCount(version);
            cellDoneCount.setCellValue(creationHelper.createRichTextString(String.valueOf(testsDoneCount)));
        }
        Cell cellDonePercentage = rowPercentage.createCell(columnOffset + 1);
        cellDonePercentage.setCellStyle((CellStyle)cellStyleDone);
        if (CODE_TYPE.SOURCE == codeType) {
            cellDonePercentage.setCellValue(creationHelper.createRichTextString(this.formatRatioIntoPercentage(this.getCodeDoneRatio(version).floatValue())));
        } else if (CODE_TYPE.TEST == codeType) {
            cellDonePercentage.setCellValue(creationHelper.createRichTextString(this.formatRatioIntoPercentage(this.getTestDoneRatio(version).floatValue())));
        }
        boolean setColor = false;
        XSSFCellStyle cellStyleUndone = (XSSFCellStyle)wb.createCellStyle();
        cellStyleUndone.setAlignment(HorizontalAlignment.CENTER);
        ReqReportBuilderExcel.addBordersToCellStyle(cellStyleUndone, BorderStyle.THIN);
        Cell cellUndoneCount = rowTotalCount.createCell(columnOffset + 2);
        cellUndoneCount.setCellStyle((CellStyle)cellStyleUndone);
        if (CODE_TYPE.SOURCE == codeType) {
            long codeUndoneCount = this.getCodeUndoneCount(version);
            setColor = codeUndoneCount > 0L;
            cellUndoneCount.setCellValue(creationHelper.createRichTextString(String.valueOf(codeUndoneCount)));
        } else if (CODE_TYPE.TEST == codeType) {
            long testsUndoneCount = this.getTestsUndoneCount(version);
            setColor = testsUndoneCount > 0L;
            cellUndoneCount.setCellValue(creationHelper.createRichTextString(String.valueOf(testsUndoneCount)));
        }
        if (setColor) {
            cellStyleUndone.setFillForegroundColor(new XSSFColor(Color.RED));
            cellStyleUndone.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        }
        Cell cellUndonePercentage = rowPercentage.createCell(columnOffset + 2);
        cellUndonePercentage.setCellStyle((CellStyle)cellStyleUndone);
        if (CODE_TYPE.SOURCE == codeType) {
            cellUndonePercentage.setCellValue(creationHelper.createRichTextString(this.formatRatioIntoPercentage(1.0f - this.getCodeDoneRatio(version).floatValue() - this.getRequirementsIgnoredRatio(version))));
        } else if (CODE_TYPE.TEST == codeType) {
            cellUndonePercentage.setCellValue(creationHelper.createRichTextString(this.formatRatioIntoPercentage(1.0f - this.getTestDoneRatio(version).floatValue() - this.getRequirementsIgnoredRatio(version))));
        }
        XSSFCellStyle cellStyleIgnore = (XSSFCellStyle)wb.createCellStyle();
        cellStyleIgnore.setAlignment(HorizontalAlignment.CENTER);
        ReqReportBuilderExcel.addBordersToCellStyle(cellStyleIgnore, BorderStyle.THIN);
        Cell cellIgnoreCount = rowTotalCount.createCell(columnOffset + 3);
        cellIgnoreCount.setCellStyle((CellStyle)cellStyleIgnore);
        long ignoredRequirementsCount = this.getIgnoredRequirementsCount(version);
        boolean bl = setColor = ignoredRequirementsCount > 0L;
        if (setColor) {
            cellStyleIgnore.setFillForegroundColor(new XSSFColor(Color.YELLOW));
            cellStyleIgnore.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        }
        cellIgnoreCount.setCellValue(creationHelper.createRichTextString(String.valueOf(ignoredRequirementsCount)));
        Cell cellIgnorePercentage = rowPercentage.createCell(columnOffset + 3);
        cellIgnorePercentage.setCellStyle((CellStyle)cellStyleIgnore);
        cellIgnorePercentage.setCellValue(creationHelper.createRichTextString(this.formatRatioIntoPercentage(this.getRequirementsIgnoredRatio(version))));
        sheet.autoSizeColumn(columnOffset);
    }

    private String formatRatioIntoPercentage(float ratio) {
        return new DecimalFormat("##.#").format(ratio * 100.0f) + " %";
    }

    private void populateRow(Workbook wb, Row row, Requirement req) {
        Sheet currentSheet = row.getSheet();
        for (CellConfig cellConfig : CellConfig.values()) {
            Cell cell = row.createCell(cellConfig.position);
            Cell headerCell = currentSheet.getRow(0).getCell(cellConfig.position);
            CellStyle headerCellStyle = headerCell.getCellStyle();
            Font cellFont = wb.createFont();
            CreationHelper creationHelper = wb.getCreationHelper();
            String cellContent = this.getRequirementFieldValue(cellConfig.position, req);
            XSSFColor cellColor = new XSSFColor(Color.WHITE);
            switch (cellConfig) {
                case CODE: {
                    cellColor = ReqReportBuilderExcel.getColorForDoneCell(req.isIgnore(), req.isCodeDone());
                    break;
                }
                case TEST: {
                    cellColor = ReqReportBuilderExcel.getColorForDoneCell(req.isIgnore(), req.isTestDone());
                    break;
                }
                case LINK: {
                    if (StringUtils.isBlank((CharSequence)cellContent)) break;
                    this.configureHyperlinkCell(cell, cellFont, creationHelper, cellContent);
                    cellContent = "Link";
                    break;
                }
            }
            cell.setCellValue(creationHelper.createRichTextString(cellContent));
            XSSFCellStyle currentCellStyle = (XSSFCellStyle)wb.createCellStyle();
            currentCellStyle.setFillForegroundColor(cellColor);
            currentCellStyle.setFont(cellFont);
            ReqReportBuilderExcel.addBordersToCellStyle(currentCellStyle, BorderStyle.THIN);
            cell.setCellStyle((CellStyle)currentCellStyle);
            currentCellStyle.setAlignment(headerCellStyle.getAlignmentEnum());
            currentCellStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
            if (req.isIgnore() && CellConfig.CODE != cellConfig && CellConfig.TEST != cellConfig) {
                currentCellStyle.setFillForegroundColor(IndexedColors.DARK_YELLOW.getIndex());
                currentCellStyle.setFillPattern(FillPatternType.FINE_DOTS);
            }
            currentSheet.autoSizeColumn(cellConfig.position);
        }
    }

    private void configureHyperlinkCell(Cell cell, Font cellFont, CreationHelper creationHelper, String cellContent) {
        cellFont.setUnderline((byte)1);
        cellFont.setColor(IndexedColors.BLUE.getIndex());
        Hyperlink link = creationHelper.createHyperlink(HyperlinkType.URL);
        link.setAddress(cellContent);
        cell.setHyperlink(link);
    }

    private static void addBordersToCellStyle(XSSFCellStyle currentCellStyle, BorderStyle borderStyle) {
        currentCellStyle.setBorderTop(borderStyle);
        currentCellStyle.setBorderBottom(borderStyle);
        currentCellStyle.setBorderLeft(borderStyle);
        currentCellStyle.setBorderRight(borderStyle);
    }

    private static XSSFColor getColorForDoneCell(boolean ignore, boolean done) {
        if (ignore) {
            return new XSSFColor(Color.YELLOW);
        }
        return done ? new XSSFColor(Color.GREEN) : new XSSFColor(Color.RED);
    }

    private String getRequirementFieldValue(int position, Requirement requirement) {
        switch (position) {
            case 0: {
                return requirement.getName();
            }
            case 1: {
                return requirement.getVersion();
            }
            case 2: {
                return requirement.getRevision();
            }
            case 3: {
                return requirement.getShortDescription();
            }
            case 4: {
                String codeDoneMsg = requirement.isCodeDone() ? "OK" : "KO";
                return requirement.isIgnore() ? "Ignore" : codeDoneMsg;
            }
            case 5: {
                return requirement.getCodeAuthor();
            }
            case 6: {
                String testDoneMsg = requirement.isTestDone() ? "OK" : "KO";
                return requirement.isIgnore() ? "Ignore" : testDoneMsg;
            }
            case 7: {
                return requirement.getTestAuthor();
            }
            case 8: {
                return requirement.getLink();
            }
        }
        throw new IllegalStateException("The position " + position + " is not handled for the Excel report !!!");
    }

    @Override
    protected String getDefaultFileReportExtension() {
        return EXCEL_REPORT_FILE_DEFAULT_EXTENSION;
    }

    private String getReportFilename() {
        return this.reportFilename;
    }

    private Path getReportOutputDirPath() {
        return this.reportOutputDirPath;
    }

    private static enum CODE_TYPE {
        SOURCE,
        TEST;

    }
}

