/*
 * Decompiled with CFR 0.152.
 */
package net.paissad.tools.reqcoco.core.report;

import java.io.OutputStream;
import java.util.Collection;
import java.util.LinkedList;
import net.paissad.tools.reqcoco.api.exception.ReqReportBuilderException;
import net.paissad.tools.reqcoco.api.model.Requirement;
import net.paissad.tools.reqcoco.api.model.Requirements;
import net.paissad.tools.reqcoco.api.report.ReqReportBuilder;
import net.paissad.tools.reqcoco.api.report.ReqReportConfig;

public abstract class AbstractReqReportBuilder
implements ReqReportBuilder {
    public static final String DEFAULT_REPORT_FILENAME_WITHOUT_EXTENSION = "REPORT-requirements";
    private Collection<Requirement> requirements = new LinkedList<Requirement>();
    private ReqReportConfig reportConfig;
    private ReqReportConfig defaultReportConfig;
    private OutputStream output;

    public void configure(Collection<Requirement> requirements, ReqReportConfig config) throws ReqReportBuilderException {
        this.getRequirements().addAll(requirements);
        ReqReportConfig cfg = config == null ? this.getDefaultReportConfig() : config;
        this.setReportConfig(cfg);
    }

    protected long getCodeDoneCount() {
        return this.getRequirements().stream().filter(req -> !req.isIgnore() && req.isCodeDone()).count();
    }

    protected long getCodeUndoneCount() {
        return (long)this.getRequirements().size() - this.getCodeDoneCount() - this.getIgnoredRequirementsCount();
    }

    protected long getCodeDoneCount(String version) {
        return this.getRequirementByVersion(version).stream().filter(req -> !req.isIgnore() && req.isCodeDone()).count();
    }

    protected long getCodeUndoneCount(String version) {
        return (long)this.getRequirementByVersion(version).size() - this.getCodeDoneCount(version) - this.getIgnoredRequirementsCount(version);
    }

    protected Float getCodeDoneRatio() {
        return Float.valueOf((float)this.getCodeDoneCount() / (float)this.getRequirements().size());
    }

    protected Float getCodeDoneRatio(String version) {
        return Float.valueOf((float)this.getCodeDoneCount(version) / (float)this.getRequirementByVersion(version).size());
    }

    protected long getTestsDoneCount() {
        return this.getRequirements().stream().filter(req -> !req.isIgnore() && req.isTestDone()).count();
    }

    protected long getTestsUndoneCount() {
        return (long)this.getRequirements().size() - this.getTestsDoneCount() - this.getIgnoredRequirementsCount();
    }

    protected long getTestsDoneCount(String version) {
        return this.getRequirementByVersion(version).stream().filter(req -> !req.isIgnore() && req.isTestDone()).count();
    }

    protected long getTestsUndoneCount(String version) {
        return (long)this.getRequirementByVersion(version).size() - this.getTestsDoneCount(version) - this.getIgnoredRequirementsCount(version);
    }

    protected Float getTestDoneRatio() {
        return Float.valueOf((float)this.getTestsDoneCount() / (float)this.getRequirements().size());
    }

    protected Float getTestDoneRatio(String version) {
        return Float.valueOf((float)this.getTestsDoneCount(version) / (float)this.getRequirementByVersion(version).size());
    }

    protected long getIgnoredRequirementsCount() {
        Collection<Requirement> reqs = this.getRequirements();
        return reqs.stream().filter(Requirement::isIgnore).count();
    }

    protected long getIgnoredRequirementsCount(String version) {
        Collection<Requirement> reqs = this.getRequirementByVersion(version);
        return reqs.stream().filter(Requirement::isIgnore).count();
    }

    protected Collection<Requirement> getRequirementByVersion(String version) {
        return Requirements.getByVersion(this.getRequirements(), (String)version);
    }

    protected ReqReportConfig getDefaultReportConfig() {
        if (this.defaultReportConfig == null) {
            this.defaultReportConfig = new ReqReportConfig(){};
        }
        return this.defaultReportConfig;
    }

    protected String getDefaultReportFilename() {
        return DEFAULT_REPORT_FILENAME_WITHOUT_EXTENSION + this.getDefaultFileReporttExtension();
    }

    protected abstract String getDefaultFileReporttExtension();

    protected Collection<Requirement> getRequirements() {
        return this.requirements;
    }

    public ReqReportConfig getReportConfig() {
        return this.reportConfig;
    }

    public void setReportConfig(ReqReportConfig reportConfig) {
        this.reportConfig = reportConfig;
    }

    protected OutputStream getOutput() {
        return this.output;
    }

    protected void setOutput(OutputStream output) {
        this.output = output;
    }
}

