/*
 * Decompiled with CFR 0.152.
 */
package net.paissad.tools.reqcoco.core.report;

import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import freemarker.template.TemplateExceptionHandler;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Stream;
import net.paissad.tools.reqcoco.api.exception.ReqReportBuilderException;
import net.paissad.tools.reqcoco.api.model.Requirement;
import net.paissad.tools.reqcoco.api.model.Requirements;
import net.paissad.tools.reqcoco.api.report.ReqReportConfig;
import net.paissad.tools.reqcoco.core.report.AbstractReqReportBuilder;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zeroturnaround.zip.ZipUtil;

public class ReqReportBuilderHtml
extends AbstractReqReportBuilder {
    public static final String HTML_REPORT_FILE_DEFAULT_EXTENSION = ".html";
    private static final Logger LOGGER = LoggerFactory.getLogger(ReqReportBuilderHtml.class);
    private static final String LOGGER_PREFIX_TAG = String.format("%-15s -", "[HtmlReport]");
    private static final String TEMPLATES_REPORTS_HTML_LOCATION = "/templates/reports/html";
    private Path htmlReportFilePath;
    private Configuration templateConfig;
    private Path reportOutputDirPath;
    private String reportFilename;

    public ReqReportBuilderHtml(Path reportOutputDirPath) {
        this(reportOutputDirPath, null);
    }

    public ReqReportBuilderHtml(Path reportOutputDirPath, String reportFilename) {
        this.reportOutputDirPath = reportOutputDirPath;
        this.reportFilename = StringUtils.isBlank((CharSequence)reportFilename) ? this.getDefaultReportFilename() : reportFilename;
        this.initTemplateFormatter();
    }

    private void initTemplateFormatter() {
        LOGGER.debug("{} Initializing HTML template formatter", (Object)LOGGER_PREFIX_TAG);
        this.templateConfig = new Configuration(Configuration.VERSION_2_3_26);
        this.templateConfig.setDefaultEncoding("UTF-8");
        this.templateConfig.setLocale(Locale.US);
        this.templateConfig.setTemplateExceptionHandler(TemplateExceptionHandler.RETHROW_HANDLER);
        this.templateConfig.setLogTemplateExceptions(false);
        this.templateConfig.setClassForTemplateLoading(this.getClass(), TEMPLATES_REPORTS_HTML_LOCATION);
        LOGGER.debug("{} Finished initialization of HTML template formatter", (Object)LOGGER_PREFIX_TAG);
    }

    @Override
    public void configure(Collection<Requirement> requirements, ReqReportConfig config) throws ReqReportBuilderException {
        super.configure(requirements, config);
        this.setHtmlReportFilePath(Paths.get(this.getReportOutputDirPath().toString(), this.getReportFilename()));
        LOGGER.debug("{} HTML report file path --> {}", (Object)LOGGER_PREFIX_TAG, (Object)this.getHtmlReportFilePath());
        try {
            Files.createDirectories(this.getReportOutputDirPath(), new FileAttribute[0]);
        }
        catch (Exception e) {
            throw new ReqReportBuilderException("Error while creating parent directories which are supposed to contain the HTML report file", e);
        }
    }

    public void run() throws ReqReportBuilderException {
        try (OutputStreamWriter out = new OutputStreamWriter((OutputStream)new BufferedOutputStream(new FileOutputStream(this.getHtmlReportFilePath().toFile()), 8192), StandardCharsets.UTF_8);){
            LOGGER.info("{} Starting to generate HTML report to the directory --> {}", (Object)LOGGER_PREFIX_TAG, (Object)this.getReportOutputDirPath());
            Template template = this.templateConfig.getTemplate("template.html");
            LOGGER.trace("{} Unzipping HTML lib which is to be used for the HTML report file", (Object)LOGGER_PREFIX_TAG);
            ZipUtil.unpack((InputStream)this.getClass().getResourceAsStream("/templates/reports/html/lib.zip"), (File)this.getReportOutputDirPath().toFile());
            LOGGER.debug("{} Replacing the tokens into the HTML report template ...", (Object)LOGGER_PREFIX_TAG);
            template.process(this.getDataModel(), (Writer)out);
            LOGGER.info("{} Finished generating HTML report", (Object)LOGGER_PREFIX_TAG);
        }
        catch (TemplateException | IOException e) {
            String errMsg = "Error while building HTML report : " + e.getMessage();
            LOGGER.error(errMsg, e);
            throw new ReqReportBuilderException(errMsg, (Exception)e);
        }
    }

    @Override
    protected String getDefaultFileReporttExtension() {
        return HTML_REPORT_FILE_DEFAULT_EXTENSION;
    }

    private Map<String, Object> getDataModel() {
        LOGGER.trace("{} Building data model to use for the template", (Object)LOGGER_PREFIX_TAG);
        HashMap<String, Object> model = new HashMap<String, Object>();
        HashMap requirementsMap = new HashMap();
        StringBuilder dataCode = new StringBuilder();
        StringBuilder dataTests = new StringBuilder();
        Stream<String> versions = this.getRequirements().stream().map(Requirement::getVersion).distinct();
        versions.sorted().forEach(version -> {
            requirementsMap.put(version, Requirements.getByVersion(this.getRequirements(), (String)version));
            long reqsIgnoredCount = this.getIgnoredRequirementsCount((String)version);
            long codeDoneCount = this.getCodeDoneCount((String)version);
            long codeUndoneCount = this.getCodeUndoneCount((String)version);
            long testsDoneCount = this.getTestsDoneCount((String)version);
            long testsUndoneCount = this.getTestsUndoneCount((String)version);
            String dataSetEntryFormat = "{Version:'Version %s',freq:{Done:%s, Undone:%s, Ignored:%s}},\n";
            dataCode.append(String.format("{Version:'Version %s',freq:{Done:%s, Undone:%s, Ignored:%s}},\n", version, codeDoneCount, codeUndoneCount, reqsIgnoredCount));
            dataTests.append(String.format("{Version:'Version %s',freq:{Done:%s, Undone:%s, Ignored:%s}},\n", version, testsDoneCount, testsUndoneCount, reqsIgnoredCount));
        });
        model.put("coverage_title", this.getReportConfig().getTitle());
        model.put("code_coverage_diagram_name", this.getReportConfig().getCodeCoverageDiagramName());
        model.put("tests_coverage_diagram_name", this.getReportConfig().getTestsCoverageDiagramName());
        model.put("coverage_table_legend_name", this.getReportConfig().getRequirementsTableLegend());
        model.put("dataCode", dataCode.toString());
        model.put("dataTests", dataTests.toString());
        model.put("requirements", this.getRequirements());
        LOGGER.trace("{} Finished building data model for the template", (Object)LOGGER_PREFIX_TAG);
        return model;
    }

    private Path getHtmlReportFilePath() {
        return this.htmlReportFilePath;
    }

    private void setHtmlReportFilePath(Path htmlReportFilePath) {
        this.htmlReportFilePath = htmlReportFilePath;
    }

    private Path getReportOutputDirPath() {
        return this.reportOutputDirPath;
    }

    private String getReportFilename() {
        return this.reportFilename;
    }
}

