/*
 * Decompiled with CFR 0.152.
 */
package net.paissad.tools.reqcoco.core.report;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.Collection;
import net.paissad.tools.reqcoco.api.exception.ReqReportBuilderException;
import net.paissad.tools.reqcoco.api.model.Requirement;
import net.paissad.tools.reqcoco.api.report.ReqReportConfig;
import net.paissad.tools.reqcoco.core.report.AbstractReqReportBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReqReportBuilderConsole
extends AbstractReqReportBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(ReqReportBuilderConsole.class);
    private static final String LOGGER_PREFIX_TAG = String.format("%-15s -", "[ConsoleReport]");
    private static final Charset UTF8 = Charset.forName("UTF-8");

    @Override
    public void configure(Collection<Requirement> requirements, ReqReportConfig config) throws ReqReportBuilderException {
        super.configure(requirements, config);
        this.setOutput(System.out);
    }

    public void run() throws ReqReportBuilderException {
        if (this.getRequirements().isEmpty()) {
            LOGGER.warn("{} No requirements = no console report", (Object)LOGGER_PREFIX_TAG);
        } else {
            LOGGER.info("{} Starting to generate console report", (Object)LOGGER_PREFIX_TAG);
            try {
                OutputStream out = this.getOutput();
                out.write((this.getReportConfig().getTitle() + "\n").getBytes(UTF8));
                out.write("========================================== SUMMARY ===============================================\n".getBytes(UTF8));
                String summaryFormat = "%-25s : %s\n";
                out.write(String.format("%-25s : %s\n", "Number of requirements", this.getRequirements().size()).getBytes(UTF8));
                out.write(String.format("%-25s : %s\n", "Code done ratio", this.getCodeDoneRatio().floatValue() * 100.0f + " %").getBytes(UTF8));
                out.write(String.format("%-25s : %s\n", "Tests done ratio", this.getTestDoneRatio().floatValue() * 100.0f + " %").getBytes(UTF8));
                out.write("==================================================================================================\n".getBytes(UTF8));
                String reqListFormat = "%s\n";
                this.getRequirements().forEach(req -> this.printRequirement(out, "%s\n", (Requirement)req));
                out.write("==================================================================================================\n".getBytes(UTF8));
            }
            catch (Exception e) {
                String errMsg = "Error while building console report : " + e.getMessage();
                LOGGER.error(LOGGER_PREFIX_TAG + errMsg, (Throwable)e);
                throw new ReqReportBuilderException(errMsg, e);
            }
            LOGGER.info("Finished generating console report", (Object)LOGGER_PREFIX_TAG);
        }
    }

    private void printRequirement(OutputStream out, String reqListFormat, Requirement req) {
        try {
            out.write(String.format(reqListFormat, req.toString()).getBytes(UTF8));
        }
        catch (IOException e) {
            LOGGER.error(LOGGER_PREFIX_TAG + "Unable to print requirement having id {} : {}", (Object)req.getId(), (Object)e);
        }
    }

    @Override
    protected String getDefaultFileReporttExtension() {
        return "";
    }
}

